/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import quick.dbtable.Comparator;
import quick.dbtable.DBTable;
import quick.dbtable.Sorter;
import quick.dbtable.TableMap;

class TableSorter
extends TableMap {
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    Comparator comparator;
    Sorter sorter;

    public TableSorter(TableModel model) {
        this.setModel(model);
    }

    public void setSorter(Sorter sorter) {
        this.sorter = sorter;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        int val;
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (this.comparator != null && (val = this.comparator.compare(column, o1, o2)) != 100) {
            return val;
        }
        return DBTable.compareObject(o1, o2);
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        if (this.sorter != null) {
            this.indexes = this.sorter.sort(this.ascending, this.sortingColumns, this.model);
        } else {
            this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        }
    }

    public void n2sort() {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = i + 1;
            while (j < this.getRowCount()) {
                if (this.compare(this.indexes[i], this.indexes[j]) == -1) {
                    this.swap(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i = low;
            while (i < high) {
                to[i] = from[i];
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public void sortByColumn(Vector cols, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns = cols;
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }
}

