/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

abstract class TableMap
extends AbstractTableModel
implements TableModelListener {
    TableModel model;
    boolean isBackModelTableMap;
    TableMap backMap;
    int[] indexes = new int[0];
    boolean isFrontMostModel = true;
    TableMap frontMap;

    public void setParent(TableMap tm) {
        this.isFrontMostModel = false;
        this.frontMap = tm;
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.model = model;
        model.addTableModelListener(this);
        if (model instanceof TableMap) {
            this.isBackModelTableMap = true;
            this.backMap = (TableMap)model;
            this.backMap.setParent(this);
        }
        this.reallocateIndexes();
    }

    public Object getValueAt(int aRow, int aColumn) {
        int newRow = this.getRowFromViewToNextModel(aRow);
        if (newRow == -1) {
            return null;
        }
        Object obj = this.model.getValueAt(newRow, this.getColumnFromViewToNextModel(aColumn));
        return obj;
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        if (!this.checkRow(aRow)) {
            return;
        }
        this.model.setValueAt(aValue, this.getRowFromViewToNextModel(aRow), this.getColumnFromViewToNextModel(aColumn));
    }

    public int getRowCount() {
        this.checkModel();
        return this.indexes.length;
    }

    public int getColumnCount() {
        this.checkModel();
        int c = this.model == null ? 0 : this.model.getColumnCount();
        return c;
    }

    public String getColumnName(int aColumn) {
        return this.model.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return this.model.getColumnClass(aColumn);
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, column);
    }

    public boolean checkModel() {
        int rowCount = this.model.getRowCount();
        if (this.indexes.length != rowCount) {
            System.out.println("Table Model Error: Requested Row Count:" + this.indexes.length + " Available Row Count:" + rowCount);
            this.reallocateIndexes();
            return false;
        }
        return true;
    }

    public boolean checkRow(int row) {
        int mapRow = this.getRowFromViewToNextModel(row);
        if (mapRow == -1) {
            return false;
        }
        int rowCount = this.model.getRowCount();
        if (mapRow >= rowCount || mapRow < 0) {
            new Exception("Table Model Error: RequestedRow :" + mapRow + " Available Row Count:" + rowCount).printStackTrace();
            System.out.println("Please note row/column index starts from 0");
            return false;
        }
        return true;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
        if (!this.isFrontMostModel) {
            this.frontMap.reallocateIndexes();
        }
    }

    public int addRow(int row) {
        int rowInParentModel = row;
        if (this.isBackModelTableMap) {
            rowInParentModel = this.backMap.addRow(row);
        }
        int[] newArray = new int[this.indexes.length + 1];
        System.arraycopy(this.indexes, 0, newArray, 0, this.indexes.length);
        newArray[this.indexes.length] = rowInParentModel;
        this.indexes = null;
        this.indexes = newArray;
        if (this.isFrontMostModel) {
            this.fireTableRowsInserted(this.indexes.length - 1, this.indexes.length - 1);
            this.fireTableDataChanged();
        }
        return this.indexes.length - 1;
    }

    public int insertRow(int row, int rowInFinalModel) {
        int rowInParentModel = rowInFinalModel;
        if (this.isBackModelTableMap) {
            rowInParentModel = this.backMap.insertRow(this.getRowFromViewToNextModel(row), rowInFinalModel);
        }
        int[] newArray = new int[this.indexes.length + 1];
        if (row > 0) {
            System.arraycopy(this.indexes, 0, newArray, 0, row);
        }
        if (row <= this.indexes.length) {
            System.arraycopy(this.indexes, row, newArray, row + 1, newArray.length - row - 1);
            int i = row + 1;
            while (i < newArray.length) {
                newArray[i] = newArray[i] + 1;
                ++i;
            }
        }
        newArray[row] = rowInParentModel;
        this.indexes = null;
        this.indexes = newArray;
        if (this.isFrontMostModel) {
            this.fireTableRowsInserted(row, row);
            this.fireTableDataChanged();
        }
        return row;
    }

    public void deleteRow(int row) {
        if (this.isBackModelTableMap) {
            this.backMap.deleteRow(this.getRowFromViewToNextModel(row));
        }
        int oldRowVal = this.indexes[row];
        int[] newArray = new int[this.indexes.length - 1];
        if (row > 0) {
            System.arraycopy(this.indexes, 0, newArray, 0, row);
        }
        if (row < this.indexes.length - 1) {
            System.arraycopy(this.indexes, row + 1, newArray, row, newArray.length - row);
        }
        int i = 0;
        while (i < newArray.length) {
            if (newArray[i] > oldRowVal) {
                newArray[i] = newArray[i] - 1;
            }
            ++i;
        }
        this.indexes = null;
        this.indexes = newArray;
    }

    public int addColumn(int col) {
        return col;
    }

    public void deleteColumn(int col) {
    }

    public int getRowFromViewToNextModel(int row) {
        if (row < this.indexes.length) {
            return this.indexes[row];
        }
        new Exception("Table Model Error: RequestedRow :" + row + " Available Row Count:" + this.indexes.length).printStackTrace();
        System.out.println("Please note row/column index starts from 0");
        return -1;
    }

    public int getColumnFromViewToNextModel(int col) {
        return col;
    }

    public int getRowFromViewToFinalModel(int row) {
        row = this.getRowFromViewToNextModel(row);
        if (this.isBackModelTableMap) {
            row = this.backMap.getRowFromViewToFinalModel(row);
        }
        return row;
    }

    public int getColumnFromViewToFinalModel(int col) {
        return col;
    }

    public int convertRowFromNextModelToView(int row) {
        int i = this.indexes.length - 1;
        while (i >= 0) {
            if (this.indexes[i] == row) {
                return i;
            }
            --i;
        }
        return row;
    }

    public int convertRowFromFinalModelToView(int row) {
        if (this.isBackModelTableMap) {
            return this.convertRowFromNextModelToView(this.backMap.convertRowFromFinalModelToView(row));
        }
        return this.convertRowFromNextModelToView(row);
    }

    public int convertColumnFromFinalModelToView(int col) {
        return col;
    }

    public int convertColumnToView(int col) {
        return col;
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.fireTableChanged(e);
    }

    public void reallocateAllIndexes() {
        if (this.isBackModelTableMap) {
            this.backMap.reallocateAllIndexes();
        } else {
            this.reallocateIndexes();
        }
    }
}

