/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import quick.dbtable.Column;
import quick.dbtable.DBTable;
import quick.dbtable.QuickVector;

class Proxy {
    Proxy() {
    }

    static Vector getAllColumns(Object obj, DBTable dc) {
        Class<?> c = obj.getClass();
        Vector<Column> v = new Vector<Column>();
        Method[] meth = c.getDeclaredMethods();
        int i = 0;
        int j = 1;
        while (i < meth.length) {
            Method m = meth[i];
            Column col = Proxy.getColumn(m, c, j, dc);
            if (col != null) {
                ++j;
                v.addElement(col);
            }
            ++i;
        }
        return v;
    }

    static QuickVector getData(Vector en, DBTable dc, int maxRow) {
        QuickVector qc = new QuickVector();
        int i = 0;
        while (i < en.size() && i < maxRow) {
            qc.addElement(Proxy.getRowData(en.elementAt(i), dc));
            ++i;
        }
        return qc;
    }

    private static QuickVector getRowData(Object obj, DBTable dc) {
        Class<?> c = obj.getClass();
        QuickVector v = new QuickVector();
        int i = 0;
        while (i < dc.getTable().getColumnCount()) {
            block8: {
                Method m = null;
                String name = dc.getColumnAsCreated(i).getMethodName();
                try {
                    if (name == null) {
                        System.out.println("method name not set in column");
                        v.addElement("");
                        break block8;
                    }
                    m = c.getMethod(name, null);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(name) + " method not found");
                    v.addElement("");
                    break block8;
                }
                Object value = null;
                try {
                    value = m.invoke(obj, null);
                }
                catch (IllegalAccessException ex1) {
                    System.out.println("Error during calling method " + name + " Illegal Access. Please make sure the class/method is public");
                    v.addElement("");
                    break block8;
                }
                catch (IllegalArgumentException ex2) {
                    System.out.println("Error during calling method " + name + " Illegal Argument");
                    v.addElement("");
                    break block8;
                }
                catch (InvocationTargetException ex3) {
                    System.out.println("Error during calling method " + name + " " + "InvocationTarget");
                    v.addElement("");
                    break block8;
                }
                v.addElement(value);
            }
            ++i;
        }
        v.addElement(obj);
        return v;
    }

    static Vector getAllColumns(Object obj, String[] methodNames, DBTable dc) {
        Class<?> c = obj.getClass();
        Vector<Column> v = new Vector<Column>();
        int i = 0;
        int j = 0;
        while (i < methodNames.length) {
            block5: {
                Method m = null;
                try {
                    m = c.getMethod(methodNames[i], null);
                }
                catch (NoSuchMethodException e) {
                    System.out.println(String.valueOf(methodNames[i]) + " method not found");
                    break block5;
                }
                catch (SecurityException e1) {
                    System.out.println("Access denied for method " + methodNames[i]);
                    break block5;
                }
                Column col = Proxy.getColumn(m, c, ++j, dc);
                if (col != null) {
                    v.addElement(col);
                }
            }
            ++i;
        }
        return v;
    }

    private static Column getColumn(Method m, Class c, int colIndex, DBTable dc) {
        String name = m.getName();
        Class<?>[] cl = m.getParameterTypes();
        if (cl.length == 0) {
            try {
                m = c.getMethod(name, null);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(name) + " method not Accessible, so not added to column list");
                return null;
            }
            String colName = Proxy.getColumnName(name);
            Column col = new Column(colIndex, colName);
            col.setReadOnly(false);
            if (dc.header != null) {
                col.setHeaderRenderer(dc.header);
            }
            col.setHeaderValue(colName);
            col.setLength(255);
            col.setPrecision(255);
            col.setMethodName(name);
            col.setType(Proxy.getType(m.getReturnType().getName()));
            return col;
        }
        return null;
    }

    static String getColumnName(String name) {
        String colName = "";
        colName = name.startsWith("get") ? name.substring(3) : (name.startsWith("is") ? name.substring(2) : name);
        return colName;
    }

    private static int getType(String val) {
        if ("java.lang.String".equals(val)) {
            return 12;
        }
        if ("boolean".equals(val) || "java.lang.Boolean".equals(val)) {
            return -7;
        }
        if ("int".equals(val) || "java.lang.Integer".equals(val)) {
            return 4;
        }
        if ("char".equals(val)) {
            return 1;
        }
        if ("java.lang.BigDecimal".equals(val)) {
            return 3;
        }
        if ("java.lang.Float".equals(val) || "float".equals(val)) {
            return 6;
        }
        if ("java.lang.Double".equals(val) || "double".equals(val)) {
            return 8;
        }
        if ("java.util.Date".equals(val) || "java.sql.Date".equals(val)) {
            return 91;
        }
        if ("java.lang.Long".equals(val) || "long".equals(val)) {
            return -5;
        }
        return 12;
    }
}

