/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import quick.dbtable.DBTable;

class MultiLineHeaderRenderer
extends JList
implements TableCellRenderer {
    DBTable dbTable;
    SortRenderer sr = new SortRenderer();
    int column = -1;
    boolean isAscending;

    MultiLineHeaderRenderer(DBTable dbTable) {
        this.dbTable = dbTable;
        this.setOpaque(true);
        this.setForeground((Color)dbTable.getSkinProperty("Quicktable.headerForeground"));
        this.setBackground((Color)dbTable.getSkinProperty("Quicktable.headerBackground"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setCellRenderer(this.sr);
    }

    public void setOrder(int column, boolean ascending) {
        this.column = column - 1;
        this.isAscending = ascending;
    }

    public void clear() {
        this.column = -1;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont((Font)this.dbTable.getSkinProperty("Quicktable.headerFont"));
        this.setForeground((Color)this.dbTable.getSkinProperty("Quicktable.headerForeground"));
        this.setBackground((Color)this.dbTable.getSkinProperty("Quicktable.headerBackground"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        if (this.dbTable.getOriginalColumnIndex(column) != this.column) {
            this.sr.setType(-1);
        } else if (this.isAscending) {
            this.sr.setType(0);
        } else {
            this.sr.setType(1);
        }
        String str = value == null ? "" : value.toString();
        BufferedReader br = new BufferedReader(new StringReader(str));
        Vector<String> v = new Vector<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setListData(v);
        return this;
    }

    class ArrowIcon
    implements Icon {
        int width = 10;
        int mid = this.width / 2;
        boolean type;

        public ArrowIcon(boolean type) {
            this.type = type;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.getForeground());
            if (this.type) {
                int[] x3Points = new int[]{x + this.mid, x + this.width, x};
                int[] y3Points = new int[]{y, y + this.width, y + this.width};
                g.fillPolygon(x3Points, y3Points, x3Points.length);
            } else {
                int[] x3Points = new int[]{x, x + this.width, x + this.mid};
                int[] y3Points = new int[]{y, y, y + this.width};
                g.fillPolygon(x3Points, y3Points, x3Points.length);
            }
        }
    }

    class SortRenderer
    extends DefaultListCellRenderer {
        private int type = -1;
        Icon upArrow;
        Icon downArrow;

        public SortRenderer() {
            this.upArrow = new ArrowIcon(true);
            this.downArrow = new ArrowIcon(false);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index == 0) {
                this.setIcon(this.getOrderIcon());
            } else {
                this.setIcon(null);
            }
            return comp;
        }

        public void setType(int type) {
            this.type = type;
        }

        Icon getOrderIcon() {
            if (this.type == -1) {
                return null;
            }
            if (this.type == 0) {
                return this.upArrow;
            }
            return this.downArrow;
        }
    }
}

