/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import quick.dbtable.DBTable;

class LengthDocument
extends PlainDocument {
    private int size;
    private String hint = "To hide this message,refer to DBTable.showCriticalWarnings api doc.";
    private DBTable dbTable;

    LengthDocument(int size, DBTable dbTable) {
        this.size = size;
        this.dbTable = dbTable;
    }

    public void changeSizeTo(int size) {
        this.size = size;
        if (size <= 0 && (this.dbTable.debug || this.dbTable.showCriticalWarnings)) {
            System.out.println("Warning: Your JDBC driver or your setting, gives the length of the column data as " + size + ".");
            System.out.println("Warning: If size is zero or less, you won't be able to enter any data into the cell of this column");
            System.out.println("Using yourQT.getColumn(i).setLength(20) change the length");
            System.out.println(this.hint);
        }
    }

    public void insertString(int offs, String str, AttributeSet a) {
        try {
            if (str == "" || str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.size) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(offs, str.substring(0, this.size - this.getLength()), a);
            }
        }
        catch (BadLocationException e) {
            System.out.println(e);
        }
    }
}

