/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import quick.dbtable.DBTable;

class DecimalDocument
extends PlainDocument {
    String validValues = "0123456789.+-";
    private int size;
    private int scale;
    private boolean signed = true;
    private String columnDesc = "";
    private String help = "Hint about Precision/Scale: Lets say, the numeric value is of type 1234.56, then precision is 6 (total number of digits) and scale is 2 (number of digits after the dot).";
    private String hint = "To hide this message,refer to DBTable.showCriticalWarnings api doc.";
    private boolean validate = false;
    private DBTable dbTable;

    DecimalDocument(int precision, int scale, int columnIndex, DBTable dbTable) {
        if (columnIndex > -1) {
            this.columnDesc = "Column :" + columnIndex + " ";
        }
        this.size = precision + 1;
        if (scale < precision) {
            this.scale = scale;
        }
        this.dbTable = dbTable;
    }

    private void log(String str, boolean display) {
        if (display && (this.dbTable.debug || this.dbTable.showCriticalWarnings)) {
            System.out.println(String.valueOf(this.columnDesc) + str);
        }
    }

    public void changePrecisionTo(int val) {
        this.validate = false;
        this.size = val + 1;
        if (this.signed) {
            ++this.size;
        }
    }

    public void changeScaleTo(int val) {
        this.validate = false;
        if (this.scale < this.size - 1) {
            this.scale = val;
        }
    }

    public void setSigned(boolean val) {
        if (val == this.signed) {
            return;
        }
        if (val) {
            this.validValues = "0123456789.+-";
            ++this.size;
        } else {
            this.validValues = "0123456789.";
            --this.size;
        }
        this.signed = val;
    }

    private void check() {
        int pr;
        int n = pr = this.signed ? this.size - 2 : this.size - 1;
        if (pr <= 0) {
            this.log("Warning: Your JDBC driver or your setting, gives the precision of the column data as " + pr + ".", true);
            this.log("Warning: precision cannot be less than or equal to zero", true);
            this.log("Using yourQT.getColumn(i).setPrecision(20) change the precision", true);
            System.out.println(this.help);
        }
        if (this.scale < 0) {
            this.log("Warning: Your JDBC driver or your setting, gives the scale of the column data as " + this.scale + ".", true);
            this.log("Warning: scale cannot be less than zero", true);
            this.log("Using yourQT.getColumn(i).setScale(2) change the scale", true);
            System.out.println(String.valueOf(this.help) + "\n" + this.hint);
        }
        if (this.scale == 0) {
            this.log("Warning: Your JDBC driver or your setting, gives the scale of the column data as " + this.scale + ".", true);
            this.log("Warning: If scale is zero, you cannot enter any digits after the '.'", true);
            this.log("Using yourQT.getColumn(i).setScale(2) change the scale, if needed", true);
            System.out.println(String.valueOf(this.help) + "\n" + this.hint);
        }
        if (pr < this.scale) {
            this.log("Warning: Your JDBC driver or your setting, gives the precision of the column data as " + pr + ".", true);
            this.log("Warning: If precision " + pr + " is less than scale " + this.scale + ", you won't be able to enter any data into the cell of this column", true);
            this.log("Adjust scale & precision , Using yourQT.getColumn(i).setPrecision(20) or setScale(2)", true);
            System.out.println(String.valueOf(this.help) + "\n" + this.hint);
            this.scale = 0;
        }
    }

    public void insertString(int offs, String str, AttributeSet a) {
        if (!this.validate) {
            this.check();
            this.validate = true;
        }
        try {
            if (str == "" || str == null) {
                return;
            }
            boolean displayMessage = str.length() > 1;
            StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
            sb.insert(offs, str);
            String newValue = sb.toString();
            int signLocation = newValue.lastIndexOf(43) > -1 ? newValue.lastIndexOf(43) : newValue.lastIndexOf(45);
            int pointLocation = newValue.indexOf(46);
            if (newValue.indexOf(46, pointLocation + 1) > -1) {
                this.log("More than one '.' found in " + newValue + "\n" + this.hint, displayMessage);
                return;
            }
            if (this.signed) {
                if (signLocation > 0) {
                    this.log("Sign character is found in location other than one " + newValue + "\n" + this.hint, displayMessage);
                    return;
                }
                if (pointLocation > -1 && (signLocation == 0 && pointLocation > this.size - this.scale - 1 || signLocation != 0 && pointLocation > this.size - this.scale - 2)) {
                    this.log("Scale for this column is " + this.scale + ", so the dot should be within " + this.scale + " characters from end, in data " + newValue + "\n" + this.hint, displayMessage);
                    return;
                }
            } else if (pointLocation > -1 && pointLocation > this.size - this.scale - 1) {
                this.log("Scale for this column is " + this.scale + ", so the dot should be within " + this.scale + " characters from end, in data " + newValue + "\n" + this.hint, displayMessage);
                return;
            }
            int countBeforePoint = 0;
            int i = 0;
            while (i < newValue.length()) {
                if (this.validValues.indexOf(newValue.charAt(i)) == -1) {
                    this.log("Invalid character " + newValue.charAt(i) + " found in value " + newValue + ". Modify column type using column.setType(), if needed." + "\n" + this.hint, displayMessage);
                    return;
                }
                if (newValue.charAt(i) == '.') break;
                ++i;
                ++countBeforePoint;
            }
            int countAfterPoint = 0;
            int i2 = countBeforePoint;
            while (i2 < newValue.length()) {
                if (this.validValues.indexOf(newValue.charAt(i2)) == -1) {
                    this.log("Invalid character " + newValue.charAt(i2) + " found in value " + newValue + ". Modify column type using column.setType(), if needed." + "\n" + this.hint, displayMessage);
                    return;
                }
                ++i2;
                ++countAfterPoint;
            }
            if (!(this.signed && signLocation == 0 && countBeforePoint < this.size - this.scale || this.signed && signLocation != 0 && countBeforePoint < this.size - this.scale - 1 || !this.signed && countBeforePoint < this.size - this.scale)) {
                this.log("The number of characters before '.' exceeds the precision in data " + newValue + "\n" + this.hint, displayMessage);
                return;
            }
            if (countAfterPoint - 1 > this.scale) {
                int dotLoc = str.indexOf(".");
                if (dotLoc == -1) {
                    return;
                }
                str = str.substring(0, str.indexOf(".") + this.scale + 1);
            }
            if (this.getLength() + str.length() <= this.size) {
                super.insertString(offs, str, a);
            } else {
                super.insertString(offs, str.substring(0, this.size - this.getLength()), a);
            }
        }
        catch (BadLocationException e) {
            System.out.println(e);
        }
    }
}

