/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import quick.dbtable.DBTableCalendarDialog;

class DayCell
extends JComponent
implements Serializable {
    DBTableCalendarDialog parent;
    int day;
    int pad;
    Color active = Color.red;
    Color passive;
    Dimension size;

    public DayCell(int newDay, Dimension size, DBTableCalendarDialog frame) {
        this.parent = frame;
        this.day = newDay;
        this.addMouseListener(new Mouser());
        this.setSize(size);
        this.size = size;
        this.setFont(this.parent.getFont());
        this.setForeground(Color.white);
        this.pad = this.parent.pad;
    }

    public void paint(Graphics g) {
        if (this.day != 0) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.drawString(Integer.toString(this.day), this.pad, this.pad + fm.getHeight());
        }
    }

    public void activate() {
        this.passive = this.getForeground();
        this.setForeground(this.active);
        this.repaint();
    }

    public void deactivate() {
        this.setForeground(this.passive);
        this.repaint();
    }

    int getDay() {
        return this.day;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    class Mouser
    extends MouseAdapter {
        Mouser() {
        }

        public void mouseClicked(MouseEvent e) {
            DayCell.this.activate();
            DayCell.this.parent.setDateAndExit(DayCell.this.getDay());
        }
    }
}

