/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import quick.dbtable.Column;

class DBTypeMap {
    private DBTypeMap() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object createObject(Object objectType, Column col, Object data1) throws SQLException {
        if (data1 == null || "".equals(data1)) {
            return null;
        }
        int type = col.getType();
        if (!(data1 instanceof String)) {
            if (type != 91 && type != 93 && type != 92) {
                return data1;
            }
            if (!(data1 instanceof Date)) {
                throw new SQLException("Invalid cell value, '" + data1 + "'.", "DBTable Error: Expecting a java.util.Date object");
            }
            Date d = (Date)data1;
            if (type == 91) {
                return new java.sql.Date(d.getTime());
            }
            if (type == 93) {
                return new Timestamp(d.getTime());
            }
            if (type == 92) {
                return new Time(d.getTime());
            }
            return null;
        }
        String data = (String)data1;
        String name = null;
        if (objectType != null) {
            name = objectType.getClass().getName();
        }
        if (name == null) {
            name = "";
        }
        try {
            if (type == 1 || type == 12 || type == -1) {
                return data;
            }
            if ("java.lang.Integer".equals(name) || type == 4 || type == -6 || type == 5) {
                return new Integer(data);
            }
            if ("java.lang.BigDecimal".equals(name) || type == 3 || type == 2) {
                return new BigDecimal(data);
            }
            if ("java.lang.Float".equals(name) || type == 6 || type == 7) {
                return new Float(data);
            }
            if ("java.lang.Double".equals(name) || type == 8) {
                return new Double(data);
            }
            if ("java.util.Date".equals(name) || "java.sql.Date".equals(name) || type == 91) {
                Date d = DBTypeMap.getDate(data, col);
                if (d == null) {
                    return null;
                }
                return new java.sql.Date(d.getTime());
            }
            if ("java.sql.Timestamp".equals(name) || type == 93) {
                Date d = DBTypeMap.getDate(data, col);
                if (d == null) {
                    return null;
                }
                return new Timestamp(d.getTime());
            }
            if ("java.sql.Time".equals(name) || type == 92) {
                Date d = DBTypeMap.getDate(data, col);
                if (d == null) {
                    return null;
                }
                return new Time(d.getTime());
            }
            if ("java.lang.Long".equals(name) || type == -5) {
                return new Long(data);
            }
            if ("java.lang.Boolean".equals(name) || type == -7) {
                if ("1".equals(data)) {
                    data = "true";
                }
                return new Boolean(data);
            }
            if (!name.startsWith("[") && type != -2 && type != -4 && type != -3) {
                return data;
            }
            return data.getBytes();
        }
        catch (Exception e) {
            throw new SQLException("Invalid cell value, '" + data + "'.", "DBTable Error:" + e.getMessage());
        }
    }

    protected static Date getDate(String input, Column tc) {
        String pattern = tc.getDateFormat() != null ? tc.getDateFormat() : "dd-MMM-yyyy";
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.parse(input);
        }
        catch (Exception e) {
            System.out.println("The cell value " + input + " is not of the format " + pattern);
            return null;
        }
    }
}

