/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import quick.dbtable.Column;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableCellListener;
import quick.dbtable.DBTableColumnModel;
import quick.dbtable.DBTableErrorListener;
import quick.dbtable.DBTypeMap;
import quick.dbtable.DataMap;
import quick.dbtable.DatabaseChangeListener;
import quick.dbtable.Proxy;
import quick.dbtable.QuickVector;
import quick.dbtable.ResultSetMap;
import quick.dbtable.TableSorter;

class DBTableModel
extends AbstractTableModel {
    public Component parent;
    private DBTable dbTable;
    protected QuickVector dataVector = new QuickVector();
    int pageSize = 40;
    protected int totalRow = 0;
    private int oldRow = 0;
    private boolean rowUpdated = false;
    protected boolean rowInserted = false;
    boolean selfConnection = true;
    int lastAvailableRow = -1;
    protected boolean designTime = false;
    QuickVector tableCellListenerVector;
    QuickVector databaseChangeListenerVector;
    protected int[] errorCell;
    private QuickVector updateSqlVector;
    private QuickVector updateSqlMappingVector;
    private QuickVector updatePrimaryColumnVector;
    private QuickVector updateStatement;
    private QuickVector insertSqlVector;
    private QuickVector insertSqlMappingVector;
    private QuickVector insertStatement;
    private QuickVector deleteSqlVector;
    private QuickVector deleteSqlMappingVector;
    private QuickVector deleteStatement;
    private Connection dbConnection;
    private Statement tableStatement;
    private ResultSet tableResultSet;
    private transient DBTableColumnModel dbColumnModel;
    private boolean sucessive = false;
    private boolean insertFailed = false;
    private Hashtable failedRow = new Hashtable();
    private Hashtable primaryColumnHash = new Hashtable();
    private Hashtable primaryColumnOldDataHash = new Hashtable();
    protected static final int DATABASE_GRID = 0;
    protected static final int VECTOR_GRID = 1;
    protected static final int ARRAY_GRID = 2;
    protected static final int RESULTSET_GRID = 3;
    protected static final int STREAM_GRID = 4;
    protected static final int CLASS_GRID = 5;
    private TableSorter tableSorter;
    boolean editable = true;
    private int maxRow = Integer.MAX_VALUE;
    private int addedColumnSize = 0;
    private int gridType = 0;

    DBTableModel(DBTableColumnModel dbColumnModel, DBTable dbTable) {
        this.dbColumnModel = dbColumnModel;
        this.dbTable = dbTable;
        this.parent = dbTable;
        dbColumnModel.set(dbTable, this);
        this.totalRow = 0;
        if (dbColumnModel.getColumnCount() == 0) {
            dbColumnModel.setDefaultColumns();
        }
    }

    protected void setTableSorter(TableSorter ts) {
        this.tableSorter = ts;
    }

    protected void createDatabaseConnection() throws SQLException, ClassNotFoundException {
        try {
            DriverManager.getDriver(this.dbTable.jdbcUrl);
        }
        catch (SQLException ex) {
            Class.forName(this.dbTable.dbDriver);
        }
        this.dbConnection = DriverManager.getConnection(this.dbTable.jdbcUrl, this.dbTable.user, this.dbTable.password);
        this.dbColumnModel.setConnection(this.dbConnection);
        this.selfConnection = true;
    }

    protected void setConnection(Connection newConnection) {
        this.selfConnection = false;
        this.dbConnection = newConnection;
        this.dbColumnModel.setConnection(this.dbConnection);
    }

    protected Connection getConnection() {
        return this.dbConnection;
    }

    protected void setMaximumRow(int row) {
        this.maxRow = row;
    }

    protected int getMaximumRow() {
        return this.maxRow;
    }

    protected void addColumn() {
        int i = 0;
        while (i < this.dataVector.size()) {
            QuickVector v = (QuickVector)this.dataVector.elementAt(i);
            v.addElement("");
            ++i;
        }
        ++this.addedColumnSize;
    }

    protected void removeColumnData(Column col) {
        int remCol = col.getModelIndex() - 1;
        int i = 0;
        while (i < this.dataVector.size()) {
            QuickVector v = (QuickVector)this.dataVector.elementAt(i);
            v.removeElementAt(remCol);
            ++i;
        }
        if (col.isVirtual()) {
            --this.addedColumnSize;
        }
    }

    protected Object getRow(int row) {
        QuickVector v = (QuickVector)this.dataVector.elementAt(row);
        if (this.getGridType() == 5) {
            return v.elementAt(v.size() - 1);
        }
        return v;
    }

    protected void updateTable(int row, int col, Object value) {
        this.setValueAt(value, row, col);
    }

    protected void addUpdateSql(String updateStatement, String columnPointer, int[] primaryColumns) {
        if (updateStatement == null || columnPointer == null) {
            return;
        }
        if (this.updateSqlVector == null) {
            this.updateSqlVector = new QuickVector();
            this.updateSqlMappingVector = new QuickVector();
            this.updatePrimaryColumnVector = new QuickVector();
        }
        StringTokenizer st = new StringTokenizer(columnPointer, ",");
        int[] arr = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = Integer.parseInt(st.nextToken()) - 1;
            ++i;
        }
        this.updateSqlVector.addElement(updateStatement);
        this.updateSqlMappingVector.addElement(arr);
        if (primaryColumns == null) {
            primaryColumns = this.getWhereClauseColumns(updateStatement, arr);
        }
        this.updatePrimaryColumnVector.addElement(primaryColumns);
        this.addPrimaryColumns(primaryColumns);
        this.checkSqlValid(updateStatement, arr.length);
    }

    private void addPrimaryColumns(int[] primaryColumns) {
        int i = 0;
        while (i < primaryColumns.length) {
            this.primaryColumnHash.put(new Integer(primaryColumns[i]), "");
            ++i;
        }
    }

    protected void addUpdateSql(PreparedStatement updateStatement, String columnPointer, int[] primaryColumns) {
        if (updateStatement == null || columnPointer == null) {
            return;
        }
        if (this.updateSqlVector == null) {
            this.updateSqlVector = new QuickVector();
            this.updateSqlMappingVector = new QuickVector();
            this.updateStatement = new QuickVector();
            this.updatePrimaryColumnVector = new QuickVector();
        }
        StringTokenizer st = new StringTokenizer(columnPointer, ",");
        int[] arr = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = Integer.parseInt(st.nextToken()) - 1;
            ++i;
        }
        this.updateSqlVector.addElement(updateStatement.toString());
        this.updateSqlMappingVector.addElement(arr);
        this.updateStatement.addElement(updateStatement);
        if (primaryColumns != null) {
            this.updatePrimaryColumnVector.addElement(primaryColumns);
            this.addPrimaryColumns(primaryColumns);
        } else {
            this.updatePrimaryColumnVector.addElement(new int[0]);
        }
    }

    private void checkSqlValid(String sql, int length) {
        int count = 0;
        int i = 0;
        while (i < sql.length()) {
            if (sql.charAt(i) == '?') {
                ++count;
            }
            ++i;
        }
        if (count != length) {
            throw new RuntimeException("Number of '?' in the following sql doesn't match number of column pointers.\n" + sql);
        }
    }

    private int[] getWhereClauseColumns(String sql, int[] allSqlColumns) {
        int count = 0;
        int whereLoc = sql.toUpperCase().indexOf("WHERE");
        if (whereLoc == -1) {
            throw new RuntimeException("Where clause not found in sql" + sql);
        }
        int i = whereLoc;
        while (i < sql.length()) {
            if (sql.charAt(i) == '?') {
                ++count;
            }
            ++i;
        }
        int[] primaryColumns = new int[count];
        int i2 = 0;
        while (i2 < count) {
            primaryColumns[i2] = allSqlColumns[allSqlColumns.length - count + i2];
            if (this.dbTable.debug) {
                System.out.println("Primary Column: " + primaryColumns[i2]);
            }
            ++i2;
        }
        return primaryColumns;
    }

    protected void clearAllUpdateSql() {
        this.rowSelectionChanged();
        try {
            int i = 0;
            while (this.updateStatement != null && i < this.updateStatement.size()) {
                ((PreparedStatement)this.updateStatement.elementAt(i)).close();
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateStatement = null;
        this.updateSqlVector = null;
        this.updateSqlMappingVector = null;
        this.updatePrimaryColumnVector = null;
        this.primaryColumnHash.clear();
        this.primaryColumnOldDataHash.clear();
    }

    protected void addInsertSql(String insertStatement, String columnPointer) {
        if (insertStatement == null || columnPointer == null) {
            return;
        }
        if (this.insertSqlVector == null) {
            this.insertSqlVector = new QuickVector();
            this.insertSqlMappingVector = null;
            this.insertSqlMappingVector = new QuickVector();
        }
        StringTokenizer st = new StringTokenizer(columnPointer, ",");
        int[] arr = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = Integer.parseInt(st.nextToken()) - 1;
            ++i;
        }
        this.insertSqlVector.addElement(insertStatement);
        this.insertSqlMappingVector.addElement(arr);
        this.checkSqlValid(insertStatement, arr.length);
    }

    protected void addInsertSql(PreparedStatement insertStatement, String columnPointer) {
        if (insertStatement == null || columnPointer == null) {
            return;
        }
        if (this.insertSqlVector == null) {
            this.insertSqlVector = new QuickVector();
            this.insertSqlMappingVector = new QuickVector();
            this.insertStatement = new QuickVector();
        }
        StringTokenizer st = new StringTokenizer(columnPointer, ",");
        int[] arr = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = Integer.parseInt(st.nextToken()) - 1;
            ++i;
        }
        this.insertSqlVector.addElement(insertStatement.toString());
        this.insertSqlMappingVector.addElement(arr);
        this.insertStatement.addElement(insertStatement);
    }

    protected void clearAllInsertSql() {
        this.rowSelectionChanged();
        try {
            int i = 0;
            while (this.insertStatement != null && i < this.insertStatement.size()) {
                ((PreparedStatement)this.insertStatement.elementAt(i)).close();
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.insertStatement = null;
        this.insertSqlMappingVector = null;
        this.insertSqlVector = null;
    }

    protected void addDeleteSql(String deleteStatement, String columnPointer) {
        if (deleteStatement == null || columnPointer == null) {
            return;
        }
        if (this.deleteSqlVector == null) {
            this.deleteSqlVector = new QuickVector();
            this.deleteSqlMappingVector = new QuickVector();
        }
        StringTokenizer st = new StringTokenizer(columnPointer, ",");
        int[] arr = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = Integer.parseInt(st.nextToken()) - 1;
            ++i;
        }
        this.deleteSqlVector.addElement(deleteStatement);
        this.deleteSqlMappingVector.addElement(arr);
        this.checkSqlValid(deleteStatement, arr.length);
    }

    protected void addDeleteSql(PreparedStatement deleteStatement, String columnPointer) {
        if (deleteStatement == null || columnPointer == null) {
            return;
        }
        if (this.deleteSqlVector == null) {
            this.deleteSqlVector = new QuickVector();
            this.deleteSqlMappingVector = new QuickVector();
            this.deleteStatement = new QuickVector();
        }
        StringTokenizer st = new StringTokenizer(columnPointer, ",");
        int[] arr = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = Integer.parseInt(st.nextToken()) - 1;
            ++i;
        }
        this.deleteSqlVector.addElement(deleteStatement.toString());
        this.deleteSqlMappingVector.addElement(arr);
        this.deleteStatement.addElement(deleteStatement);
    }

    protected void clearAllDeleteSql() {
        this.rowSelectionChanged();
        try {
            int i = 0;
            while (this.deleteStatement != null && i < this.deleteStatement.size()) {
                ((PreparedStatement)this.deleteStatement.elementAt(i)).close();
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deleteStatement = null;
        this.deleteSqlVector = null;
        this.deleteSqlMappingVector = null;
    }

    protected void addTableCellListener(DBTableCellListener tc) {
        if (this.tableCellListenerVector == null) {
            this.tableCellListenerVector = new QuickVector();
        }
        this.tableCellListenerVector.addElement(tc);
    }

    protected void removeTableCellListener(DBTableCellListener tc) {
        if (this.tableCellListenerVector == null) {
            return;
        }
        this.tableCellListenerVector.removeElement(tc);
    }

    protected void addDatabaseChangeListener(DatabaseChangeListener tc) {
        if (this.databaseChangeListenerVector == null) {
            this.databaseChangeListenerVector = new QuickVector();
        }
        this.databaseChangeListenerVector.addElement(tc);
    }

    protected void removeDatabaseChangeListener(DatabaseChangeListener tc) {
        if (this.databaseChangeListenerVector == null) {
            return;
        }
        this.databaseChangeListenerVector.removeElement(tc);
    }

    protected int getAvailableRowCount() {
        return this.dataVector.size();
    }

    protected void refresh() throws SQLException {
        try {
            this.refresh(null, null);
        }
        catch (Exception e) {
            if (this.totalRow == 0) {
                this.fireTableChanged(new TableModelEvent(this));
            }
            if (this.dbTable.debug) {
                e.printStackTrace();
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage());
        }
    }

    protected void refresh(Object input, Properties prop) throws Exception {
        this.beforeRefresh();
        if (this.gridType == 0 || this.gridType == 3) {
            int tempTotalRow = 0;
            if (this.gridType == 0) {
                if (this.dbTable.selectSql == null) {
                    return;
                }
                tempTotalRow = this.executeQuery();
            } else {
                tempTotalRow = Integer.MAX_VALUE;
                this.tableResultSet = (ResultSet)input;
            }
            if (this.dbColumnModel.defaultColumnsDisplayed || this.gridType == 3 && !this.dbTable.useOldColumnProperties) {
                if (this.dbTable.debug) {
                    System.out.println("Initializing column properties. Any properties set using getColumn(i).setXXXX() will be lost. To retain old column properties use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
                }
                this.createColumnModelFromQuery(this.tableResultSet);
            } else if (this.dbTable.debug) {
                System.out.println("Skipping recreating columns. To refresh column properties everytime, use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
            }
            this.dataVector = null;
            if (tempTotalRow != Integer.MAX_VALUE) {
                this.dataVector = new QuickVector(tempTotalRow);
                this.fetch(0);
                this.totalRow = tempTotalRow > this.maxRow ? this.maxRow : tempTotalRow;
            } else {
                this.dataVector = new QuickVector();
                this.totalRow = this.fetchAll();
            }
        } else if (this.gridType == 1) {
            QuickVector tempVector = null;
            try {
                tempVector = new QuickVector((Vector)input, true);
            }
            catch (Exception e) {
                System.out.println("Data vector is not in right format: " + e.getMessage());
                return;
            }
            this.dataVector = null;
            this.dataVector = tempVector;
            this.checkAndCreateDefaultColumns();
            this.totalRow = this.dataVector.size();
            this.lastAvailableRow = this.totalRow - 1;
        } else if (this.gridType == 2) {
            QuickVector tempVector = null;
            try {
                tempVector = new QuickVector((Object[])input, true);
            }
            catch (Exception e) {
                System.out.println("Data Array is not valid: " + e.getMessage());
                return;
            }
            this.dataVector = null;
            this.dataVector = tempVector;
            this.checkAndCreateDefaultColumns();
            this.totalRow = this.dataVector.size();
            this.lastAvailableRow = this.totalRow - 1;
        } else if (this.gridType == 4) {
            if (prop.get("delimiter") != null) {
                this.loadStreamByDelimiter((BufferedReader)input, prop);
            } else {
                this.loadStreamByFixedLengthData((BufferedReader)input, prop);
            }
        } else if (this.gridType == 5) {
            Vector en = (Vector)input;
            if (this.dbColumnModel.defaultColumnsDisplayed) {
                if (this.dbTable.debug) {
                    System.out.println("Initializing column properties. Any properties set using getColumn(i).setXXXX() will be lost. To retain old column properties use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
                }
                String[] methodNames = (String[])prop.get("methodNames");
                if (en.size() > 0) {
                    if (methodNames != null) {
                        this.dbColumnModel.createColumnModel(Proxy.getAllColumns(en.elementAt(0), methodNames, this.dbTable));
                    } else {
                        this.dbColumnModel.createColumnModel(Proxy.getAllColumns(en.elementAt(0), this.dbTable));
                    }
                } else if (methodNames != null && methodNames.length > 0) {
                    QuickVector mVector = new QuickVector();
                    int k = 0;
                    while (k < methodNames.length) {
                        mVector.addElement(Proxy.getColumnName(methodNames[k]));
                        ++k;
                    }
                    this.dbColumnModel.createColumnModelFromNames(mVector);
                }
            } else if (this.dbTable.debug) {
                System.out.println("Skipping recreating columns. To refresh column properties everytime use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
            }
            QuickVector tempVector = null;
            try {
                tempVector = Proxy.getData(en, this.dbTable, this.maxRow);
            }
            catch (Exception e) {
                System.out.println("Error loading data: " + e.getMessage());
                return;
            }
            this.dataVector = null;
            this.dataVector = tempVector;
            this.totalRow = this.dataVector.size();
            this.lastAvailableRow = this.totalRow - 1;
        } else {
            System.out.println("Nothing to refresh. No grid type provided");
        }
        this.afterRefresh();
    }

    private void beforeRefresh() {
        JTable thisTable = this.dbTable.getTable();
        if (thisTable.isEditing()) {
            thisTable.editingStopped(new ChangeEvent(thisTable));
            thisTable.transferFocus();
        }
        this.rowSelectionChanged();
        this.failedRow.clear();
        this.primaryColumnOldDataHash.clear();
    }

    private void afterRefresh() {
        this.clearInsertUpdate();
        this.insertFailed = false;
        this.tableSorter.reallocateAllIndexes();
        this.fireTableDataChanged();
        if (this.tableSorter.getRowCount() > 0) {
            this.dbTable.getTable().setRowSelectionInterval(0, 0);
        }
    }

    protected void removeAllRows() {
        this.beforeRefresh();
        this.dataVector.removeAllElements();
        this.totalRow = 0;
        this.lastAvailableRow = this.totalRow - 1;
        this.afterRefresh();
    }

    protected void setGridType(int type) {
        if (this.gridType == type) {
            return;
        }
        if (this.gridType == 0) {
            this.clearAllDeleteSql();
            this.clearAllInsertSql();
            this.clearAllUpdateSql();
            if (this.dbTable.retainConnection) {
                try {
                    this.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.selfConnection = false;
            }
            this.dbTable.selectSql = null;
        }
        this.gridType = type;
    }

    protected int getGridType() {
        return this.gridType;
    }

    /*
     * Unable to fully structure code
     */
    private int executeQuery() throws SQLException {
        block22: {
            if (this.tableStatement == null) {
                if (this.dbConnection == null) {
                    try {
                        this.createDatabaseConnection();
                        break block22;
                    }
                    catch (ClassNotFoundException e) {
                        i = 0;
                        ** while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(2, e.getMessage(), e)) {
                            return -1;
                        }
                        ++i;
                        continue;
                    }
lbl13:
                    // 1 sources

                    this.dbTable.setMessageStart();
                    JOptionPane.showMessageDialog(this.dbTable.getParentFrame(), this.dbTable.getString("DriverNotFound"));
                    this.dbTable.setMessageEnd();
                }
            } else {
                if (this.tableResultSet != null) {
                    try {
                        this.tableResultSet.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.tableResultSet = null;
                }
                try {
                    this.tableStatement.close();
                    this.tableStatement = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        tempTotalRow = 0;
        if (this.dbTable.rowCountSql != null || this.dbTable.userRowCountSql != null) {
            sql = this.dbTable.userRowCountSql != null ? this.dbTable.userRowCountSql : this.dbTable.rowCountSql;
            this.tableStatement = this.dbConnection.createStatement();
            try {
                if (this.dbTable.debug) {
                    System.out.println("Executing row count sql=" + sql);
                }
                start = System.currentTimeMillis();
                this.tableResultSet = this.tableStatement.executeQuery(sql);
                tempTotalRow = this.tableResultSet.next() != false ? this.tableResultSet.getInt(1) : 0;
                if (this.dbTable.debug) {
                    System.out.println("Time taken to execute rowcount sql=" + (System.currentTimeMillis() - start) + "ms");
                }
            }
            catch (SQLException e) {
                if (this.dbTable.debug) {
                    System.out.println("Error while executing row count sql=" + e.getMessage());
                }
                System.out.println("Unable to automatically create rowcount sql. For better performance, provide an sql using dbTable.setRowCountSql(String rowCountSql). Refer api help of setRowCountSql.");
                tempTotalRow = 0x7FFFFFFF;
            }
            try {
                this.tableResultSet.close();
                this.tableResultSet = null;
                this.tableStatement.close();
                this.tableStatement = null;
            }
            catch (Exception var3_11) {}
        } else {
            tempTotalRow = 0x7FFFFFFF;
        }
        this.tableStatement = this.dbConnection.createStatement();
        start = System.currentTimeMillis();
        this.tableResultSet = this.tableStatement.executeQuery(this.dbTable.selectSql);
        if (this.dbTable.debug) {
            System.out.println("Time taken to execute select sql=" + (System.currentTimeMillis() - start) + "ms");
        }
        return tempTotalRow;
    }

    protected int fetchAll() throws SQLException {
        this.dataVector.ensureCapacity(this.pageSize);
        int count = 0;
        ResultSetMap[] rMap = new ResultSetMap[this.tableResultSet.getMetaData().getColumnCount()];
        int m = 0;
        while (m < this.tableResultSet.getMetaData().getColumnCount()) {
            rMap[m] = ((Column)this.dbColumnModel.getColumn(m)).getResultSetMap();
            ++m;
        }
        while (this.tableResultSet.next() && count < this.maxRow) {
            QuickVector rowVector = new QuickVector();
            rowVector.ensureCapacity(this.tableResultSet.getMetaData().getColumnCount());
            int j = 1;
            while (j <= this.tableResultSet.getMetaData().getColumnCount()) {
                if (rMap[j - 1] != null) {
                    rowVector.addElement(rMap[j - 1].getObject(this.tableResultSet, j));
                } else {
                    rowVector.addElement(this.tableResultSet.getObject(j));
                }
                ++j;
            }
            int k = 0;
            while (k < this.addedColumnSize) {
                rowVector.addElement("");
                ++k;
            }
            this.dataVector.addElement(rowVector);
            if (this.dataVector.size() % this.pageSize == 0) {
                this.dataVector.ensureCapacity(this.dataVector.size() + this.pageSize);
            }
            ++count;
        }
        this.lastAvailableRow = this.dataVector.size() - 1;
        return this.dataVector.size();
    }

    private void loadStreamByDelimiter(BufferedReader in, Properties prop) throws Exception {
        QuickVector dataVector;
        block21: {
            dataVector = new QuickVector();
            String delimiter = (String)prop.get("delimiter");
            boolean firstRowHasColumnNames = prop.get("firstRowHasColumnNames") != null;
            try {
                try {
                    String inputLine;
                    int firstRowSize = 0;
                    int i = 0;
                    while ((inputLine = in.readLine()) != null && i < this.maxRow) {
                        StringTokenizer st2 = new StringTokenizer(inputLine, delimiter, true);
                        boolean lastTokenIsDelimter = true;
                        QuickVector rowData = new QuickVector();
                        while (st2.hasMoreTokens()) {
                            String value = st2.nextToken();
                            if (delimiter.equals(value)) {
                                if (!lastTokenIsDelimter) {
                                    lastTokenIsDelimter = true;
                                    continue;
                                }
                                lastTokenIsDelimter = true;
                                value = null;
                            } else {
                                lastTokenIsDelimter = false;
                            }
                            rowData.addElement(value == null ? "" : value);
                        }
                        if (i == 0) {
                            firstRowSize = rowData.size();
                            if (firstRowHasColumnNames) {
                                this.createColumnModelFromNames(rowData);
                                ++i;
                                continue;
                            }
                        }
                        if (i > 0 && firstRowSize != rowData.size()) {
                            System.out.println("Number of columns in row " + i + " is " + firstRowSize + ". but number of columns in row " + (i + 1) + " is " + rowData.size() + ". Row not loaded");
                        } else {
                            dataVector.addElement(rowData);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error loading stream " + e.getMessage());
                    if (dataVector.size() == 0) {
                        throw e;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataVector = null;
        this.dataVector = dataVector;
        this.checkAndCreateDefaultColumns();
        this.totalRow = dataVector.size();
        this.lastAvailableRow = this.totalRow - 1;
    }

    private void loadStreamByFixedLengthData(BufferedReader in, Properties prop) throws Exception {
        QuickVector dataVector;
        block20: {
            dataVector = new QuickVector();
            int[] colLength = (int[])prop.get("columnLengthArray");
            boolean firstRowHasColumnNames = prop.get("firstRowHasColumnNames") != null;
            try {
                try {
                    String inputLine;
                    int firstRowSize = 0;
                    int i = 0;
                    while ((inputLine = in.readLine()) != null && i < this.maxRow) {
                        QuickVector rowData = new QuickVector();
                        int start = 0;
                        int j = 0;
                        while (j < colLength.length) {
                            int nextStart = start + colLength[j];
                            String value = null;
                            try {
                                value = j == colLength.length - 1 ? inputLine.substring(start) : inputLine.substring(start, nextStart);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            start = nextStart;
                            rowData.addElement(value == null ? "" : value);
                            ++j;
                        }
                        if (i == 0) {
                            firstRowSize = rowData.size();
                            if (firstRowHasColumnNames) {
                                this.createColumnModelFromNames(rowData);
                                ++i;
                                continue;
                            }
                        }
                        if (i > 0 && firstRowSize != rowData.size()) {
                            System.out.println("Number of columns in row " + i + " is " + firstRowSize + ". but number of columns in row " + (i + 1) + " is " + rowData.size() + ". Row not loaded");
                        } else {
                            dataVector.addElement(rowData);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error loading stream " + e.getMessage());
                    if (dataVector.size() == 0) {
                        throw e;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataVector = null;
        this.dataVector = dataVector;
        this.checkAndCreateDefaultColumns();
        this.totalRow = dataVector.size();
        this.lastAvailableRow = this.totalRow - 1;
    }

    public void checkAndCreateDefaultColumns() {
        if (this.dataVector.size() == 0) {
            this.dbColumnModel.setDefaultColumns();
        } else {
            int colCount = ((QuickVector)this.dataVector.elementAt(0)).size();
            if (this.dbColumnModel.getColumnCount() != colCount || this.dbColumnModel.defaultColumnsDisplayed) {
                if (!this.dbColumnModel.defaultColumnsDisplayed) {
                    System.out.println("Number of column in dataVector " + colCount + ", doesn't match with column count in column model " + this.dbColumnModel.getColumnCount() + ". So creating default columns.");
                }
                this.dbColumnModel.createDefaultColumns(colCount);
            } else if (this.dbTable.debug) {
                System.out.println("Skipping recreating columns. To refresh column properties everytime use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
            }
        }
    }

    public void createColumnModelFromNames(QuickVector rowData) {
        if (this.dbColumnModel.defaultColumnsDisplayed) {
            if (this.dbTable.debug) {
                System.out.println("Initializing column properties. Any properties set using getColumn(i).setXXXX() will be lost. To retain old column properties use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
            }
            this.dbColumnModel.createColumnModelFromNames(rowData);
        } else if (this.dbTable.debug) {
            System.out.println("Skipping recreating columns. To refresh column properties everytime use 'DBTable.useOldColumnProperties(boolean val)', if needed.");
        }
    }

    protected void setParent(Component c) {
        this.parent = c;
    }

    protected Component getParent() {
        return this.parent;
    }

    public int getRowCount() {
        return this.totalRow;
    }

    public int getColumnCount() {
        return this.dbColumnModel.getColumnCount();
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    /*
     * Unable to fully structure code
     */
    public Object getValueAt(int row, int col) {
        block12: {
            if (row > this.lastAvailableRow) {
                this.parent.setCursor(new Cursor(3));
                try {
                    try {
                        this.fetch(row - this.lastAvailableRow);
                        break block12;
                    }
                    catch (SQLException e) {
                        i = 0;
                        ** while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(8, e.getMessage(), e)) {
                            this.totalRow = 0;
                            this.fireTableDataChanged();
                            return null;
                        }
                        ++i;
                        continue;
                    }
lbl16:
                    // 1 sources

                    this.dbTable.setMessageStart();
                    JOptionPane.showMessageDialog(this.dbTable.getParentFrame(), e.getMessage(), this.dbTable.getString("DatabaseError"), 0);
                    this.dbTable.setMessageEnd();
                }
                finally {
                    this.parent.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        if (row < this.dataVector.size() && row >= 0) {
            rowV = (QuickVector)this.dataVector.elementAt(row);
            if (col > 0 && col <= rowV.size()) {
                dm = ((Column)this.dbColumnModel.getColumnAsCreated(col - 1)).getDataMap();
                if (dm == null) {
                    return rowV.elementAt(col - 1);
                }
                return dm.convertDataToDisplay(rowV.elementAt(col - 1));
            }
            return null;
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        int val = this.dbTable.defaultCellModel.getCellEditable(row, col - 1);
        if (val == 0) {
            return false;
        }
        if (val == 1) {
            return true;
        }
        return !this.editable ? this.editable : !((Column)this.dbColumnModel.getColumnAsCreated(col - 1)).getReadOnly();
    }

    public void setValueAt(Object value, int row, int col) {
        String key;
        Column thisCol;
        DataMap dm;
        if (value == null) {
            return;
        }
        if (row >= this.getRowCount() || row < 0 || col <= 0 || col > this.getColumnCount()) {
            new Exception("You are trying to set the value " + value + " for row=" + row + " column=" + col + " but the maximum number of rows=" + this.getRowCount() + " and number of columns=" + this.getColumnCount()).printStackTrace();
            System.out.println("Please note row/column index starts from 0");
            return;
        }
        this.getValueAt(row, col);
        if (row < this.dataVector.size() && value.equals(((QuickVector)this.dataVector.elementAt(row)).elementAt(col - 1))) {
            if (this.dbTable.debug) {
                System.out.println("setValueAt() didn't update the data " + value + " at row=" + row + " col=" + col + " because new value same as old value");
            }
            return;
        }
        if (this.insertFailed && !this.rowInserted && this.failedRow.containsKey(new Integer(this.oldRow))) {
            this.setInsert();
        }
        if (row != this.oldRow && !this.sucessive) {
            this.sucessive = true;
            this.rowSelectionChanged();
            this.sucessive = false;
        }
        this.oldRow = row;
        if (this.tableCellListenerVector != null) {
            int i = 0;
            while (i < this.tableCellListenerVector.size()) {
                this.dbTable.cellValueChangeInProgress = true;
                Object o = null;
                try {
                    o = ((DBTableCellListener)this.tableCellListenerVector.elementAt(i)).cellValueChanged(this.tableSorter.convertRowFromFinalModelToView(row), this.dbTable.getOriginalColumnIndex(col - 1) + 1, ((QuickVector)this.dataVector.elementAt(row)).elementAt(col - 1), value);
                }
                finally {
                    this.dbTable.cellValueChangeInProgress = false;
                }
                if (o == null) {
                    if (this.dbTable.debug) {
                        System.out.println("DBTableCellListener.cellValueChanged rejected setValueAt data '" + value + "' at row=" + row + " col=" + col + " by returning null");
                    }
                    return;
                }
                value = o;
                ++i;
            }
        }
        if ((dm = (thisCol = (Column)this.dbColumnModel.getColumnAsCreated(col - 1)).getDataMap()) != null) {
            value = dm.convertDataToStore(value);
        }
        if (!thisCol.getNullable() && "".equals(value)) {
            if (this.dbTable.debug) {
                System.out.println("Column non nullable, rejected setValueAt update '" + value + "' at row=" + row + " col=" + col + ". To allow null, set getColumn(i).setNullable(true)");
            }
            if (this.errorCell != null) {
                return;
            }
            this.errorCell = new int[2];
            this.errorCell[0] = row;
            this.errorCell[1] = col;
            int i = 0;
            while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size()) {
                if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(1, "This cell can't be empty!", null)) {
                    return;
                }
                ++i;
            }
            this.dbTable.setMessageStart();
            JOptionPane.showMessageDialog(this.dbTable.getParentFrame(), this.dbTable.getString("EmptyCell"));
            this.dbTable.setMessageEnd();
            return;
        }
        Object oldVal = ((QuickVector)this.dataVector.elementAt(row)).elementAt(col - 1);
        if (oldVal != null) {
            try {
                String oldValComp = oldVal.toString();
                String valueComp = value.toString();
                if (oldValComp.compareTo(valueComp) == 0) {
                    if (this.dbTable.debug) {
                        System.out.println("oldvalue: " + oldValComp + " new value: " + valueComp + " are same. So this will not be updated to database");
                    }
                    return;
                }
                Object oldValComp1 = DBTypeMap.createObject(this.getRowCount() > 0 ? ((QuickVector)this.dataVector.elementAt(0)).elementAt(col - 1) : null, thisCol, oldVal);
                Object valueComp1 = DBTypeMap.createObject(this.getRowCount() > 0 ? ((QuickVector)this.dataVector.elementAt(0)).elementAt(col - 1) : null, thisCol, value);
                if (thisCol.getType() == 91 || thisCol.getType() == 93 || thisCol.getType() == 92) {
                    Calendar timeKeeper = Calendar.getInstance();
                    timeKeeper.setTime((Date)oldValComp1);
                    timeKeeper.clear(13);
                    timeKeeper.clear(14);
                    Date oldDate = timeKeeper.getTime();
                    timeKeeper.setTime((Date)valueComp1);
                    timeKeeper.clear(13);
                    timeKeeper.clear(14);
                    Date valDate = timeKeeper.getTime();
                    if (oldDate.equals(valDate)) {
                        if (this.dbTable.debug) {
                            System.out.println("oldvalue: " + oldDate + " new value: " + valDate + " are same. So this will not be updated to database");
                        }
                        return;
                    }
                } else if (oldValComp.toString().compareTo(valueComp.toString()) == 0) {
                    if (this.dbTable.debug) {
                        System.out.println("oldvalue: " + oldValComp + " new value: " + valueComp + " are same. So this will not be updated to database");
                    }
                    return;
                }
            }
            catch (Exception oldValComp) {}
        } else if ("".equals(value)) {
            return;
        }
        if (this.dbTable.debug) {
            System.out.println("Data updated (" + row + "," + (col - 1) + "): oldvalue: " + oldVal + " new value: " + value);
        }
        if (this.primaryColumnHash.containsKey(new Integer(col)) && oldVal != null && !"".equals(oldVal) && !this.primaryColumnOldDataHash.containsKey(key = String.valueOf(row) + (col - 1))) {
            this.primaryColumnOldDataHash.put(key, oldVal);
        }
        if (!this.rowInserted && !thisCol.isVirtual()) {
            this.setUpdate();
        }
        if (row < this.dataVector.size()) {
            ((QuickVector)this.dataVector.elementAt(row)).setElementAt(value, col - 1);
        }
        if ((this.rowUpdated || this.rowInserted) && this.dbTable.getDatabaseUpdateMode() == 1) {
            this.rowSelectionChanged();
        }
    }

    private void setUpdate() {
        this.rowUpdated = true;
        this.rowInserted = false;
    }

    private void setInsert() {
        this.rowUpdated = false;
        this.rowInserted = true;
    }

    private void clearInsertUpdate() {
        this.rowUpdated = false;
        this.rowInserted = false;
    }

    protected void update(int oldRow) throws Exception {
        int i;
        int i2;
        JTable thisTable = this.dbTable.getTable();
        if (thisTable.isEditing() && !this.sucessive) {
            thisTable.editingStopped(new ChangeEvent(thisTable));
        }
        if (oldRow >= this.dataVector.size()) {
            return;
        }
        if (this.databaseChangeListenerVector != null) {
            i2 = 0;
            while (i2 < this.databaseChangeListenerVector.size()) {
                if (!((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i2)).beforeUpdate(this.tableSorter.convertRowFromFinalModelToView(oldRow))) {
                    if (this.dbTable.debug) {
                        System.out.println("update cancelled by beforeUpdate()");
                    }
                    return;
                }
                ++i2;
            }
        }
        if (this.updateSqlVector == null) {
            if (this.dbTable.debug) {
                System.out.println("UpdateSql not set for DBTable, so your update is not done in database");
            }
            this.clearInsertUpdate();
            return;
        }
        if (this.updateStatement == null) {
            this.updateStatement = new QuickVector();
            i2 = 0;
            while (i2 < this.updateSqlVector.size()) {
                try {
                    this.updateStatement.addElement(this.dbConnection.prepareStatement((String)this.updateSqlVector.elementAt(i2)));
                }
                catch (Exception e) {
                    this.updateStatement = null;
                    System.out.println("Error during creating prepared statement for" + (String)this.updateSqlVector.elementAt(i2));
                    throw e;
                }
                ++i2;
            }
        }
        if (this.dbTable.autoCommit && this.dbConnection != null) {
            try {
                this.dbConnection.setAutoCommit(false);
            }
            catch (Throwable i3) {
                // empty catch block
            }
        }
        this.parent.setCursor(new Cursor(3));
        try {
            try {
                i = 0;
                while (i < this.updateStatement.size()) {
                    PreparedStatement pt = (PreparedStatement)this.updateStatement.elementAt(i);
                    int[] arr = (int[])this.updateSqlMappingVector.elementAt(i);
                    int[] primaryColumns = (int[])this.updatePrimaryColumnVector.elementAt(i);
                    int whereClauseStart = arr.length - primaryColumns.length;
                    if (this.dbTable.debug) {
                        System.out.println("Executing sql " + this.updateSqlVector.elementAt(i) + " with arguments:");
                    }
                    int j = 1;
                    while (j <= arr.length) {
                        String key;
                        int viewCol = this.tableSorter.convertColumnFromFinalModelToView(arr[j - 1]);
                        Column thisCol = (Column)this.dbColumnModel.getColumnAsCreated(viewCol);
                        Object dataToBeUpdated = ((QuickVector)this.dataVector.elementAt(oldRow)).elementAt(arr[j - 1]);
                        if (j > whereClauseStart && this.primaryColumnOldDataHash.containsKey(key = String.valueOf(oldRow) + arr[j - 1])) {
                            dataToBeUpdated = this.primaryColumnOldDataHash.get(key);
                        }
                        Object data = DBTypeMap.createObject(this.getRowCount() > 0 ? ((QuickVector)this.dataVector.elementAt(0)).elementAt(arr[j - 1]) : null, thisCol, dataToBeUpdated);
                        if (this.dbTable.debug) {
                            if (data == null) {
                                System.out.println("Argument " + j + ": Datatype in database:" + this.dbTable.getTypeName(thisCol.getType()) + ". Value:NULL");
                            } else {
                                System.out.println("Argument " + j + ": Datatype in database:" + this.dbTable.getTypeName(thisCol.getType()) + ". Datatype of cell data: " + data.getClass().getName() + ". Value:" + data);
                            }
                        }
                        if (data == null) {
                            try {
                                pt.setNull(j, thisCol.getType());
                            }
                            catch (Exception e) {
                                if (thisCol.getType() == 93) {
                                    pt.setNull(j, 1);
                                }
                            }
                        } else if (thisCol.getResultSetMap() != null) {
                            thisCol.getResultSetMap().setObject(pt, j, data);
                        } else if (thisCol.getType() == 93) {
                            pt.setTimestamp(j, (Timestamp)data);
                        } else {
                            pt.setObject(j, data);
                        }
                        ++j;
                    }
                    pt.executeUpdate();
                    pt.clearParameters();
                    ++i;
                }
                if (this.dbTable.autoCommit && this.dbConnection != null) {
                    this.dbConnection.commit();
                }
                i = 0;
                while (i < this.getColumnCount()) {
                    String key = String.valueOf(oldRow) + i;
                    if (this.primaryColumnOldDataHash.containsKey(key)) {
                        this.primaryColumnOldDataHash.remove(key);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (this.dbTable.autoCommit && this.dbConnection != null) {
                    this.dbConnection.rollback();
                }
                throw e;
            }
        }
        finally {
            this.parent.setCursor(Cursor.getDefaultCursor());
            if (this.dbTable.autoCommit && this.dbConnection != null) {
                try {
                    this.dbConnection.setAutoCommit(true);
                }
                catch (Throwable throwable) {}
            }
            this.clearInsertUpdate();
        }
        if (this.databaseChangeListenerVector != null) {
            i = 0;
            while (i < this.databaseChangeListenerVector.size()) {
                ((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i)).afterUpdate(this.tableSorter.convertRowFromFinalModelToView(oldRow));
                ++i;
            }
        }
    }

    protected void delete(int[] row) throws Exception {
        JTable thisTable = this.dbTable.getTable();
        if (thisTable.isEditing()) {
            thisTable.editingStopped(new ChangeEvent(thisTable));
        }
        if (this.deleteSqlVector == null) {
            int k = 0;
            while (k < row.length) {
                int modelRow = this.tableSorter.getRowFromViewToFinalModel(row[k] - k);
                if (modelRow >= this.dataVector.size()) break;
                boolean doNotDelete = false;
                if (this.databaseChangeListenerVector != null) {
                    int i = 0;
                    while (i < this.databaseChangeListenerVector.size()) {
                        if (!((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i)).beforeDelete(row[k] - k)) {
                            doNotDelete = true;
                        }
                        ++i;
                    }
                }
                if (!doNotDelete) {
                    this.dataVector.removeElementAt(modelRow);
                    --this.lastAvailableRow;
                    --this.totalRow;
                    this.tableSorter.deleteRow(row[k] - k);
                    this.tableSorter.fireTableDataChanged();
                }
                ++k;
            }
            int res = row[row.length - 1] - (row.length - 1);
            if (res >= this.tableSorter.getRowCount()) {
                res = this.tableSorter.getRowCount() - 1;
            }
            if (res < 0 && this.tableSorter.getRowCount() > 0) {
                res = 0;
            }
            if (res >= 0) {
                JTable jt = this.dbTable.getTable();
                jt.scrollRectToVisible(jt.getCellRect(res, 1, true));
                jt.setRowSelectionInterval(res, res);
            }
            if (this.dbTable.debug) {
                System.out.println("deleteSql not set for DBTable, so this record is not deleted in database");
            }
            return;
        }
        if (this.deleteStatement == null) {
            this.deleteStatement = new QuickVector();
            int i = 0;
            while (i < this.deleteSqlVector.size()) {
                try {
                    this.deleteStatement.addElement(this.dbConnection.prepareStatement((String)this.deleteSqlVector.elementAt(i)));
                }
                catch (Exception e) {
                    this.deleteStatement = null;
                    System.out.println("Error during creating prepared statement for" + (String)this.deleteSqlVector.elementAt(i));
                    throw e;
                }
                ++i;
            }
        }
        if (this.dbTable.autoCommit && this.dbConnection != null) {
            try {
                this.dbConnection.setAutoCommit(false);
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        this.parent.setCursor(new Cursor(3));
        try {
            try {
                int k = 0;
                while (k < row.length) {
                    int i;
                    int modelRow = this.tableSorter.getRowFromViewToFinalModel(row[k] - k);
                    if (modelRow >= this.dataVector.size()) {
                        break;
                    }
                    boolean doNotDelete = false;
                    if (this.databaseChangeListenerVector != null) {
                        i = 0;
                        while (i < this.databaseChangeListenerVector.size()) {
                            if (!((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i)).beforeDelete(row[k] - k)) {
                                doNotDelete = true;
                            }
                            ++i;
                        }
                    }
                    if (doNotDelete) {
                        if (this.dbTable.debug) {
                            System.out.println("Delete cancelled by beforeDelete()");
                        }
                    } else {
                        int res;
                        if (!doNotDelete) {
                            i = 0;
                            while (i < this.deleteStatement.size()) {
                                PreparedStatement pt = (PreparedStatement)this.deleteStatement.elementAt(i);
                                int[] arr = (int[])this.deleteSqlMappingVector.elementAt(i);
                                if (this.dbTable.debug) {
                                    System.out.println("Executing sql " + this.deleteSqlVector.elementAt(i) + " with arguments:");
                                }
                                int j = 1;
                                while (j <= arr.length) {
                                    Column thisCol = (Column)this.dbColumnModel.getColumnAsCreated(arr[j - 1]);
                                    Object data = DBTypeMap.createObject(this.getRowCount() > 0 ? ((QuickVector)this.dataVector.elementAt(0)).elementAt(arr[j - 1]) : null, thisCol, ((QuickVector)this.dataVector.elementAt(modelRow)).elementAt(arr[j - 1]));
                                    if (this.dbTable.debug) {
                                        if (data == null) {
                                            System.out.println("Argument " + j + ": Datatype in database:" + this.dbTable.getTypeName(thisCol.getType()) + ". Value:NULL");
                                        } else {
                                            System.out.println("Argument " + j + ": Datatype in database:" + this.dbTable.getTypeName(thisCol.getType()) + ". Datatype of cell data: " + data.getClass().getName() + ". Value:" + data);
                                        }
                                    }
                                    if (data == null) {
                                        try {
                                            pt.setNull(j, thisCol.getType());
                                        }
                                        catch (Exception e) {
                                            if (thisCol.getType() == 93) {
                                                pt.setNull(j, 1);
                                            }
                                        }
                                    } else if (thisCol.getResultSetMap() != null) {
                                        thisCol.getResultSetMap().setObject(pt, j, data);
                                    } else {
                                        pt.setObject(j, data);
                                    }
                                    ++j;
                                }
                                pt.executeUpdate();
                                pt.clearParameters();
                                ++i;
                            }
                            if (this.dbTable.autoCommit && this.dbConnection != null) {
                                this.dbConnection.commit();
                            }
                        }
                        this.dataVector.removeElementAt(modelRow);
                        --this.lastAvailableRow;
                        --this.totalRow;
                        this.tableSorter.deleteRow(row[k] - k);
                        if (this.insertFailed && this.failedRow.containsKey(new Integer(modelRow))) {
                            this.failedRow.remove(new Integer(modelRow));
                            if (this.failedRow.size() == 0) {
                                this.insertFailed = false;
                            }
                        }
                        if ((res = row[row.length - 1] - (row.length - 1)) >= this.tableSorter.getRowCount()) {
                            res = this.tableSorter.getRowCount() - 1;
                        }
                        if (res < 0 && this.tableSorter.getRowCount() > 0) {
                            res = 0;
                        }
                        if (res >= 0) {
                            JTable jt = this.dbTable.getTable();
                            jt.scrollRectToVisible(jt.getCellRect(res, 1, true));
                            jt.setRowSelectionInterval(res, res);
                        }
                        if (!doNotDelete && this.databaseChangeListenerVector != null) {
                            int i2 = 0;
                            while (i2 < this.databaseChangeListenerVector.size()) {
                                ((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i2)).afterDelete(row[k] - k);
                                ++i2;
                            }
                        }
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                if (this.dbTable.autoCommit && this.dbConnection != null) {
                    this.dbConnection.rollback();
                }
                throw e;
            }
        }
        finally {
            this.parent.setCursor(Cursor.getDefaultCursor());
            if (this.dbTable.autoCommit && this.dbConnection != null) {
                try {
                    this.dbConnection.setAutoCommit(true);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void rowSelectionChanged() {
        block16: {
            oldRowAfterChange = this.dbTable.getTable().getSelectedRow();
            inputOldRow = this.oldRow;
            if (this.insertFailed && !this.rowInserted && this.failedRow.containsKey(new Integer(inputOldRow))) {
                this.setInsert();
            }
            if (this.rowInserted) {
                if (this.dbTable.isCurrentlyInsertingEmptyRecord()) {
                    return;
                }
                try {
                    this.clearInsertUpdate();
                    this.insert(inputOldRow);
                    if (!this.insertFailed || !this.failedRow.containsKey(new Integer(inputOldRow)) || "postpone".equals(this.failedRow.get(new Integer(inputOldRow)))) break block16;
                    this.failedRow.remove(new Integer(inputOldRow));
                    if (this.failedRow.size() == 0) {
                        this.insertFailed = false;
                    }
                    break block16;
                }
                catch (Exception e) {
                    this.insertFailed = true;
                    this.failedRow.put(new Integer(inputOldRow), "");
                    this.oldRow = oldRowAfterChange;
                    i = 0;
                    ** while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size())
                }
lbl-1000:
                // 1 sources

                {
                    if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(5, e.getMessage(), e)) {
                        return;
                    }
                    ++i;
                    continue;
                }
lbl28:
                // 1 sources

                if (this.dbTable.debug) {
                    e.printStackTrace();
                }
                this.dbTable.setMessageStart();
                JOptionPane.showMessageDialog(this.dbTable.getParentFrame(), e.getMessage(), this.dbTable.getString("InsertError"), 0);
                this.dbTable.setMessageEnd();
            } else if (this.rowUpdated) {
                try {
                    this.clearInsertUpdate();
                    this.update(inputOldRow);
                    break block16;
                }
                catch (Exception e) {
                    this.oldRow = oldRowAfterChange;
                    i = 0;
                    ** while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size())
                }
lbl-1000:
                // 1 sources

                {
                    if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(3, e.getMessage(), e)) {
                        return;
                    }
                    ++i;
                    continue;
                }
lbl47:
                // 1 sources

                if (this.dbTable.debug) {
                    e.printStackTrace();
                }
                this.dbTable.setMessageStart();
                JOptionPane.showMessageDialog(this.dbTable.getParentFrame(), e.getMessage(), this.dbTable.getString("UpdateError"), 0);
                this.dbTable.setMessageEnd();
            }
        }
        this.oldRow = oldRowAfterChange;
    }

    protected int insertTable(Vector insertElements, int row) {
        if (insertElements != null && insertElements.size() < this.getColumnCount()) {
            throw new RuntimeException("Inserted record has " + insertElements.size() + " fields, but the number of columns is " + this.getColumnCount());
        }
        int finalModelRow = 0;
        boolean addRow = true;
        if (row >= 0 && row < this.getRowCount()) {
            addRow = false;
        }
        if (addRow) {
            this.dataVector.addElement(new QuickVector(insertElements));
        } else {
            finalModelRow = this.tableSorter.getRowFromViewToFinalModel(row);
            this.dataVector.insertElementAt(new QuickVector(insertElements), finalModelRow);
        }
        ++this.lastAvailableRow;
        ++this.totalRow;
        this.setInsert();
        if (addRow) {
            this.oldRow = this.lastAvailableRow;
            return this.lastAvailableRow;
        }
        this.oldRow = finalModelRow;
        return finalModelRow;
    }

    protected void insert(int oldRow) throws Exception {
        int i;
        int i2;
        JTable thisTable = this.dbTable.getTable();
        if (thisTable.isEditing()) {
            thisTable.editingStopped(new ChangeEvent(thisTable));
        }
        if (oldRow >= this.dataVector.size()) {
            return;
        }
        if (this.databaseChangeListenerVector != null) {
            i2 = 0;
            while (i2 < this.databaseChangeListenerVector.size()) {
                if (!((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i2)).beforeInsert(this.tableSorter.convertRowFromFinalModelToView(oldRow))) {
                    if (this.dbTable.postponeDBInsert) {
                        this.insertFailed = true;
                        this.failedRow.put(new Integer(oldRow), "postpone");
                    }
                    if (this.dbTable.debug) {
                        System.out.println("insert cancelled by beforeInsert()");
                    }
                    return;
                }
                ++i2;
            }
        }
        if (this.insertSqlVector == null) {
            if (this.dbTable.debug) {
                System.out.println("InsertSql not set for DBTable, so this record is not inserted in database");
            }
            this.clearInsertUpdate();
            return;
        }
        if (this.insertStatement == null) {
            this.insertStatement = new QuickVector();
            i2 = 0;
            while (i2 < this.insertSqlVector.size()) {
                try {
                    this.insertStatement.addElement(this.dbConnection.prepareStatement((String)this.insertSqlVector.elementAt(i2)));
                }
                catch (Exception e) {
                    this.insertStatement = null;
                    System.out.println("Error during creating prepared statement for" + (String)this.insertSqlVector.elementAt(i2));
                    throw e;
                }
                ++i2;
            }
        }
        if (this.dbTable.autoCommit && this.dbConnection != null) {
            try {
                this.dbConnection.setAutoCommit(false);
            }
            catch (Throwable i3) {
                // empty catch block
            }
        }
        this.parent.setCursor(new Cursor(3));
        try {
            try {
                i = 0;
                while (i < this.insertStatement.size()) {
                    PreparedStatement pt = (PreparedStatement)this.insertStatement.elementAt(i);
                    int[] arr = (int[])this.insertSqlMappingVector.elementAt(i);
                    if (this.dbTable.debug) {
                        System.out.println("Executing sql " + this.insertSqlVector.elementAt(i) + " with arguments:");
                    }
                    int j = 1;
                    while (j <= arr.length) {
                        int viewCol = this.tableSorter.convertColumnFromFinalModelToView(arr[j - 1]);
                        Column thisCol = (Column)this.dbColumnModel.getColumnAsCreated(viewCol);
                        Object data = DBTypeMap.createObject(this.getRowCount() > 0 ? ((QuickVector)this.dataVector.elementAt(0)).elementAt(arr[j - 1]) : null, thisCol, ((QuickVector)this.dataVector.elementAt(oldRow)).elementAt(arr[j - 1]));
                        if (this.dbTable.debug) {
                            if (data == null) {
                                System.out.println("Argument " + j + ": Datatype in database:" + this.dbTable.getTypeName(thisCol.getType()) + ". Value:NULL");
                            } else {
                                System.out.println("Argument " + j + ": Datatype in database:" + this.dbTable.getTypeName(thisCol.getType()) + ". Datatype of cell data: " + data.getClass().getName() + ". Value:" + data);
                            }
                        }
                        if (data == null) {
                            try {
                                pt.setNull(j, thisCol.getType());
                            }
                            catch (Exception e) {
                                if (thisCol.getType() == 93) {
                                    pt.setNull(j, 1);
                                }
                            }
                        } else if (thisCol.getResultSetMap() != null) {
                            thisCol.getResultSetMap().setObject(pt, j, data);
                        } else {
                            pt.setObject(j, data);
                        }
                        ++j;
                    }
                    pt.executeUpdate();
                    pt.clearParameters();
                    ++i;
                }
                if (this.dbTable.autoCommit && this.dbConnection != null) {
                    this.dbConnection.commit();
                }
            }
            catch (Exception e) {
                if (this.dbTable.autoCommit && this.dbConnection != null) {
                    this.dbConnection.rollback();
                }
                throw e;
            }
        }
        finally {
            if (this.dbTable.autoCommit && this.dbConnection != null) {
                try {
                    this.dbConnection.setAutoCommit(true);
                }
                catch (Throwable throwable) {}
            }
            this.parent.setCursor(Cursor.getDefaultCursor());
            this.clearInsertUpdate();
        }
        if (this.databaseChangeListenerVector != null) {
            i = 0;
            while (i < this.databaseChangeListenerVector.size()) {
                ((DatabaseChangeListener)this.databaseChangeListenerVector.elementAt(i)).afterInsert(this.tableSorter.convertRowFromFinalModelToView(oldRow));
                ++i;
            }
        }
    }

    public boolean isInsertingRow(int row) {
        if (this.rowInserted && this.oldRow == row) {
            return true;
        }
        return this.insertFailed && this.failedRow.containsKey(new Integer(row));
    }

    private String substituteValuesInQuery(String oldQuery, int row) {
        StringTokenizer st = new StringTokenizer(oldQuery, "#", true);
        String query = new String();
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if ("#".equals(temp)) {
                query = String.valueOf(query) + ((QuickVector)this.dataVector.elementAt(row)).elementAt(Integer.parseInt(st.nextToken()) - 1);
                st.nextToken();
                continue;
            }
            query = String.valueOf(query) + temp;
        }
        return query;
    }

    protected void fetch(int noOfRows) throws SQLException {
        if (noOfRows < this.pageSize) {
            noOfRows = this.pageSize;
        }
        this.dataVector.ensureCapacity(this.pageSize);
        ResultSetMetaData metaData = this.tableResultSet.getMetaData();
        int totalColumns = metaData.getColumnCount();
        ResultSetMap[] rMap = new ResultSetMap[totalColumns];
        boolean[] isTimeStamp = new boolean[totalColumns];
        int m = 0;
        while (m < totalColumns) {
            Column c = (Column)this.dbColumnModel.getColumnAsCreated(m);
            rMap[m] = c.getResultSetMap();
            isTimeStamp[m] = c.getType() == 93;
            ++m;
        }
        int i = 0;
        while (i < noOfRows) {
            if (this.dataVector.size() + i >= this.maxRow || !this.tableResultSet.next()) break;
            QuickVector rowVector = new QuickVector();
            rowVector.ensureCapacity(totalColumns);
            int j = 1;
            while (j <= totalColumns) {
                if (rMap[j - 1] != null) {
                    rowVector.addElement(rMap[j - 1].getObject(this.tableResultSet, j));
                } else if (isTimeStamp[j - 1]) {
                    rowVector.addElement(this.tableResultSet.getTimestamp(j));
                } else {
                    rowVector.addElement(this.tableResultSet.getObject(j));
                }
                ++j;
            }
            int k = 0;
            while (k < this.addedColumnSize) {
                rowVector.addElement("");
                ++k;
            }
            this.dataVector.addElement(rowVector);
            ++i;
        }
        this.lastAvailableRow = this.dataVector.size() - 1;
    }

    protected void close() throws SQLException {
        this.rowSelectionChanged();
        if (this.tableResultSet != null) {
            try {
                this.tableResultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tableResultSet = null;
        }
        if (this.tableStatement != null) {
            try {
                this.tableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tableStatement = null;
        }
        int i = 0;
        while (this.updateStatement != null && i < this.updateStatement.size()) {
            try {
                ((PreparedStatement)this.updateStatement.elementAt(i)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateStatement = null;
            ++i;
        }
        i = 0;
        while (this.insertStatement != null && i < this.insertStatement.size()) {
            try {
                ((PreparedStatement)this.insertStatement.elementAt(i)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.insertStatement = null;
            ++i;
        }
        i = 0;
        while (this.deleteStatement != null && i < this.deleteStatement.size()) {
            try {
                ((PreparedStatement)this.deleteStatement.elementAt(i)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deleteStatement = null;
            ++i;
        }
        if (this.selfConnection && this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void createRowCountSql() {
        this.dbTable.rowCountSql = null;
        if (this.dbTable.userRowCountSql != null) {
            return;
        }
        if (this.dbTable.selectSql == null) {
            throw new RuntimeException("Select sql not set for dbtable");
        }
        String sql = this.dbTable.selectSql.toUpperCase();
        if ((sql = sql.trim()).indexOf("SELECT ") != -1 && sql.indexOf(" COUNT(") == -1 && sql.indexOf(" DISTINCT ") == -1 && sql.indexOf(" GROUP ") == -1) {
            this.dbTable.rowCountSql = sql.indexOf("ORDER BY") != -1 ? "SELECT COUNT(*) " + this.dbTable.selectSql.substring(sql.indexOf("FROM"), sql.indexOf("ORDER BY")) : (sql.indexOf(" LIMIT ") != -1 ? "SELECT COUNT(*) " + this.dbTable.selectSql.substring(sql.indexOf("FROM"), sql.indexOf("LIMIT")) : "SELECT COUNT(*) " + this.dbTable.selectSql.substring(sql.indexOf("FROM")));
        } else {
            System.out.println("Unable to automatically create rowcount sql. Optionally you can provide rowcount sql using DBTable.setRowCountSql(String rowCountSql) to get better performance. Refer api for setRowCountSql() for more info.");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void createColumnModelFromQuery() throws SQLException {
        block6: {
            if (this.dbConnection == null) {
                try {
                    this.createDatabaseConnection();
                    break block6;
                }
                catch (ClassNotFoundException e) {
                    i = 0;
                    ** while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size())
                }
lbl-1000:
                // 1 sources

                {
                    if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(2, e.getMessage(), e)) {
                        return;
                    }
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.dbTable.setMessageStart();
                JOptionPane.showMessageDialog(this.dbTable.getParentFrame(), this.dbTable.getString("DriverNotFound"));
                this.dbTable.setMessageEnd();
            }
        }
        tableStatement1 = this.dbConnection.createStatement();
        rs = tableStatement1.executeQuery(this.dbTable.selectSql);
        this.createColumnModelFromQuery(rs);
        if (rs != null) {
            rs.close();
            rs = null;
        }
        tableStatement1.close();
        tableStatement1 = null;
    }

    protected void createColumnModelFromQuery(ResultSet rs) throws SQLException {
        this.addedColumnSize = 0;
        ResultSetMetaData metaData = null;
        if (rs == null) {
            this.createColumnModelFromQuery();
            return;
        }
        metaData = rs.getMetaData();
        Vector<Column> columnVector = new Vector<Column>();
        if (this.dbTable.debug) {
            System.out.println("Database meta data information received from jdbc driver");
        }
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            int tempLength;
            if (this.dbTable.debug) {
                System.out.println("Column " + i + ": Name: " + metaData.getColumnName(i) + "\n" + "            ReadOnly: " + !metaData.isWritable(i) + "\n" + "            Data Type: " + this.dbTable.getTypeName(metaData.getColumnType(i)));
            }
            Column f = new Column(i, metaData.getColumnName(i));
            f.setReadOnly(!metaData.isWritable(i));
            if (this.dbTable.header != null) {
                f.setHeaderRenderer(this.dbTable.header);
            }
            f.setHeaderValue(metaData.getColumnLabel(i));
            f.setNullable(metaData.isNullable(i) != 0);
            f.setType(metaData.getColumnType(i));
            int type = f.getType();
            if (type == 2 || type == 6 || type == 8 || type == -5 || type == 3 || type == 4 || type == 5 || type == -6 || type == 7) {
                f.setPrecision(metaData.getPrecision(i) == 0 ? metaData.getColumnDisplaySize(i) : metaData.getPrecision(i));
                f.setScale(metaData.getScale(i));
                f.setSigned(metaData.isSigned(i));
                tempLength = f.getPrecision();
                if (this.dbTable.debug) {
                    System.out.println("            Precision: " + metaData.getPrecision(i) + "\n" + "            Scale: " + metaData.getScale(i) + "\n" + "            Signed: " + metaData.isSigned(i));
                }
            } else {
                f.setLength(metaData.getColumnDisplaySize(i));
                tempLength = metaData.getColumnDisplaySize(i);
                if (this.dbTable.debug) {
                    System.out.println("            Length: " + metaData.getColumnDisplaySize(i));
                }
            }
            if (tempLength < 5) {
                f.setPreferredWidth(tempLength * 10);
            } else if (tempLength < 25) {
                f.setPreferredWidth(tempLength * 6);
            } else if (tempLength < 50) {
                f.setPreferredWidth(tempLength * 4);
            } else {
                f.setPreferredWidth(200);
            }
            if (this.dbTable.debug) {
                System.out.println();
            }
            columnVector.addElement(f);
            ++i;
        }
        this.dbColumnModel.createColumnModel(columnVector);
    }

    public void fireTableCellUpdated(int r, int c) {
        super.fireTableCellUpdated(r, c);
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }
}

