/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import quick.dbtable.Column;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableCalendarDialog;
import quick.dbtable.DBTableCellEditor;
import quick.dbtable.DBTableCellRenderer;
import quick.dbtable.DBTableErrorListener;
import quick.dbtable.DBTableModel;
import quick.dbtable.DecimalDocument;
import quick.dbtable.LengthDocument;
import quick.dbtable.NumericDocument;
import quick.dbtable.QuickVector;

class DBTableColumnModel
extends DefaultTableColumnModel
implements Serializable {
    private transient Connection dbConnection;
    protected transient boolean defaultColumnsDisplayed = true;
    private transient DBTable dbTable;
    private transient DBTableModel dbTableModel;

    DBTableColumnModel() {
    }

    public void setConnection(Connection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public void set(DBTable dbTable, DBTableModel dbTableModel) {
        this.dbTable = dbTable;
        this.dbTableModel = dbTableModel;
    }

    protected void createColumnModel(Vector columnVector) {
        if (this.tableColumns != null && this.tableColumns.size() > 0) {
            while (this.tableColumns.size() > 0) {
                this.removeColumn((TableColumn)this.tableColumns.elementAt(0));
            }
        }
        this.tableColumns = null;
        this.tableColumns = columnVector;
        int i = 0;
        while (i < columnVector.size()) {
            Column tc = (Column)columnVector.elementAt(i);
            tc.addPropertyChangeListener(this);
            this.setType(tc);
            ++i;
        }
        this.recalcWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, columnVector.size() - 1));
        this.defaultColumnsDisplayed = false;
    }

    protected void addColumn(Column yourColumn) {
        yourColumn.addPropertyChangeListener(this);
        this.setType(yourColumn);
        super.addColumn(yourColumn);
        this.defaultColumnsDisplayed = false;
    }

    protected void setDefaultColumns() {
        if (this.tableColumns != null && this.tableColumns.size() > 0) {
            while (this.tableColumns.size() > 0) {
                this.removeColumn((TableColumn)this.tableColumns.elementAt(0));
            }
        }
        this.addColumn(new Column(1, "A"));
        this.addColumn(new Column(1, "B"));
        this.addColumn(new Column(1, "C"));
        this.addColumn(new Column(1, "D"));
        this.defaultColumnsDisplayed = true;
    }

    protected void createDefaultColumns(int count) {
        while (this.getColumnCount() != 0) {
            this.removeColumn(this.getColumn(0));
        }
        int i = 0;
        while (i < count) {
            char title = (char)(65 + i);
            Column f = new Column(i + 1, new Character(title).toString());
            f.setReadOnly(false);
            if (this.dbTable.header != null) {
                f.setHeaderRenderer(this.dbTable.header);
            }
            f.setHeaderValue(new Character(title).toString());
            f.setType(12);
            f.setLength(255);
            this.addColumn(f);
            ++i;
        }
        this.defaultColumnsDisplayed = false;
    }

    protected void createColumnModelFromNames(QuickVector rowData) {
        while (this.getColumnCount() != 0) {
            this.removeColumn(this.getColumn(0));
        }
        this.tableColumns = null;
        this.tableColumns = new Vector();
        int i = 0;
        while (i < rowData.size()) {
            Column f = new Column(i + 1, (String)rowData.elementAt(i));
            f.setReadOnly(false);
            if (this.dbTable.header != null) {
                f.setHeaderRenderer(this.dbTable.header);
            }
            f.setHeaderValue(rowData.elementAt(i));
            f.setType(12);
            f.setLength(255);
            this.addColumn(f);
            ++i;
        }
        this.defaultColumnsDisplayed = false;
    }

    protected void refreshBoundColumn(int col) throws SQLException {
        this.refreshBoundColumn((Column)this.tableColumns.elementAt(col));
    }

    /*
     * Unable to fully structure code
     */
    protected void refreshBoundColumn(Column tc) {
        block24: {
            stmt = null;
            rs = null;
            try {
                try {
                    stmt = this.dbConnection.createStatement();
                    rs = stmt.executeQuery(tc.getBoundSql());
                    if (rs.getMetaData().getColumnCount() > 1) {
                        sortVector = new Vector<String>();
                        hash = new Hashtable<String, String>();
                        while (rs.next()) {
                            key = rs.getString(1);
                            sortVector.addElement(key);
                            hash.put(key, rs.getString(2));
                        }
                        tc.setCellComponent(5, hash, sortVector.toArray(), this.dbTable, false);
                    } else if (rs.getMetaData().getColumnCount() == 1) {
                        jc = new JComboBox<String>();
                        while (rs.next()) {
                            jc.addItem(rs.getString(1));
                        }
                        tc.setCellEditor(new DBTableCellEditor(jc, this.dbTable));
                    }
                    break block24;
                }
                catch (Exception e) {
                    i = 0;
                    ** while (this.dbTable.errorListenerVector != null && i < this.dbTable.errorListenerVector.size())
                }
lbl-1000:
                // 1 sources

                {
                    if (((DBTableErrorListener)this.dbTable.errorListenerVector.elementAt(i)).errorOccured(7, e.getMessage(), e)) {
                        return;
                    }
                    ++i;
                    continue;
                }
lbl32:
                // 1 sources

                if (this.dbTable.debug) {
                    e.printStackTrace();
                }
                this.dbTable.setMessageStart();
                JOptionPane.showMessageDialog(this.dbTableModel.parent, e.getMessage(), "Error in boundSql!", 0);
                this.dbTable.setMessageEnd();
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (SQLException var8_13) {}
            }
        }
    }

    private boolean isDecimal(Column c) {
        int type = c.getType();
        return type == 2 && c.getScale() == 0 || type == 6 || type == 8 || type == 3 || type == 7;
    }

    private void setType(Column tc) {
        boolean userRenderer;
        boolean userEditor = tc.getUserCellEditor() != null;
        boolean bl = userRenderer = tc.getUserCellRenderer() != null;
        if (userEditor && userRenderer) {
            return;
        }
        DBTableCellEditor dc = (DBTableCellEditor)tc.getCellEditor();
        Component o = null;
        if (dc != null) {
            o = dc.getComponent();
        }
        int type = tc.getType();
        if (!userEditor) {
            if (type == 2 || type == 6 || type == 8 || type == 3 || type == 7 || type == -5 || type == 4 || type == 5 || type == -6) {
                if (o == null || !(o instanceof JTextField)) {
                    o = null;
                    dc = null;
                    dc = new DBTableCellEditor(3, null, this.dbTable);
                    tc.setCellEditor(dc);
                    o = dc.getComponent();
                } else {
                    tc.setCellEditor(new DBTableCellEditor((JTextField)o, this.dbTable));
                }
                this.setDecimalLength((JTextField)o, tc.getPrecision(), tc.getScale(), tc.getSigned(), tc.getModelIndex(), this.isDecimal(tc));
            } else if (type == 91 || type == 93 || type == 92) {
                this.setDatePattern(tc, -1);
            } else if (type == -1) {
                if (o == null || !(o instanceof JTextArea)) {
                    o = null;
                    dc = null;
                    dc = new DBTableCellEditor(6, null, this.dbTable);
                    tc.setCellEditor(dc);
                    o = dc.getComponent();
                } else {
                    tc.setCellEditor(new DBTableCellEditor((JTextArea)o, this.dbTable));
                }
                this.setLength((JTextArea)o, tc.getLength());
            } else {
                if (o == null || !(o instanceof JTextField)) {
                    o = null;
                    dc = null;
                    dc = new DBTableCellEditor(3, null, this.dbTable);
                    tc.setCellEditor(dc);
                    o = dc.getComponent();
                } else {
                    tc.setCellEditor(new DBTableCellEditor((JTextField)o, this.dbTable));
                }
                this.setLength((JTextField)o, tc.getLength());
            }
        }
        if (!userRenderer) {
            if (type == 91 || type == 93 || type == 92) {
                this.setDatePattern(tc, 1);
            } else if (type == -1) {
                tc.setCellRenderer(new DBTableCellRenderer(6, null, this.dbTable));
            } else {
                tc.setCellRenderer(new DBTableCellRenderer(3, null, this.dbTable));
            }
        }
    }

    private void setSigned(JTextField jt, int precision, int scale, boolean signed, int columnIndex, boolean isDecimal) {
        Document d = jt.getDocument();
        if (isDecimal) {
            if (d == null || !(d instanceof DecimalDocument)) {
                d = null;
                d = new DecimalDocument(precision, scale, columnIndex, this.dbTable);
                jt.setDocument(d);
            }
            ((DecimalDocument)d).setSigned(signed);
        } else {
            if (d == null || !(d instanceof NumericDocument)) {
                d = null;
                d = new NumericDocument(precision, columnIndex, this.dbTable);
                jt.setDocument(d);
            }
            ((NumericDocument)d).setSigned(signed);
        }
    }

    private void setDecimalLength(JTextField jt, int precision, int scale, boolean signed, int columnIndex, boolean isDecimal) {
        Document d = jt.getDocument();
        if (isDecimal) {
            if (d != null && d instanceof DecimalDocument) {
                ((DecimalDocument)d).changePrecisionTo(precision);
                ((DecimalDocument)d).changeScaleTo(scale);
            } else {
                d = null;
                d = new DecimalDocument(precision, scale, columnIndex, this.dbTable);
                jt.setDocument(d);
            }
            ((DecimalDocument)d).setSigned(signed);
        } else {
            if (d != null && d instanceof NumericDocument) {
                ((NumericDocument)d).changeSizeTo(precision);
            } else {
                d = null;
                d = new NumericDocument(precision, columnIndex, this.dbTable);
                jt.setDocument(d);
            }
            ((NumericDocument)d).setSigned(signed);
        }
    }

    private void setLength(JTextComponent jt, int length) {
        Document d = jt.getDocument();
        if (d != null && d instanceof LengthDocument) {
            ((LengthDocument)d).changeSizeTo(length);
        } else {
            d = null;
            d = new LengthDocument(length, this.dbTable);
            jt.setDocument(d);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("boundSql".equals(name)) {
            Column c = (Column)evt.getNewValue();
            this.refreshBoundColumn(c);
        } else if ("columnName".equals(name)) {
            JTableHeader jc = this.dbTable.getTable().getTableHeader();
            jc.validate();
            jc.repaint();
        } else if ("length".equals(name)) {
            Column c = (Column)evt.getNewValue();
            DBTableCellEditor dc = (DBTableCellEditor)c.getCellEditor();
            Component o = null;
            if (dc != null) {
                o = dc.getComponent();
            }
            if (o == null || !(o instanceof JTextField)) {
                o = null;
                o = new JTextField();
                dc = null;
                c.setCellEditor(new DBTableCellEditor((JTextField)o, this.dbTable));
            }
            this.setLength((JTextField)o, c.getLength());
        } else if (!"nullable".equals(name)) {
            if ("precision".equals(name)) {
                Column c = (Column)evt.getNewValue();
                DBTableCellEditor dc = (DBTableCellEditor)c.getCellEditor();
                Component o = null;
                if (dc != null) {
                    o = dc.getComponent();
                }
                if (o == null || !(o instanceof JTextField)) {
                    o = null;
                    dc = null;
                    o = new JTextField();
                    c.setCellEditor(new DBTableCellEditor((JTextField)o, this.dbTable));
                }
                this.setDecimalLength((JTextField)o, c.getPrecision(), c.getScale(), c.getSigned(), c.getModelIndex(), this.isDecimal(c));
            } else if (!"readOnly".equals(name)) {
                if ("scale".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    DBTableCellEditor dc = (DBTableCellEditor)c.getCellEditor();
                    Component o = null;
                    if (dc != null) {
                        o = dc.getComponent();
                    }
                    if (o == null || !(o instanceof JTextField)) {
                        o = null;
                        dc = null;
                        o = new JTextField();
                        c.setCellEditor(new DBTableCellEditor((JTextField)o, this.dbTable));
                    }
                    this.setDecimalLength((JTextField)o, c.getPrecision(), c.getScale(), c.getSigned(), c.getModelIndex(), this.isDecimal(c));
                } else if ("signed".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    int columnIndex = c.getModelIndex();
                    DBTableCellEditor dc = (DBTableCellEditor)c.getCellEditor();
                    Component o = null;
                    if (dc != null) {
                        o = dc.getComponent();
                    }
                    if (o == null || !(o instanceof JTextField)) {
                        o = null;
                        dc = null;
                        o = new JTextField();
                        c.setCellEditor(new DBTableCellEditor((JTextField)o, this.dbTable));
                    }
                    this.setSigned((JTextField)o, c.getPrecision(), c.getScale(), c.getSigned(), columnIndex, this.isDecimal(c));
                } else if ("type".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    this.setType(c);
                } else if ("dateFormat".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    this.setDatePattern(c, 0);
                } else if ("document".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    this.setDocument(c);
                } else if ("datamap".equals(name)) {
                    JTable jt = this.dbTable.getTable();
                    jt.validate();
                    jt.repaint();
                } else if ("editor".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    c.setCellEditor(new DBTableCellEditor(c.getUserCellEditor(), this.dbTable));
                } else if ("renderer".equals(name)) {
                    Column c = (Column)evt.getNewValue();
                    c.setCellRenderer(new DBTableCellRenderer(c.getUserCellRenderer(), this.dbTable));
                } else if (!"visible".equals(name)) {
                    super.propertyChange(evt);
                }
            }
        }
    }

    public void setDocument(Column tc) {
        DBTableCellEditor dc = (DBTableCellEditor)tc.getCellEditor();
        Component o = null;
        if (dc != null) {
            o = dc.getComponent();
        }
        if (o instanceof JTextField) {
            JTextField jt = (JTextField)o;
            Document d = tc.getDocument();
            if (d != null) {
                jt.setDocument(d);
            }
        } else {
            System.out.println("Document cannot be set for this column. Please check whether this column editor is Textfield or whether you gave the correct column number.");
        }
    }

    public void setDatePattern(Column tc, int mode) {
        SimpleDateFormat format;
        if (tc.getType() != 91 && tc.getType() != 93 && tc.getType() != 92) {
            System.out.println("Date pattern cannot be set for this column, since this column is not a Date type column");
            return;
        }
        String pattern = tc.getDateFormat() != null ? tc.getDateFormat() : (tc.getType() == 93 ? "dd-MMM-yyyy hh:mm:ss" : "dd-MMM-yyyy");
        try {
            format = new SimpleDateFormat(pattern);
            format.format(new Date());
        }
        catch (Exception e) {
            format = new SimpleDateFormat();
            System.out.println("Invalid date format pattern " + pattern + ". Default format " + format.toPattern() + " will be used.");
        }
        Hashtable<String, SimpleDateFormat> ht = new Hashtable<String, SimpleDateFormat>();
        ht.put("pattern", format);
        if (mode <= 0) {
            DBTableCellEditor dc = new DBTableCellEditor(4, ht, this.dbTable);
            tc.setCellEditor(dc);
        }
        if (mode >= 0) {
            DBTableCellRenderer dr = new DBTableCellRenderer(4, ht, this.dbTable);
            tc.setCellRenderer(dr);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent e) {
        if (e.getLastIndex() < this.tableColumns.size()) {
            super.fireColumnSelectionChanged(e);
        }
    }

    public TableColumn getColumn(int c) {
        if (c >= this.tableColumns.size()) {
            throw new RuntimeException("Column " + c + " is not available");
        }
        return super.getColumn(c);
    }

    public TableColumn getColumnAsCreated(int c) {
        int colCount = this.tableColumns.size();
        int i = 0;
        while (i < colCount) {
            TableColumn col = this.getColumn(i);
            if (col.getModelIndex() == c + 1) {
                return col;
            }
            ++i;
        }
        return null;
    }

    public int getCurrentIndexForOriginalColumn(int c) {
        int colCount = this.tableColumns.size();
        int i = 0;
        while (i < colCount) {
            TableColumn col = this.getColumn(i);
            if (col.getModelIndex() == c + 1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getOriginalColumnIndex(int c) {
        return this.getColumn(c).getModelIndex() - 1;
    }

    public Column getColumnByDatabaseName(String colName) {
        if (colName == null) {
            return null;
        }
        int colCount = this.tableColumns.size();
        int i = 0;
        while (i < colCount) {
            Column c = (Column)super.getColumn(i);
            if (colName.equals(c.getColumnName())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public Column getColumnByHeaderName(String colName) {
        if (colName == null) {
            return null;
        }
        int colCount = this.tableColumns.size();
        int i = 0;
        while (i < colCount) {
            Column c = (Column)super.getColumn(i);
            if (colName.equals(c.getHeaderValue())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public void removeColumn(TableColumn column) {
        DBTableCalendarDialog d;
        Column tc;
        if (column instanceof Column && ((tc = (Column)column).getType() == 91 || tc.getType() == 93 || tc.getType() == 92) && (d = (DBTableCalendarDialog)((DBTableCellEditor)tc.getCellEditor()).getSecondaryEditorComponent()) != null) {
            d.dispose();
        }
        super.removeColumn(column);
        int removeIndex = column.getModelIndex();
        int i = 0;
        while (i < this.tableColumns.size()) {
            Column c = (Column)super.getColumn(i);
            if (c.getModelIndex() > removeIndex) {
                c.setModelIndex(c.getModelIndex() - 1);
            }
            ++i;
        }
    }
}

