/*
 * Decompiled with CFR 0.152.
 */
package quick.dbtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import quick.dbtable.CellComponent;
import quick.dbtable.CellPropertiesModel;
import quick.dbtable.Column;
import quick.dbtable.DBTable;

public class DBTableCellRenderer
implements TableCellRenderer,
Serializable {
    private Color unselectedForeground;
    private Color unselectedBackground;
    private int cellType = -1;
    private Hashtable cellValueToDisplayHash = null;
    private JComponent comp;
    private DBTable dBTable;
    private CellComponent cc;

    private DBTableCellRenderer() {
    }

    protected int getCellType() {
        return this.cellType;
    }

    public DBTableCellRenderer(int cellType, Hashtable cellValueToDisplayHash, DBTable dBTable) {
        this();
        this.cellType = cellType;
        this.cellValueToDisplayHash = cellValueToDisplayHash;
        this.dBTable = dBTable;
        if (cellType == 7) {
            throw new RuntimeException("USER cell cannot be created using this constructor, please use the constructor DBTableCellRenderer(CellComponent, DBTable)");
        }
        if (cellValueToDisplayHash == null && cellType != 3 && cellType != 5 && cellType != 7 && cellType != 6) {
            throw new RuntimeException("cellValueToDisplayHashtable cannot be null");
        }
        switch (cellType) {
            case 0: {
                this.comp = new JLabel();
                break;
            }
            case 1: {
                this.comp = new JCheckBox();
                break;
            }
            case 2: {
                this.comp = new JRadioButton();
                break;
            }
            case 6: {
                JTextArea jp = new JTextArea(".");
                jp.setLineWrap(true);
                jp.setWrapStyleWord(true);
                this.comp = jp;
                break;
            }
            default: {
                this.comp = new JLabel();
            }
        }
        this.comp.setOpaque(true);
    }

    public DBTableCellRenderer(CellComponent cc, DBTable dBTable) {
        this();
        this.cellType = 7;
        this.dBTable = dBTable;
        this.cc = cc;
        this.comp = cc.getComponent();
        this.comp.setOpaque(true);
    }

    public void updateUI() {
        this.comp.updateUI();
        this.comp.setForeground(null);
        this.comp.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        column = this.dBTable.getOriginalColumnIndex(column);
        CellPropertiesModel cellModel = this.dBTable.getCellPropertiesModel();
        if (cellModel.getFont(row, column) != null) {
            this.comp.setFont(cellModel.getFont(row, column));
        } else {
            this.comp.setFont((Font)this.dBTable.getSkinProperty("Quicktable.tableFont"));
        }
        if (this.cellType == 3 || this.cellType == 0 || this.cellType == 4) {
            if (cellModel.getAlignment(row, column) != -1) {
                ((JLabel)this.comp).setHorizontalAlignment(cellModel.getAlignment(row, column));
            } else {
                ((JLabel)this.comp).setHorizontalAlignment(2);
            }
        } else if (this.cellType == 2 || this.cellType == 1) {
            if (cellModel.getAlignment(row, column) != -1) {
                ((AbstractButton)this.comp).setHorizontalAlignment(cellModel.getAlignment(row, column));
            } else {
                ((AbstractButton)this.comp).setHorizontalAlignment(2);
            }
        }
        if (hasFocus) {
            if (table.isEditing()) {
                this.comp.setBorder((Border)this.dBTable.getSkinProperty("Quicktable.CellBorder"));
                Color fore = cellModel.getSelectionForeground(row, column);
                Color back = cellModel.getSelectionBackground(row, column);
                this.comp.setForeground(fore != null ? fore : table.getSelectionForeground());
                this.comp.setBackground(back != null ? back : table.getSelectionBackground());
            } else {
                this.comp.setBorder((Border)this.dBTable.getSkinProperty("Quicktable.focusCellHighlightBorder"));
                this.comp.setForeground((Color)this.dBTable.getSkinProperty("Quicktable.focusCellForeground"));
                this.comp.setBackground((Color)this.dBTable.getSkinProperty("Quicktable.focusCellBackground"));
            }
        } else {
            this.comp.setBorder((Border)this.dBTable.getSkinProperty("Quicktable.CellBorder"));
            if (isSelected) {
                Color fore = cellModel.getSelectionForeground(row, column);
                Color back = cellModel.getSelectionBackground(row, column);
                this.comp.setForeground(fore != null ? fore : table.getSelectionForeground());
                this.comp.setBackground(back != null ? back : table.getSelectionBackground());
            } else {
                Color fore = cellModel.getForeground(row, column);
                Color back = cellModel.getBackground(row, column);
                this.comp.setForeground(fore != null ? fore : table.getForeground());
                this.comp.setBackground(back != null ? back : table.getBackground());
            }
        }
        this.setValue(value);
        return this.comp;
    }

    protected void setValue(Object value) {
        switch (this.cellType) {
            case 0: {
                if (value == null || "".equals(value)) {
                    ((JLabel)this.comp).setIcon(Column.getEmptyIcon());
                    break;
                }
                Object o = this.cellValueToDisplayHash.get(value);
                if (o != null) {
                    ((JLabel)this.comp).setIcon((Icon)o);
                    return;
                }
                if (!(value instanceof String) && (o = this.cellValueToDisplayHash.get(value.toString())) != null) {
                    ((JLabel)this.comp).setIcon((Icon)o);
                    return;
                }
                ((JLabel)this.comp).setIcon(Column.getEmptyIcon());
                break;
            }
            case 1: {
                if (value == null) {
                    ((JCheckBox)this.comp).setSelected(false);
                    break;
                }
                Object o = this.cellValueToDisplayHash.get(value);
                if (o != null) {
                    ((JCheckBox)this.comp).setSelected((Boolean)o);
                    return;
                }
                if (!(value instanceof String) && (o = this.cellValueToDisplayHash.get(value.toString())) != null) {
                    ((JCheckBox)this.comp).setSelected((Boolean)o);
                    return;
                }
                ((JCheckBox)this.comp).setSelected(false);
                break;
            }
            case 2: {
                if (value == null) {
                    ((JRadioButton)this.comp).setSelected(false);
                    break;
                }
                Object o = this.cellValueToDisplayHash.get(value);
                if (o != null) {
                    ((JRadioButton)this.comp).setSelected((Boolean)o);
                    return;
                }
                if (!(value instanceof String) && (o = this.cellValueToDisplayHash.get(value.toString())) != null) {
                    ((JRadioButton)this.comp).setSelected((Boolean)o);
                    return;
                }
                ((JRadioButton)this.comp).setSelected(false);
                break;
            }
            case 5: {
                if (this.cellValueToDisplayHash != null) {
                    if (value == null || "".equals(value)) {
                        ((JLabel)this.comp).setText("");
                        break;
                    }
                    Object o = this.cellValueToDisplayHash.get(value);
                    if (o != null) {
                        ((JLabel)this.comp).setText(o.toString());
                        return;
                    }
                    if (!(value instanceof String) && (o = this.cellValueToDisplayHash.get(value.toString())) != null) {
                        ((JLabel)this.comp).setText(o.toString());
                        return;
                    }
                    ((JLabel)this.comp).setText("");
                    break;
                }
                ((JLabel)this.comp).setText(value == null ? "" : value.toString());
                break;
            }
            case 4: {
                SimpleDateFormat pattern = (SimpleDateFormat)this.cellValueToDisplayHash.get("pattern");
                if (pattern == null) {
                    pattern = new SimpleDateFormat();
                    System.out.println("For date type column, new DBTableCellEditor constructor should not be used. Use column.setType method");
                }
                if (!(value instanceof Date)) {
                    value = null;
                }
                ((JLabel)this.comp).setText(value == null ? "" : pattern.format((Date)value));
                break;
            }
            case 6: {
                ((JTextArea)this.comp).setText(value == null ? "" : value.toString());
                break;
            }
            case 7: {
                this.cc.setValue(value);
                break;
            }
            default: {
                ((JLabel)this.comp).setText(value == null ? "" : value.toString());
            }
        }
    }
}

