/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;
import com.objectplanet.chart.PieChart;

public class PieChartApplet
extends ChartApplet {
    public PieChart chart;

    protected Chart createChart(String string) {
        if (string == null || string.equals("")) {
            string = "com.objectplanet.chart.PieChart";
        }
        try {
            Class<?> clazz = Class.forName(string);
            PieChart pieChart = (PieChart)clazz.newInstance();
            return pieChart;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: " + string);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Could not create an instance of teh class: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Illegal access, could not create an instance of class: " + string);
        }
        catch (ClassCastException classCastException) {
            System.out.println("The class " + string + ", does not extend from com.objectplanet.chart.PieChart");
        }
        return new PieChart();
    }

    private void initParameter(String string, String string2) {
        if (string2 != null) {
            this.setParameter(string, string2);
        }
    }

    public void setParameter(String string, String string2) {
        if (string == null) {
            return;
        }
        if ((string = string.toLowerCase()).equals("angle")) {
            if (string2 != null && string2.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string2);
                    n = Math.max(10, n);
                    n = Math.min(80, n);
                    this.chart.setAngle(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid angle: " + string2);
                    this.chart.setAngle(20);
                }
            } else {
                this.chart.setAngle(20);
            }
        } else if (string.equals("depth")) {
            if (string2 != null && string2.trim().length() > 0) {
                try {
                    double d = new Float(string2).floatValue();
                    d = Math.max(0.0, d);
                    d = Math.min(1.0, d);
                    this.chart.setDepth((float)d);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid depth: " + string2);
                    this.chart.setDepth(0.4f);
                }
            } else {
                this.chart.setDepth(0.4f);
            }
        } else if (string.equals("serieslabelson")) {
            this.chart.setSeriesLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("serieslabelstyle")) {
            this.chart.setSeriesLabelStyle(0);
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.trim().toLowerCase().equals("inside")) {
                    this.chart.setSeriesLabelStyle(1);
                } else if (string2.trim().toLowerCase().equals("outside")) {
                    this.chart.setSeriesLabelStyle(2);
                }
            }
        } else if (string.equals("samplelabelson")) {
            this.chart.setSampleLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("samplelabelstyle")) {
            this.chart.setSampleLabelStyle(0);
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.trim().toLowerCase().equals("inside")) {
                    this.chart.setSampleLabelStyle(1);
                } else if (string2.trim().toLowerCase().equals("outside")) {
                    this.chart.setSampleLabelStyle(2);
                }
            }
        } else if (string.equals("valuelabelson")) {
            this.chart.setValueLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("valuelabelstyle")) {
            this.chart.setValueLabelStyle(0);
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.trim().toLowerCase().equals("inside")) {
                    this.chart.setValueLabelStyle(1);
                } else if (string2.trim().toLowerCase().equals("outside")) {
                    this.chart.setValueLabelStyle(2);
                }
            }
        } else if (string.equals("percentlabelson")) {
            this.chart.setPercentLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("percentlabelstyle")) {
            this.chart.setPercentLabelStyle(0);
            if (string2 != null && string2.trim().length() > 0) {
                if (string2.trim().toLowerCase().equals("inside")) {
                    this.chart.setPercentLabelStyle(1);
                } else if (string2.trim().toLowerCase().equals("outside")) {
                    this.chart.setPercentLabelStyle(2);
                }
            }
        } else if (string.equals("pielabelson")) {
            this.chart.setPieLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("percentdecimalcount")) {
            if (string2 != null && string2.trim().length() > 0) {
                try {
                    this.chart.setPercentDecimalCount(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid percentDecimalCount: " + string2);
                    this.chart.setPercentDecimalCount(0);
                }
            } else {
                this.chart.setPercentDecimalCount(0);
            }
        } else if (string.equals("sliceseperatoron")) {
            this.chart.setSliceSeperatorOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("sliceseperatorcolor")) {
            if (string2 != null && string2.length() > 0) {
                this.chart.setSliceSeperatorColor(ChartApplet.createColor(string2));
            } else {
                this.chart.setSliceSeperatorColor(null);
            }
        } else if (string.equals("selectionstyle")) {
            int n = 0;
            if (string2 != null) {
                if (string2.equals("circle")) {
                    n = 1;
                } else if (string2.equals("detached")) {
                    n = 2;
                }
            }
            this.chart.setSelectionStyle(n);
        } else if (string.equals("detacheddistance")) {
            this.chart.setDetachedDistance(0.1);
            if (string2 != null && string2.length() > 0) {
                try {
                    double d = new Double(string2);
                    this.chart.setDetachedDistance(Math.max(0.0, d));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid detachDistance: " + string2);
                }
            }
        } else if (string.startsWith("detachedslices")) {
            int n = string.equals("detachedslices") ? 0 : -1;
            try {
                if (string.length() > 15) {
                    n = Integer.parseInt(string.substring(15));
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid index in detachedSlices_N parameter: " + string);
            }
            Double[] doubleArray = ChartApplet.getDoubleValues(string2);
            int n2 = this.chart.getSeriesCount();
            int n3 = this.chart.getSampleCount();
            if (n2 == 1) {
                int n4 = 0;
                while (n4 < n3) {
                    this.chart.setDetachedSlice(0, n4, 0.0);
                    ++n4;
                }
                if (doubleArray != null) {
                    double d = this.chart.getDetachedDistance();
                    int n5 = 0;
                    while (n5 < doubleArray.length) {
                        int n6 = doubleArray[n5].intValue();
                        if (n6 < n3) {
                            this.chart.setDetachedSlice(0, n6, d);
                        }
                        ++n5;
                    }
                }
            } else if (n < n3) {
                int n7 = 0;
                while (n7 < n2) {
                    this.chart.setDetachedSlice(n7, n, 0.0);
                    ++n7;
                }
                if (doubleArray != null) {
                    double d = this.chart.getDetachedDistance();
                    int n8 = 0;
                    while (n8 < doubleArray.length) {
                        int n9 = doubleArray[n8].intValue();
                        if (n9 < n2) {
                            this.chart.setDetachedSlice(n9, n, d);
                        }
                        ++n8;
                    }
                }
            }
        } else {
            super.setParameter(string, string2);
        }
    }

    protected void refresh() {
        this.chart.repaint();
    }

    public void init() {
        this.chart = (PieChart)this.theChart;
        super.init();
        String string = this.getParameterPrefix();
        this.initParameter("angle", this.getParameter(string + "angle"));
        this.initParameter("depth", this.getParameter(string + "depth"));
        this.initParameter("seriesLabelsOn", this.getParameter(string + "seriesLabelsOn"));
        this.initParameter("seriesLabelStyle", this.getParameter(string + "seriesLabelStyle"));
        this.initParameter("sampleLabelsOn", this.getParameter(string + "sampleLabelsOn"));
        this.initParameter("sampleLabelStyle", this.getParameter(string + "sampleLabelStyle"));
        this.initParameter("valueLabelsOn", this.getParameter(string + "valueLabelsOn"));
        this.initParameter("valueLabelStyle", this.getParameter(string + "valueLabelStyle"));
        this.initParameter("percentLabelsOn", this.getParameter(string + "percentLabelsOn"));
        this.initParameter("percentLabelStyle", this.getParameter(string + "percentLabelStyle"));
        this.initParameter("pieLabelsOn", this.getParameter(string + "pieLabelsOn"));
        this.initParameter("percentDecimalCount", this.getParameter(string + "percentDecimalCount"));
        this.initParameter("sliceSeperatorOn", this.getParameter(string + "sliceSeperatorOn"));
        this.initParameter("sliceSeperatorColor", this.getParameter(string + "sliceSeperatorColor"));
        this.initParameter("selectionStyle", this.getParameter(string + "selectionStyle"));
        this.initParameter("pieLabelFont", this.getParameter(string + "pieLabelFont"));
        this.initParameter("insideLabelFont", this.getParameter(string + "insideLabelFont"));
        this.initParameter("detachedDistance", this.getParameter(string + "detachedDistance"));
        this.initParameter("detachedSlices", this.getParameter(string + "detachedSlices"));
        int n = this.chart.getSeriesCount() == 1 ? 1 : this.chart.getSampleCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.getParameter(string + "detachedSlices_" + n2);
            if (string2 != null) {
                this.initParameter("detachedSlices_" + n2, string2);
            }
            ++n2;
        }
        String string3 = this.getParameter(string + "overlay");
        this.initParameter(string + "overlay", this.getParameter(string + "overlay"));
        int n3 = string3 != null ? 1 : 0;
        string3 = this.getParameter(string + "overlay" + n3);
        while (string3 != null) {
            this.initParameter(string + "overlay" + n3, this.getParameter(string + "overlay" + n3));
            string3 = this.getParameter(string + "overlay" + ++n3);
        }
        this.chart.setAutomaticRepaintOn(true);
    }
}

