/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;

public class PieChart
extends Chart {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    public static final int FLOATING = 0;
    public static final int INSIDE = 1;
    public static final int OUTSIDE = 2;
    private int pieAngle;
    private double pieDepth;
    private boolean seriesLabelsOn;
    private boolean sampleLabelsOn;
    private boolean percentLabelsOn;
    private boolean pieLabelsOn;
    private int percentDecimalCount;
    private int selectionStyle;
    private boolean sliceSeperatorOn;
    private Color sliceSeperatorColor;
    private double detachedDistance;
    private Hashtable detachedSlices;
    private int percentLabelStyle;
    private int valueLabelStyle;
    private int seriesLabelStyle;
    private int sampleLabelStyle;
    private int selectedSample;
    private int selectedSeries;
    private double[][] angles;
    private Rectangle[] pieBounds;
    private Point[] pieCenter;
    private int[] pieWidth;
    private static final int PAINT_2D = 0;
    private static final int PAINT_3D = 1;
    private static final int PAINT_ALL = 2;

    public int getSeriesLabelStyle() {
        return this.seriesLabelStyle;
    }

    private void paintPies(Graphics graphics, Rectangle rectangle) {
        int n = this.getSeriesCount();
        if (n == 1) {
            this.pieBounds[0] = rectangle;
            double[] dArray = this.getSampleValues(0);
            this.paintPie(graphics, rectangle, dArray, 0);
        } else {
            int n2 = this.getSampleCount();
            this.calculatePieBounds(rectangle, n2);
            int n3 = 0;
            while (n3 < n2) {
                double[] dArray = new double[n];
                int n4 = 0;
                while (n4 < n) {
                    dArray[n4] = this.getSampleValue(n4, n3);
                    ++n4;
                }
                this.paintPie(graphics, this.pieBounds[n3], dArray, n3);
                ++n3;
            }
        }
    }

    public boolean isPercentLabelsOn() {
        return this.percentLabelsOn;
    }

    public boolean isSampleLabelsOn() {
        return this.sampleLabelsOn;
    }

    public boolean isPieLabelsOn() {
        return this.pieLabelsOn;
    }

    private void paintPieSegment(Graphics graphics, Color color, double d, double d2, int n, int n2, int n3, int n4, boolean bl, double d3, int n5) {
        double d4;
        double d5;
        if (d3 > 0.0 && d2 < 360.0) {
            d5 = -d + d2 / 2.0;
            d4 = d5 * (Math.PI / 180);
            n3 += (int)Math.round(Math.cos(d4) * ((double)n * (d3 / 2.0)));
            n4 += (int)Math.round(Math.sin(d4) * ((double)n2 * (d3 / 2.0)));
        }
        if (n5 == 1 || n5 == 2) {
            d5 = d * (Math.PI / 180);
            d4 = (d - d2) * (Math.PI / 180);
            int n6 = (int)Math.round((double)n * this.pieDepth * ((double)this.pieAngle / 90.0));
            int n7 = n / 2;
            int n8 = n2 / 2;
            double d6 = Math.abs(d5 - d4) / (Math.PI * 2);
            double d7 = Math.PI * (double)Math.max(n, n2);
            double d8 = d6 * d7;
            double d9 = Math.abs(d5 - d4) / d8;
            if (d9 > 0.0) {
                double d10 = d5;
                double d11 = d5;
                graphics.setColor(color.darker().darker());
                while (d10 >= d4) {
                    int n9 = (int)Math.round(Math.cos(d10 -= d9) * (double)n7);
                    int n10 = (int)Math.round(Math.sin(d10) * (double)n8);
                    if (n10 < 0) {
                        graphics.drawLine(n3 + n9, n4 - n10, n3 + n9, n4 - n10 + n6 + 1);
                    } else {
                        graphics.drawLine(n3 + n9, n4 - n10 + 1, n3 + n9, n4 - n10 + n6 + 2);
                    }
                    d11 = d10;
                }
            }
        }
        if (n5 == 0 || n5 == 2) {
            int n11 = n3 - n / 2;
            int n12 = n4 - n2 / 2;
            graphics.setColor(color);
            graphics.fillArc(n11, n12, n + 1, n2 + 1, (int)Math.round(d), (int)Math.round(-d2));
            graphics.setColor(color.darker());
            graphics.drawArc(n11, n12, n, n2, (int)Math.round(d), (int)Math.round(-d2));
        }
        if (bl) {
            this.paintSelectionMarker(graphics, color, (int)Math.round(-d), (int)Math.round(-d2), n, n2, n3, n4, this.selectionStyle);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 505: {
                this.selectedSample = -1;
                this.selectedSeries = -1;
                this.repaint();
                break;
            }
            case 503: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (!this.seriesLabelsOn && !this.sampleLabelsOn && !this.isValueLabelsOn() && !this.percentLabelsOn) break;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                ChartSample chartSample = this.checkSelection(point);
                boolean bl = false;
                if (chartSample != null) {
                    bl = chartSample.getIndex() != this.selectedSample || chartSample.getSeries() != this.selectedSeries;
                    this.selectedSample = chartSample.getIndex();
                    this.selectedSeries = chartSample.getSeries();
                } else {
                    bl = this.selectedSample != -1 || this.selectedSeries != -1;
                    this.selectedSample = -1;
                    this.selectedSeries = -1;
                }
                if (!bl) break;
                this.repaint();
                break;
            }
        }
        super.processEvent(aWTEvent);
    }

    public void setDepth(double d) {
        this.pieDepth = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public float getDepth() {
        return (float)this.pieDepth;
    }

    public void setPercentLabelStyle(int n) {
        this.percentLabelStyle = 0;
        if (n == 1 || n == 2) {
            this.percentLabelStyle = n;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getPercentLabelStyle() {
        return this.percentLabelStyle;
    }

    public void setSampleLabelStyle(int n) {
        this.sampleLabelStyle = 0;
        if (n == 1 || n == 2) {
            this.sampleLabelStyle = n;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSampleLabelStyle() {
        return this.sampleLabelStyle;
    }

    public void setDetachedDistance(double d) {
        this.detachedDistance = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getDetachedDistance() {
        return this.detachedDistance;
    }

    public void setDetachedSlice(int n, int n2, double d) {
        Double d2 = new Double(n * 1000000 + n2);
        if (d != 0.0) {
            this.detachedSlices.put(d2, new Double(d));
        } else {
            this.detachedSlices.remove(d2);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getDetachedSlice(int n, int n2) {
        Double d = new Double(n * 1000000 + n2);
        Double d2 = (Double)this.detachedSlices.get(d);
        if (d2 != null) {
            return d2;
        }
        return 0.0;
    }

    public boolean isSliceSeperatorOn() {
        return this.sliceSeperatorOn;
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
    }

    public double getPercentValue(int n, int n2) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (n2 < 0 || n2 >= this.getSampleCount()) {
            throw new IllegalArgumentException("Invalid sample index: " + n2);
        }
        int n3 = this.getSeriesCount();
        if (n3 == 1) {
            int n4 = this.getSampleCount();
            double d = 0.0;
            int n5 = 0;
            while (n5 < n4) {
                double d2 = this.getSampleValue(0, n5);
                if (d2 > 0.0) {
                    d += d2;
                }
                ++n5;
            }
            double d3 = this.getSampleValue(0, n2);
            if (d3 >= 0.0) {
                return d3 / d * 100.0;
            }
        } else {
            double d = 0.0;
            int n6 = 0;
            while (n6 < n3) {
                double d4 = this.getSampleValue(n6, n2);
                if (d4 > 0.0) {
                    d += d4;
                }
                ++n6;
            }
            double d5 = this.getSampleValue(n, n2);
            if (d5 > 0.0) {
                return d5 / d * 100.0;
            }
        }
        return 0.0;
    }

    private void paintFloatingLabels(Graphics graphics, int n, int n2) {
        boolean bl;
        int n3 = this.getSeriesCount();
        int n4 = this.getSampleCount();
        if (graphics == null || n < 0 || n >= n3 || n2 < -1 || n2 >= n4) {
            return;
        }
        Font font = this.getFont("floatingLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl2 = this.isValueLabelsOn() && this.valueLabelStyle == 0;
        boolean bl3 = this.percentLabelsOn && this.percentLabelStyle == 0;
        boolean bl4 = this.sampleLabelsOn && this.sampleLabelStyle == 0;
        boolean bl5 = bl = this.seriesLabelsOn && n3 > 1 && this.seriesLabelStyle == 0;
        if (n2 >= 0) {
            String string = this.constructLabel(n, n2, bl, bl4, bl2, bl3);
            this.paintFloatingLabel(graphics, string, n, n2, font, fontMetrics);
        } else if (this.isFloatingOnLegendOn()) {
            int n5 = 0;
            while (n5 < n4) {
                String string = this.constructLabel(n, n5, bl, bl4, bl2, bl3);
                this.paintFloatingLabel(graphics, string, n, n5, font, fontMetrics);
                ++n5;
            }
        }
    }

    private void paintSelectionMarker(Graphics graphics, Color color, double d, double d2, int n, int n2, int n3, int n4, int n5) {
        if (n5 == 1) {
            double d3 = d - d2 / 2.0;
            double d4 = d3 * (Math.PI / 180);
            int n6 = n3 + (int)Math.round(Math.cos(d4) * ((double)n * 0.4));
            int n7 = n4 + (int)Math.round(Math.sin(d4) * ((double)n2 * 0.4));
            int n8 = Math.max(n / 16, 3);
            int n9 = Math.max(n2 / 16, 3);
            int n10 = n8 / 2;
            int n11 = n9 / 2;
            graphics.setColor(color.darker());
            graphics.fillOval(n6 - n10, n7 - n11, n8, n9);
            graphics.setColor(color.darker());
            graphics.drawArc(n6 - n10, n7 - n11, n8, n9, 45, 180);
            graphics.setColor(color.darker().darker());
            graphics.drawArc(n6 - n10 + 1, n7 - n11 + 1, n8 - 2, n9 - 2, 45, 180);
            graphics.setColor(color);
            graphics.drawArc(n6 - n10 + 1, n7 - n11 + 1, n8 - 2, n9 - 2, 45, -180);
            graphics.setColor(color.brighter());
            graphics.drawArc(n6 - n10, n7 - n11, n8, n9, 45, -180);
        } else if (n5 == 0) {
            double d5 = d - d2 / 2.0;
            double d6 = d5 * (Math.PI / 180);
            int n12 = (int)Math.round((double)n * 0.7);
            int n13 = (int)Math.round((double)n2 * 0.7);
            int n14 = n3 + (int)Math.round(Math.cos(d6) * ((double)n * 0.1));
            int n15 = n4 + (int)Math.round(Math.sin(d6) * ((double)n2 * 0.1));
            graphics.setColor(color.darker());
            graphics.fillArc(n14 -= (int)Math.round((double)n12 / 2.0), n15 -= (int)Math.round((double)n13 / 2.0), n12 + 1, n13 + 1, (int)(-Math.round(d)), (int)Math.round(d2));
        }
    }

    public void setPercentLabelsOn(boolean bl) {
        this.percentLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleLabelsOn(boolean bl) {
        this.sampleLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isSeriesLabelsOn() {
        return this.seriesLabelsOn;
    }

    public void setPieLabelsOn(boolean bl) {
        this.pieLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void paintPie(Graphics graphics, Rectangle rectangle, double[] dArray, int n) {
        double d;
        double d2;
        int n2;
        int n3;
        int n4;
        int n5;
        if (rectangle == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        int n6 = n5 = (n4 = Math.min(rectangle.width, rectangle.height));
        int n7 = rectangle.x + rectangle.width / 2;
        int n8 = rectangle.y + rectangle.height / 2;
        Font font = this.getFont("pieLabelFont");
        if (font != null) {
            graphics.setFont(font);
        } else {
            graphics.setFont(this.getFont());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl2 = this.is3DModeOn();
        if (bl2) {
            int n9 = (int)Math.round((double)n4 * ((double)this.pieAngle / 90.0));
            int n10 = (int)Math.round((double)n4 * this.pieDepth * ((double)this.pieAngle / 90.0));
            n6 = (n5 -= n9) + n10;
            n8 -= n10 / 2;
            double d3 = (double)rectangle.width / (double)n4;
            n3 = (int)Math.round((double)n4 * d3);
            n2 = (int)Math.round((double)n5 * d3);
            n10 = (int)Math.round((double)n3 * this.pieDepth * ((double)this.pieAngle / 90.0));
            n6 = n2 + n10;
            n8 = rectangle.y + rectangle.height / 2 - n10 / 2;
            if (n8 - n2 / 2 < rectangle.y) {
                d2 = (double)n2 / (double)n6;
                n6 = rectangle.height;
                n2 = (int)Math.round((double)n6 * d2);
                n10 = rectangle.height - n2;
                d3 = (double)n4 / (double)n5;
                n3 = (int)Math.round((double)n2 * d3);
                n8 = rectangle.y + rectangle.height / 2 - n10 / 2;
            }
            n4 = n3;
            n5 = n2;
        }
        if (this.pieLabelsOn) {
            Font font2 = this.getFont("pieLabelFont");
            String string = this.getSampleLabel(n);
            Dimension dimension = this.getLabelSize(string, font2);
            if (bl2) {
                int n11 = (int)Math.round((double)n4 * this.pieDepth * ((double)this.pieAngle / 90.0));
                n3 = n8 + n5 / 2 + dimension.height - fontMetrics.getDescent() + 2;
                if ((n3 += n11) > rectangle.y + rectangle.height) {
                    n2 = n3 - (rectangle.y + rectangle.height);
                    n5 -= n2;
                    n8 -= n2 / 2;
                }
            } else {
                n4 = n5 -= dimension.height;
                n8 -= dimension.height / 2;
            }
        }
        this.pieCenter[n].x = n7;
        this.pieCenter[n].y = n8;
        this.pieWidth[n] = n4;
        double d4 = 0.0;
        int n12 = 0;
        while (n12 < dArray.length) {
            if (dArray[n12] > 0.0) {
                d4 += dArray[n12];
            }
            ++n12;
        }
        double d5 = 90.0;
        n3 = this.getSeriesCount();
        n2 = 0;
        while (n2 < dArray.length) {
            d2 = dArray[n2] / d4 * 360.0;
            if (n3 == 1) {
                this.angles[0][n2] = d5;
            } else {
                this.angles[n2][n] = d5;
            }
            d5 -= d2;
            ++n2;
        }
        if (bl2) {
            n2 = n8;
            n8 += (int)Math.round((double)n4 * this.pieDepth * ((double)this.pieAngle / 90.0));
            int n13 = 0;
            while (n13 < dArray.length) {
                double d6;
                double d7 = d6 = -270.0;
                if (n3 == 1) {
                    if (n13 < this.angles[0].length - 1) {
                        d6 = this.angles[0][n13 + 1];
                    }
                    d7 = this.angles[0][n13];
                } else {
                    if (n13 < this.angles.length - 1) {
                        d6 = this.angles[n13 + 1][n];
                    }
                    d7 = this.angles[n13][n];
                }
                if (d7 != d6) {
                    boolean bl3 = false;
                    bl3 = n3 == 1 ? this.isSelected(0, n13) : this.isSelected(n13, n);
                    double d8 = 0.0;
                    d8 = bl3 && this.selectionStyle == 2 ? this.detachedDistance : (n3 == 1 ? this.getDetachedSlice(0, n13) : this.getDetachedSlice(n13, n));
                    bl3 = false;
                    this.paintPieSegment(graphics, this.getSampleColor(n13).darker(), d7, d7 - d6, n4, n5, n7, n8, bl3, d8, 0);
                }
                ++n13;
            }
            n8 = n2;
        }
        if (bl2) {
            double d9 = -270.0;
            int n14 = dArray.length - 1;
            while (d9 < -90.0 && n14 >= 0) {
                d = d9;
                d = n3 == 1 ? this.angles[0][n14] : this.angles[n14][n];
                boolean bl = false;
                bl = n3 == 1 ? this.isSelected(0, n14) : this.isSelected(n14, n);
                double d10 = 0.0;
                d10 = bl && this.selectionStyle == 2 ? this.detachedDistance : (n3 == 1 ? this.getDetachedSlice(0, n14) : this.getDetachedSlice(n14, n));
                this.paintPieSegment(graphics, this.getSampleColor(n14), d, d - d9, n4, n5, n7, n8, bl, d10, 1);
                --n14;
                d9 = d;
            }
            n14 = 0;
            while (n14 < dArray.length) {
                d = d9 = -270.0;
                if (n3 == 1) {
                    if (n14 < this.angles[0].length - 1) {
                        d9 = this.angles[0][n14 + 1];
                    }
                    d = this.angles[0][n14];
                } else {
                    if (n14 < this.angles.length - 1) {
                        d9 = this.angles[n14 + 1][n];
                    }
                    d = this.angles[n14][n];
                }
                if (d >= -90.0) {
                    boolean color = false;
                    color = n3 == 1 ? this.isSelected(0, n14) : this.isSelected(n14, n);
                    double d11 = 0.0;
                    d11 = color && this.selectionStyle == 2 ? this.detachedDistance : (n3 == 1 ? this.getDetachedSlice(0, n14) : this.getDetachedSlice(n14, n));
                    this.paintPieSegment(graphics, this.getSampleColor(n14), d, d - d9, n4, n5, n7, n8, color, d11, 1);
                }
                ++n14;
            }
        }
        int n15 = 0;
        while (n15 < dArray.length) {
            double d12;
            d = d12 = -270.0;
            if (n3 == 1) {
                if (n15 < this.angles[0].length - 1) {
                    d12 = this.angles[0][n15 + 1];
                }
                d = this.angles[0][n15];
            } else {
                if (n15 < this.angles.length - 1) {
                    d12 = this.angles[n15 + 1][n];
                }
                d = this.angles[n15][n];
            }
            if (d != d12) {
                boolean bl = false;
                bl = n3 == 1 ? this.isSelected(0, n15) : this.isSelected(n15, n);
                double d13 = 0.0;
                d13 = bl && this.selectionStyle == 2 ? this.detachedDistance : (n3 == 1 ? this.getDetachedSlice(0, n15) : this.getDetachedSlice(n15, n));
                this.paintPieSegment(graphics, this.getSampleColor(n15), d, d - d12, n4, n5, n7, n8, bl, d13, 0);
            }
            ++n15;
        }
        if (this.sliceSeperatorOn) {
            n15 = 0;
            while (n15 < dArray.length) {
                double d14 = 0.0;
                d14 = n3 == 1 ? this.angles[0][n15] : this.angles[n15][n];
                d = -d14 * (Math.PI / 180);
                int n9 = n7 + (int)Math.round(Math.cos(d) * ((double)n4 * 0.5));
                int n16 = n8 + (int)Math.round(Math.sin(d) * ((double)n5 * 0.5));
                if (this.sliceSeperatorColor != null) {
                    graphics.setColor(this.sliceSeperatorColor);
                } else {
                    graphics.setColor(this.getSampleColor(n15).darker());
                }
                graphics.drawLine(n7, n8, n9, n16);
                ++n15;
            }
        }
        if (this.pieLabelsOn) {
            String string = n3 == 1 ? this.getSeriesLabel(n) : this.getSampleLabel(n);
            Font font3 = this.getFont("pieLabelFont");
            if (string != null && string.trim().length() > 0) {
                Color color;
                Dimension dimension = this.getLabelSize(string, font3);
                int n17 = n7 - dimension.width / 2;
                int n18 = n8 + n5 / 2 + fontMetrics.getHeight() - fontMetrics.getDescent() + 2;
                if (bl2) {
                    n18 += (int)Math.round((double)n4 * this.pieDepth * ((double)this.pieAngle / 90.0));
                }
                graphics.setColor((color = this.getSampleLabelColor(n)) != null ? color : this.getForeground());
                this.paintLabel(graphics, string, n17, n18, dimension, 0, 0);
            }
        }
    }

    private String constructLabel(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string;
        int n3 = this.getSeriesCount();
        int n4 = this.getSampleCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n4) {
            return "";
        }
        String string2 = this.getLabel("valueLabelPrefix_" + n);
        if (string2 == null) {
            string2 = this.getLabel("valueLabelPrefix");
        }
        if ((string = this.getLabel("valueLabelPostfix_" + n)) == null) {
            string = this.getLabel("valueLabelPostfix");
        }
        String string3 = bl ? this.getSeriesLabel(n) : null;
        String string4 = bl2 ? this.getSampleLabel(n2) : null;
        String string5 = bl3 ? this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n)) : null;
        string5 = string2 != null && string5 != null ? string2 + string5 : string5;
        string5 = string != null && string5 != null ? string5 + string : string5;
        String string6 = bl4 ? this.formatNumber(this.getPercentValue(n, n2), this.getPercentDecimalCount()) + "%" : null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 != null) {
            stringBuffer.append(string3);
            if (!(string3.endsWith("\n") || string4 == null && string5 == null && string6 == null)) {
                stringBuffer.append(" : ");
            }
        }
        if (string4 != null) {
            stringBuffer.append(string4);
            if (!(string4.endsWith("\n") || string5 == null && string6 == null)) {
                stringBuffer.append(" : ");
            }
        }
        if (string5 != null) {
            stringBuffer.append(string5);
            if (!string5.endsWith("\n") && string6 != null) {
                stringBuffer.append(" : ");
            }
        }
        if (string6 != null) {
            stringBuffer.append(string6);
        }
        return stringBuffer.toString();
    }

    private void paintStaticLabels(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = this.getSeriesCount();
        boolean bl = this.percentLabelsOn && this.percentLabelStyle != 0;
        bl |= this.isValueLabelsOn() && this.valueLabelStyle != 0;
        bl |= this.sampleLabelsOn && this.sampleLabelStyle != 0;
        if (!(bl |= this.seriesLabelsOn && n > 1 && this.seriesLabelStyle != 0)) {
            return;
        }
        Font font = this.getFont("insideLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = this.getSampleCount();
        boolean bl2 = this.percentLabelsOn && this.percentLabelStyle != 0;
        boolean bl3 = this.isValueLabelsOn() && this.valueLabelStyle != 0;
        boolean bl4 = this.seriesLabelsOn && n > 1 && this.seriesLabelStyle != 0;
        boolean bl5 = this.sampleLabelsOn && this.sampleLabelStyle != 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                String string = this.constructLabel(n3, n4, bl4, bl5, bl3, bl2);
                this.paintInsideLabel(graphics, string, n3, n4, font, fontMetrics);
                ++n4;
            }
            ++n3;
        }
    }

    public void setValueLabelStyle(int n) {
        this.valueLabelStyle = 0;
        if (n == 1 || n == 2) {
            this.valueLabelStyle = n;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public void setSliceSeperatorOn(boolean bl) {
        this.sliceSeperatorOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public ChartSample checkSelection(Point point) {
        ChartSample chartSample = super.checkSelection(point);
        if (chartSample == null) {
            int n = -1;
            Rectangle rectangle = null;
            int n2 = 0;
            while (n2 < this.pieBounds.length) {
                rectangle = this.pieBounds[n2];
                if (rectangle != null && rectangle.contains(point)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n >= 0) {
                double d;
                int n3;
                double d2;
                double d3;
                point.x -= this.pieCenter[n].x;
                point.y -= this.pieCenter[n].y;
                if (this.is3DModeOn()) {
                    n2 = this.pieWidth[n];
                    int n4 = (int)Math.round((double)n2 * ((double)this.pieAngle / 90.0));
                    d3 = (double)n2 / (double)(n2 - n4);
                    point.y = (int)Math.round((double)point.y * d3);
                }
                if ((d3 = -((d2 = Math.atan2(point.y, point.x)) * 57.29577951308232)) > 90.0 && d3 <= 180.0) {
                    d3 = -360.0 + d3;
                }
                int n5 = this.getSeriesCount();
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                if (n5 == 1) {
                    n3 = this.getSampleCount();
                    int n6 = 0;
                    while (n6 < n3) {
                        if (n6 < n3 - 1) {
                            d5 = Math.min(this.angles[0][n6], this.angles[0][n6 + 1]);
                            d6 = Math.max(this.angles[0][n6], this.angles[0][n6 + 1]);
                        } else {
                            d5 = Math.min(this.angles[0][n6], -270.0);
                            d6 = Math.max(this.angles[0][n6], -270.0);
                        }
                        if (d3 >= d5 && d3 < d6) {
                            chartSample = this.getSample(0, n6);
                            d4 = (d5 + d6) / 2.0;
                            break;
                        }
                        ++n6;
                    }
                } else {
                    n3 = 0;
                    while (n3 < n5) {
                        if (n3 < n5 - 1) {
                            d5 = Math.min(this.angles[n3][n], this.angles[n3 + 1][n]);
                            d6 = Math.max(this.angles[n3][n], this.angles[n3 + 1][n]);
                        } else {
                            d5 = Math.min(this.angles[n3][n], -270.0);
                            d6 = Math.max(this.angles[n3][n], -270.0);
                        }
                        if (d3 >= d5 && d3 < d6) {
                            chartSample = this.getSample(n3, n);
                            d4 = (d5 + d6) / 2.0;
                            break;
                        }
                        ++n3;
                    }
                }
                if (chartSample != null && chartSample.isSelected() && this.selectionStyle == 2) {
                    double d7 = d4 * (Math.PI / 180);
                    point.x = (int)((double)point.x - Math.cos(d7) * (double)this.pieWidth[n] * 0.5 * this.detachedDistance);
                    point.y = (int)((double)point.y + Math.sin(d7) * (double)this.pieWidth[n] * 0.5 * this.detachedDistance);
                    d2 = Math.atan2(point.y, point.x);
                    d3 = -(d2 * 57.29577951308232);
                    if (d3 > 90.0 && d3 <= 180.0) {
                        d3 = -360.0 + d3;
                    }
                    if (d3 < d5 || d3 >= d6) {
                        return null;
                    }
                }
                if ((d = Math.sqrt(point.x * point.x + point.y * point.y)) > (double)(this.pieWidth[n] / 2)) {
                    return null;
                }
            }
        }
        return chartSample;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.paintPies(graphics, rectangle);
        this.paintStaticLabels(graphics);
    }

    public void reset() {
        super.reset();
        this.pieAngle = 20;
        this.pieDepth = 0.4f;
        this.sampleLabelsOn = false;
        this.percentLabelsOn = false;
        this.pieLabelsOn = false;
        this.percentDecimalCount = 0;
        this.selectionStyle = 0;
        this.sliceSeperatorOn = true;
        this.sliceSeperatorColor = null;
        this.detachedDistance = 0.1;
        if (this.detachedSlices != null) {
            this.detachedSlices.clear();
        }
        this.percentLabelStyle = 0;
        this.valueLabelStyle = 0;
        this.sampleLabelStyle = 0;
        this.seriesLabelStyle = 0;
        this.selectedSample = -1;
        this.selectedSeries = -1;
    }

    public PieChart() {
        this(1);
    }

    public PieChart(int n) {
        this(1, n);
    }

    public PieChart(int n, int n2) {
        super(n, n2);
        this.chartType = "pie";
        this.angles = new double[n][n2];
        this.detachedSlices = new Hashtable();
        this.pieBounds = new Rectangle[n == 1 ? 1 : n2];
        this.pieCenter = new Point[this.pieBounds.length];
        this.pieWidth = new int[this.pieBounds.length];
        int n3 = 0;
        while (n3 < this.pieBounds.length) {
            this.pieBounds[n3] = new Rectangle();
            this.pieCenter[n3] = new Point();
            ++n3;
        }
    }

    public void setPercentDecimalCount(int n) {
        this.percentDecimalCount = n;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getPercentDecimalCount() {
        return this.percentDecimalCount;
    }

    public void setSliceSeperatorColor(Color color) {
        this.sliceSeperatorColor = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getSliceSeperatorColor() {
        return this.sliceSeperatorColor;
    }

    public void setFont(String string, Font font) {
        super.setFont(string, font);
    }

    public void setAngle(int n) {
        this.pieAngle = n;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getAngle() {
        return this.pieAngle;
    }

    public void setSelectionStyle(int n) {
        this.selectionStyle = n;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSelectionStyle() {
        return this.selectionStyle;
    }

    public void render(Graphics graphics) {
        this.render(graphics, !this.isServletModeOn());
    }

    public void setSeriesLabelsOn(boolean bl) {
        this.seriesLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        int n = this.getSeriesCount();
        int n2 = this.getSampleCount();
        this.angles = new double[n][n2];
        this.pieBounds = new Rectangle[n == 1 ? 1 : n2];
        this.pieCenter = new Point[this.pieBounds.length];
        this.pieWidth = new int[this.pieBounds.length];
        int n3 = 0;
        while (n3 < this.pieBounds.length) {
            this.pieBounds[n3] = new Rectangle();
            this.pieCenter[n3] = new Point();
            ++n3;
        }
    }

    void render(Graphics graphics, boolean bl) {
        Rectangle rectangle = this.getGraphBounds();
        int n = 0;
        while (n < this.overlayCharts.size()) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n);
            if (chart != null) {
                chart.calculateChartData(rectangle, rectangle);
            }
            ++n;
        }
        Dimension dimension = this.getSize();
        if (bl && this.offscreen == null) {
            this.offscreen = this.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            this.hasChanged = true;
        }
        if (!bl || this.hasChanged || this.offscreen == null) {
            if (!this.externalGraphicsOn && !bl) {
                this.og = graphics;
            } else if (bl || this.externalGraphicsOn) {
                if (!this.externalGraphicsOn && this.offscreen != null) {
                    this.og = this.offscreen.getGraphics();
                }
                this.og.setColor(this.getBackground());
                this.og.fillRect(0, 0, dimension.width, dimension.height);
            }
            this.paintTitle(this.og, dimension);
            this.renderData(this.og, rectangle, rectangle);
            int n2 = 0;
            while (n2 < this.overlayCharts.size()) {
                Chart chart = (Chart)this.overlayCharts.elementAt(n2);
                if (chart != null) {
                    chart.renderData(this.og, rectangle, rectangle);
                }
                ++n2;
            }
            if (this.isLegendOn()) {
                this.paintLegend(this.og, rectangle, this.getLegendLabels());
            }
            if (!this.externalGraphicsOn && this.og != graphics) {
                this.og.dispose();
            }
            this.hasChanged = false;
        }
        if ((bl || this.externalGraphicsOn) && this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
        if (this.sampleLabelsOn && this.sampleLabelStyle == 0 || this.seriesLabelsOn && this.seriesLabelStyle == 0 || this.isValueLabelsOn() && this.valueLabelStyle == 0 || this.percentLabelsOn && this.percentLabelStyle == 0) {
            this.paintFloatingLabels(graphics, this.selectedSeries, this.selectedSample);
        }
    }

    public Rectangle getGraphBounds() {
        if (!this.hasChanged && this.currentBounds != null) {
            return this.currentBounds;
        }
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Insets insets = this.getGraphInsets();
        if (insets != null) {
            int n;
            Dimension dimension = this.getSize();
            if (insets.top != -1) {
                n = rectangle.y + rectangle.height;
                rectangle.y = insets.top;
                rectangle.height = n - rectangle.y;
            }
            if (insets.left != -1) {
                n = rectangle.x + rectangle.width;
                rectangle.x = insets.left;
                rectangle.width = n - rectangle.x;
            }
            if (insets.bottom != -1) {
                rectangle.height = dimension.height - insets.bottom - rectangle.y;
            }
            if (insets.right != -1) {
                rectangle.width = dimension.width - insets.right - rectangle.x;
            }
        }
        this.currentBounds = rectangle;
        return rectangle;
    }

    private void calculatePieBounds(Rectangle rectangle, int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = n;
        int n6 = 1;
        int n7 = 1;
        while (n7 <= n) {
            n3 = 1;
            while (n3 <= n) {
                if (n7 * n3 >= n && (n2 = Math.min(rectangle.width / n7, rectangle.height / n3)) > n4) {
                    n4 = n2;
                    n5 = n7;
                    n6 = n3;
                }
                ++n3;
            }
            ++n7;
        }
        n7 = 0;
        n3 = 0;
        while (n3 < n6) {
            n2 = 0;
            while (n2 < n5) {
                if (n7 < n) {
                    Rectangle rectangle2 = this.pieBounds[n7];
                    rectangle2.width = rectangle.width / n5;
                    rectangle2.height = rectangle.height / n6;
                    rectangle2.x = rectangle.x + rectangle2.width * n2;
                    rectangle2.y = rectangle.y + rectangle2.height * n3;
                    rectangle2.width -= 10;
                    rectangle2.height -= 10;
                    rectangle2.x += 5;
                    rectangle2.y += 5;
                    ++n7;
                }
                ++n2;
            }
            ++n3;
        }
    }

    private void paintFloatingLabel(Graphics graphics, String string, int n, int n2, Font font, FontMetrics fontMetrics) {
        int n3 = this.getSeriesCount();
        Point point = this.pieCenter[n3 > 1 ? n2 : 0];
        if (point == null) {
            return;
        }
        double d = 0.0;
        d = n3 == 1 ? (n2 < this.angles[0].length - 1 ? -((this.angles[0][n2] + this.angles[0][n2 + 1]) / 2.0) : -((this.angles[0][n2] - 270.0) / 2.0)) : (n < this.angles.length - 1 ? -((this.angles[n][n2] + this.angles[n + 1][n2]) / 2.0) : -((this.angles[n][n2] - 270.0) / 2.0));
        double d2 = 1.0;
        int n4 = this.pieWidth[n3 == 1 ? 0 : n2];
        if (this.is3DModeOn()) {
            int n5 = (int)Math.round((double)n4 * ((double)this.pieAngle / 90.0));
            d2 = (double)(n4 - n5) / (double)n4;
        }
        double d3 = d * (Math.PI / 180);
        int n6 = point.x + (int)Math.round(Math.cos(d3) * (double)n4 * 0.3);
        int n7 = point.y + (int)Math.round(Math.sin(d3) * (double)n4 * 0.3 * d2);
        Dimension dimension = this.getLabelSize(string, font);
        n6 -= dimension.width / 2;
        n7 -= dimension.height / 2 - fontMetrics.getAscent();
        Dimension dimension2 = this.getSize();
        n6 = Math.max(n6, 3);
        n6 = Math.min(n6, dimension2.width - dimension.width - 3);
        n7 = Math.max(n7, fontMetrics.getAscent());
        n7 = Math.min(n7, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n6 - 2, n7 - n8 + n9 * 2 - 3, dimension.width + 5, dimension.height + 2);
        graphics.setColor(this.getSampleColor(this.getSeriesCount() == 1 ? n2 : n).darker());
        graphics.drawRect(n6 - 3, n7 - n8 + n9 * 2 - 4, dimension.width + 5, dimension.height + 3);
        graphics.setColor(Color.black);
        this.paintLabel(graphics, string, n6, n7, dimension, 0, 0);
    }

    private void paintInsideLabel(Graphics graphics, String string, int n, int n2, Font font, FontMetrics fontMetrics) {
        double d;
        int n3 = this.getSeriesCount();
        Point point = this.pieCenter[n3 > 1 ? n2 : 0];
        if (point == null) {
            return;
        }
        double d2 = 0.0;
        double d3 = d = -270.0;
        if (n3 == 1) {
            if (n2 < this.angles[0].length - 1) {
                d = this.angles[0][n2 + 1];
            }
            d3 = this.angles[0][n2];
        } else {
            if (n < this.angles.length - 1) {
                d = this.angles[n + 1][n2];
            }
            d3 = this.angles[n][n2];
        }
        d2 = -((d3 + d) / 2.0);
        double d4 = 1.0;
        int n4 = this.pieWidth[n3 == 1 ? 0 : n2];
        double d5 = 0.0;
        if (this.isSelected(n, n2) && d3 - d < 360.0 && this.selectionStyle == 2) {
            d5 = (double)n4 * this.detachedDistance / 2.0;
        }
        if (this.is3DModeOn()) {
            int n5 = (int)Math.round((double)n4 * ((double)this.pieAngle / 90.0));
            d4 = (double)(n4 - n5) / (double)n4;
        }
        double d6 = d2 * (Math.PI / 180);
        int n6 = point.x + (int)Math.round(Math.cos(d6) * (double)n4 * 0.35 + Math.cos(d6) * d5);
        int n7 = point.y + (int)Math.round((Math.sin(d6) * (double)n4 * 0.35 + Math.sin(d6) * d5) * d4);
        Dimension dimension = this.getLabelSize(string, font);
        n6 -= dimension.width / 2;
        n7 -= dimension.height / 2 - fontMetrics.getAscent();
        Color color = this.getSampleColor(n3 == 1 ? n2 : n);
        if ((color.getRed() + color.getGreen() + color.getBlue()) / 3 > 110) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.white);
        }
        this.paintLabel(graphics, string, n6, n7, dimension, 0, 0);
    }

    public void setSeriesLabelStyle(int n) {
        this.seriesLabelStyle = 0;
        if (n == 1 || n == 2) {
            this.seriesLabelStyle = n;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }
}

