/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;
import com.objectplanet.chart.LineChart;
import java.util.StringTokenizer;

public class LineChartApplet
extends ChartApplet {
    public LineChart chart;

    private int[] getStyleValues(String string) {
        int[] nArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (n < nArray.length) {
                String string2 = stringTokenizer.nextToken().trim().toLowerCase();
                if (string2.equals("circle")) {
                    nArray[n] = 0;
                } else if (string2.equals("circle_opaque")) {
                    nArray[n] = 1;
                } else if (string2.equals("circle_filled")) {
                    nArray[n] = 2;
                } else if (string2.equals("square")) {
                    nArray[n] = 3;
                } else if (string2.equals("square_opaque")) {
                    nArray[n] = 4;
                } else if (string2.equals("square_filled")) {
                    nArray[n] = 5;
                } else if (string2.equals("diamond")) {
                    nArray[n] = 6;
                } else if (string2.equals("diamond_opaque")) {
                    nArray[n] = 7;
                } else if (string2.equals("diamond_filled")) {
                    nArray[n] = 8;
                } else {
                    nArray[n] = 0;
                    System.out.println("Invalid sampleHighlightStyle: " + string2);
                }
                ++n;
            }
        }
        return nArray;
    }

    protected Chart createChart(String string) {
        if (string == null || string.equals("")) {
            string = "com.objectplanet.chart.LineChart";
        }
        try {
            Class<?> clazz = Class.forName(string);
            LineChart lineChart = (LineChart)clazz.newInstance();
            lineChart.setRange(0, 100.0);
            return lineChart;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: " + string);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Could not create an instance of the class: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Illegal access, could not create an instance of class: " + string);
        }
        catch (ClassCastException classCastException) {
            System.out.println("The class " + string + ", does not extend from com.objectplanet.chart.LineChart");
        }
        return new LineChart(1, 1, 100.0);
    }

    private void initParameter(String string, String string2) {
        if (string2 != null) {
            this.setParameter(string, string2);
        }
    }

    public void setParameter(String string, String string2) {
        if (string == null) {
            return;
        }
        if ((string = string.toLowerCase()).equals("valuelabelstyle")) {
            this.chart.setValueLabelStyle(0);
            if (string2 != null) {
                if (string2.equals("point")) {
                    this.chart.setValueLabelStyle(1);
                } else if (string2.equals("floating")) {
                    this.chart.setValueLabelStyle(2);
                }
            }
        } else if (string.equals("samplelabelson")) {
            this.chart.setSampleLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("samplelabelstyle")) {
            this.chart.setSampleLabelStyle(3);
            if (string2 != null && string2.trim().toLowerCase().equals("floating")) {
                this.chart.setSampleLabelStyle(2);
            }
        } else if (string.equals("serieslabelson")) {
            this.chart.setSeriesLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("autolabelspacingon")) {
            this.chart.setAutoLabelSpacingOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("serieslineoff")) {
            if (string2 != null && string2.trim().toLowerCase().equals("true")) {
                this.chart.setSeriesLineOn(false);
            } else if (string2 != null && string2.trim().length() > 0) {
                this.chart.setSeriesLineOn(true);
                Double[] doubleArray = ChartApplet.getDoubleValues(string2);
                int n = this.chart.getSeriesCount();
                int n2 = 0;
                while (n2 < doubleArray.length) {
                    if (doubleArray[n2] != null && doubleArray[n2].intValue() >= 0 && doubleArray[n2].intValue() < n) {
                        this.chart.setSeriesLineOn(doubleArray[n2].intValue(), false);
                    }
                    ++n2;
                }
            } else {
                this.chart.setSeriesLineOn(true);
            }
        } else if (string.equals("connectedlineson")) {
            this.chart.setConnectedLinesOn(-1, false);
            if (string2 != null && string2.trim().toLowerCase().equals("true")) {
                this.chart.setConnectedLinesOn(-1, true);
            } else if (string2 != null && string2.trim().length() > 0) {
                Double[] doubleArray = ChartApplet.getDoubleValues(string2);
                int n = this.chart.getSeriesCount();
                int n3 = 0;
                while (n3 < doubleArray.length) {
                    if (doubleArray[n3] != null && doubleArray[n3].intValue() >= 0 && doubleArray[n3].intValue() < n) {
                        this.chart.setConnectedLinesOn(doubleArray[n3].intValue(), true);
                    }
                    ++n3;
                }
            }
        } else if (string.equals("linewidth")) {
            if (string2 != null && string2.trim().length() > 0) {
                Double[] doubleArray = ChartApplet.getDoubleValues(string2);
                if (doubleArray.length == 1 && this.chart.getSeriesCount() > 1) {
                    this.chart.setLineWidth(-1, doubleArray[0].intValue());
                } else {
                    int n = 0;
                    while (n < doubleArray.length) {
                        this.chart.setLineWidth(n, doubleArray[n].intValue());
                        ++n;
                    }
                }
            } else {
                this.chart.setLineWidth(-1, 2);
            }
        } else if (string.equals("stackedon")) {
            this.chart.setStackedOn(string2 != null && string2.toLowerCase().equals("true"));
        } else if (string.equals("samplehighlighton")) {
            boolean[] blArray = this.getBooleanValues(string2);
            int n = this.chart.getSeriesCount();
            int n4 = 0;
            while (n4 < n) {
                if (blArray != null && blArray.length > 0) {
                    this.chart.setSampleHighlightOn(n4, blArray[n4 % blArray.length]);
                } else {
                    this.chart.setSampleHighlightOn(n4, false);
                }
                ++n4;
            }
        } else if (string.equals("samplehighlightstyle")) {
            int[] nArray = this.getStyleValues(string2);
            int n = this.chart.getSeriesCount();
            int n5 = 0;
            while (n5 < n) {
                int n6 = this.chart.getSampleHighlightSize(n5);
                int n7 = 0;
                if (nArray != null && nArray.length > 0) {
                    n7 = nArray[n5 % nArray.length];
                }
                this.chart.setSampleHighlightStyle(n5, n7, n6);
                ++n5;
            }
        } else if (string.equals("samplehighlightsize")) {
            int n = this.chart.getSeriesCount();
            Double[] doubleArray = ChartApplet.getDoubleValues(string2);
            int n8 = 0;
            while (n8 < n) {
                int n9 = this.chart.getSampleHighlightStyle(n8);
                int n10 = 6;
                if (doubleArray != null && doubleArray[n8 % doubleArray.length] != null) {
                    n10 = doubleArray[n8 % doubleArray.length].intValue();
                }
                this.chart.setSampleHighlightStyle(n8, n9, n10);
                ++n8;
            }
        } else {
            super.setParameter(string, string2);
        }
    }

    protected void refresh() {
        this.chart.repaint();
    }

    private boolean[] getBooleanValues(String string) {
        boolean[] blArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            blArray = new boolean[stringTokenizer.countTokens()];
            int n = 0;
            while (n < blArray.length) {
                blArray[n] = stringTokenizer.nextToken().trim().toLowerCase().equals("true");
                ++n;
            }
        }
        return blArray;
    }

    public void init() {
        this.chart = (LineChart)this.theChart;
        super.init();
        String string = this.getParameterPrefix();
        this.initParameter("valueLabelFont", this.getParameter(string + "valueLabelFont"));
        this.initParameter("valueLabelStyle", this.getParameter(string + "valueLabelStyle"));
        this.initParameter("sampleDecimalCount", this.getParameter(string + "sampleDecimalCount"));
        this.initParameter("sampleLabelsOn", this.getParameter(string + "sampleLabelsOn"));
        this.initParameter("sampleLabelStyle", this.getParameter(string + "sampleLabelStyle"));
        this.initParameter("sampleLabelFont", this.getParameter(string + "sampleLabelFont"));
        this.initParameter("seriesLabelsOn", this.getParameter(string + "seriesLabelsOn"));
        this.initParameter("seriesLabels", this.getParameter(string + "seriesLabels"));
        this.initParameter("autoLabelSpacingOn", this.getParameter(string + "autoLabelSpacingOn"));
        this.initParameter("seriesLineOff", this.getParameter(string + "seriesLineOff"));
        this.initParameter("connectedLinesOn", this.getParameter(string + "connectedLinesOn"));
        this.initParameter("lineWidth", this.getParameter(string + "lineWidth"));
        this.initParameter("stackedOn", this.getParameter(string + "stackedOn"));
        this.initParameter("sampleHighlightOn", this.getParameter(string + "sampleHighlightOn"));
        this.initParameter("sampleHighlightStyle", this.getParameter(string + "sampleHighlightStyle"));
        this.initParameter("sampleHighlightSize", this.getParameter(string + "sampleHighlightSize"));
        this.initParameter("sampleScrollerOn", this.getParameter(string + "sampleScrollerOn"));
        String string2 = this.getParameter(string + "overlay");
        this.initParameter(string + "overlay", this.getParameter(string + "overlay"));
        int n = string2 != null ? 1 : 0;
        string2 = this.getParameter(string + "overlay" + n);
        while (string2 != null) {
            this.initParameter(string + "overlay" + n, this.getParameter(string + "overlay" + n));
            string2 = this.getParameter(string + "overlay" + ++n);
        }
        this.setRangeParameters(true);
        int n2 = 0;
        while (n2 < this.overlayChartApplets.size()) {
            ChartApplet chartApplet = (ChartApplet)this.overlayChartApplets.elementAt(n2);
            if (chartApplet != null) {
                chartApplet.setRangeParameters(false);
            }
            ++n2;
        }
        this.chart.setAutomaticRepaintOn(true);
    }
}

