/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;

public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int VALUE_LABELS_OUTSIDE_POINT = 0;
    public static final int VALUE_LABELS_AT_POINT = 1;
    public static final int FLOATING = 2;
    public static final int BELOW = 3;
    private int valueLabelStyle;
    private int sampleLabelStyle;
    private boolean seriesLabelsOn;
    private boolean autoLabelSpacingOn;
    private int[] lineWidth;
    private boolean stackedOn;
    private boolean[][] sampleHighlightOn;
    private int[] sampleHighlightStyle;
    private int[] sampleHighlightSize;
    private boolean[] seriesLinesOn;
    private boolean[] connectedLinesOn;
    private String[] highlightImages;
    private Point[][] samplePosition;
    private int selectedSeries;
    private int selectedSample;
    private Point mousePosition;

    public void setSampleHighlightStyle(int n, int n2, int n3) {
        this.sampleHighlightSize[n] = Math.max(0, n3);
        this.sampleHighlightStyle[n] = n2;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int n) {
        try {
            return this.sampleHighlightStyle[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public boolean isSampleLabelsOn() {
        return this.sampleLabelsOn;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        this.autoLabelSpacingOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setStackedOn(boolean bl) {
        this.stackedOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setConnectedLinesOn(int n, boolean bl) {
        if (n >= 0 && n < this.connectedLinesOn.length) {
            this.connectedLinesOn[n] = bl;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.connectedLinesOn.length) {
                this.connectedLinesOn[n2] = bl;
                ++n2;
            }
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    protected void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 505: {
                this.selectedSample = -1;
                this.selectedSeries = -1;
                this.repaint();
                break;
            }
            case 503: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                boolean bl = this.isValueLabelsOn() && this.valueLabelStyle == 2;
                bl |= this.sampleLabelsOn && this.sampleLabelStyle == 2;
                if (!(bl |= this.seriesLabelsOn)) break;
                this.mousePosition.x = mouseEvent.getX();
                this.mousePosition.y = mouseEvent.getY();
                ChartSample chartSample = super.checkSelection(this.mousePosition);
                if (chartSample != null) {
                    this.mousePosition.x = -1;
                    this.mousePosition.y = -1;
                } else {
                    chartSample = this.checkSelection(this.mousePosition);
                }
                if (chartSample != null) {
                    if (chartSample.getIndex() == this.selectedSample && chartSample.getSeries() == this.selectedSeries) break;
                    this.selectedSample = chartSample.getIndex();
                    this.selectedSeries = chartSample.getSeries();
                    this.repaint();
                    break;
                }
                boolean bl2 = this.selectedSample != -1 || this.selectedSeries != -1;
                this.selectedSample = -1;
                this.selectedSeries = -1;
                if (!bl2) break;
                this.repaint();
                break;
            }
        }
        super.processEvent(aWTEvent);
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        return this.getSeriesLabels();
    }

    private void paintSampleLabels(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        String[] stringArray = this.getSampleLabels();
        if (stringArray == null) {
            return;
        }
        Font font = this.getFont("sampleLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getSampleCount();
        double d = rectangle2.width;
        if (n > 1) {
            d = (float)rectangle2.width / (float)(n - 1);
        }
        int n2 = rectangle2.y + rectangle2.height;
        double d2 = rectangle2.x;
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        if (this.is3DModeOn()) {
            n2 -= this.depth3dPoint.y;
            d2 -= (double)this.depth3dPoint.x;
            n3 -= this.depth3dPoint.x;
            n4 -= this.depth3dPoint.x;
        }
        if (this.sampleScrollerOn) {
            n2 += 10;
        }
        Color color = this.getChartForeground();
        int n5 = this.getLabelAngle("sampleLabelAngle");
        double d3 = 0.0;
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (stringArray[n6] != null && stringArray[n6].length() > 0 && d2 >= (double)n3 && d2 <= (double)(n4 + 1)) {
                Color color2 = this.getSampleLabelColor(n6);
                if (color2 == null) {
                    color2 = this.getForeground();
                }
                String string = stringArray[n6];
                Dimension dimension = this.getLabelSize(string, font);
                Dimension dimension2 = this.getAngledLabelSize(dimension, n5);
                int n7 = n2 + 8;
                if (n5 % 180 == 0) {
                    n7 += fontMetrics.getMaxAscent() - 4;
                }
                double d4 = 0.0;
                d4 = n5 % 180 == 0 ? d2 - (double)(dimension2.width / 2) : (n5 % 360 > 90 && n5 % 360 < 180 || n5 % 360 > 270 ? d2 - (double)dimension2.width + (double)(fontMetrics.getAscent() / 2) : d2 - (double)(fontMetrics.getAscent() / 2));
                graphics.setColor(color);
                if (this.autoLabelSpacingOn) {
                    if (string != null && string.trim().length() > 0 && (d4 > d3 || n6 == 0)) {
                        graphics.drawLine((int)Math.round(d2), n2, (int)Math.round(d2), n2 + 3);
                        graphics.setColor(color2);
                        this.paintLabel(graphics, string, (int)Math.round(d4), n7, dimension, 0, n5);
                        d3 = d4 + (double)dimension2.width;
                    }
                } else if (string != null && string.trim().length() > 0) {
                    graphics.drawLine((int)Math.round(d2), n2, (int)Math.round(d2), n2 + 3);
                    graphics.setColor(color2);
                    this.paintLabel(graphics, string, (int)Math.round(d4), n7, dimension, 0, n5);
                }
            }
            d2 += d;
            ++n6;
        }
    }

    public void setSampleLabelStyle(int n) {
        this.sampleLabelStyle = n;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSampleLabelStyle() {
        return this.sampleLabelStyle;
    }

    public void setSeriesLineOn(boolean bl) {
        int n = 0;
        while (n < this.seriesLinesOn.length) {
            this.seriesLinesOn[n] = bl;
            ++n;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int n, boolean bl) {
        this.seriesLinesOn[n] = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void paintSampleHighlight(Graphics graphics, int n, int n2, int n3, Color color) {
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        String string = this.getLegendImage(n);
        Dimension dimension = this.getImageSize(string);
        if (string != null && dimension.width > 0 && dimension.height > 0) {
            Image image = (Image)this.images.get(string);
            if (image != null) {
                graphics.drawImage(image, n2 - dimension.width / 2, n3 - dimension.height / 2, this);
            }
        } else {
            int n4 = 6;
            if (n >= 0 && n < this.sampleHighlightSize.length) {
                n4 = this.sampleHighlightSize[n];
            }
            int n5 = 0;
            if (n >= 0 && n < this.sampleHighlightStyle.length) {
                n5 = this.sampleHighlightStyle[n];
            }
            Color color2 = this.getChartBackground();
            graphics.setColor(color);
            switch (n5) {
                case 0: {
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 2: {
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 1: {
                    graphics.setColor(color2);
                    graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 3: {
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 5: {
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    break;
                }
                case 4: {
                    graphics.setColor(color2);
                    graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                    graphics.setColor(color);
                    graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int[] nArray = new int[4];
                    nArray[0] = nArray[2] = n2;
                    nArray[1] = n2 + n4 / 2;
                    nArray[3] = n2 - n4 / 2;
                    int[] nArray2 = new int[4];
                    nArray2[0] = n3 - n4 / 2;
                    nArray2[2] = n3 + n4 / 2;
                    nArray2[1] = nArray2[3] = n3;
                    if (n5 == 7) {
                        graphics.setColor(color2);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    } else if (n5 == 8) {
                        graphics.setColor(color);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    graphics.setColor(color);
                    graphics.drawPolygon(nArray, nArray2, 4);
                    break;
                }
            }
        }
        graphics.setClip(shape);
    }

    double getHighestValue(int n) {
        if (this.stackedOn) {
            return this.getMaxValue(-2);
        }
        return super.getHighestValue(n);
    }

    public double getMaxValue(int n) {
        if (n >= -1 || !this.stackedOn) {
            return super.getMaxValue(n);
        }
        double d = 0.0;
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        int n4 = 0;
        while (n4 < n2) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n3) {
                ChartSample chartSample = this.getSample(n5, n4);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && chartSample.value > 0.0) {
                    d2 += chartSample.value.doubleValue();
                }
                ++n5;
            }
            d = Math.max(d, d2);
            ++n4;
        }
        return d;
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        this.calculateZeroLines(rectangle);
        if (this.is3DModeOn()) {
            if (this.depth3d > -1) {
                this.depth3dPoint.x = this.depth3d;
                this.depth3dPoint.y = -this.depth3d;
            } else {
                int n = Math.max(this.getSampleCount(), 20);
                int n2 = this.getSeriesCount();
                if (n2 > 1 && !this.stackedOn) {
                    n /= n2;
                    n = Math.max(n, 4);
                }
                double d = (double)rectangle.width / (double)n;
                this.depth3dPoint.x = (int)Math.round(d * 1.25);
                this.depth3dPoint.y = (int)Math.round(-d / 1.25);
            }
        }
    }

    private void paintFloatingLabels(Graphics graphics, Rectangle rectangle) {
        boolean bl = this.isValueLabelsOn(-1) && this.valueLabelStyle == 2;
        bl |= this.sampleLabelsOn && this.sampleLabelStyle == 2;
        if (bl |= this.seriesLabelsOn) {
            Font font = this.getFont("floatingLabelFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (this.selectedSample >= 0 && this.selectedSeries >= 0) {
                ChartSample chartSample = this.getSample(this.selectedSeries, this.selectedSample);
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    String string = this.constructFloatingLabel(this.selectedSeries, this.selectedSample, this.seriesLabelsOn);
                    this.paintFloatingLabel(graphics, rectangle, this.selectedSeries, this.selectedSample, string, font, fontMetrics);
                }
            } else if (this.selectedSeries >= 0 && this.isFloatingOnLegendOn()) {
                int n = this.getSampleCount();
                int n2 = 0;
                while (n2 < n) {
                    ChartSample chartSample = this.getSample(this.selectedSeries, n2);
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                        String string = this.constructFloatingLabel(this.selectedSeries, n2, false);
                        this.paintFloatingLabel(graphics, rectangle, this.selectedSeries, n2, string, font, fontMetrics);
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean isSeriesLineOn(int n) {
        return this.seriesLinesOn[n];
    }

    public void setSampleLabelsOn(boolean bl) {
        this.sampleLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isSeriesLabelsOn() {
        return this.seriesLabelsOn;
    }

    public void setLineWidth(int n) {
        this.setLineWidth(-1, n);
    }

    public void setLineWidth(int n, int n2) {
        if (n >= 0 && n < this.lineWidth.length) {
            this.lineWidth[n] = n2;
        } else if (n < 0) {
            int n3 = 0;
            while (n3 < this.lineWidth.length) {
                this.lineWidth[n3] = n2;
                ++n3;
            }
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int n) {
        if (n >= 0 && n < this.lineWidth.length) {
            return this.lineWidth[n];
        }
        return this.lineWidth[0];
    }

    public void setValueLabelStyle(int n) {
        this.valueLabelStyle = n;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public boolean isSampleHighlightOn(int n, int n2) {
        try {
            return this.sampleHighlightOn[n][n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
    }

    public ChartSample checkSelection(Point point) {
        int n;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = null;
        this.getSeriesCount();
        if (this.isLegendOn() && this.legendBounds != null) {
            n = 0;
            while (n < this.legendBounds.length) {
                if (this.legendBounds[n] != null && this.legendBounds[n].contains(point)) {
                    chartSample = new ChartSample(-1);
                    chartSample.setSeries(n);
                    break;
                }
                ++n;
            }
        }
        if (chartSample == null && this.samplePosition != null) {
            n = 3;
            int n2 = 0;
            while (n2 < this.samplePosition.length) {
                Point[] pointArray = this.samplePosition[n2];
                if (pointArray != null) {
                    int n3 = 0;
                    while (n3 < pointArray.length) {
                        if (pointArray[n3] != null) {
                            Point point2 = new Point(pointArray[n3]);
                            if (this.is3DModeOn()) {
                                point2.x -= this.depth3dPoint.x;
                                if (!this.stackedOn) {
                                    double d = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                                    int n4 = (int)Math.round(d * (double)n2);
                                    point2.x += n4;
                                }
                            }
                            boolean bl = point.x >= point2.x - n && point.x <= point2.x + n;
                            if (bl &= point.y >= point2.y - n && point.y <= point2.y + n) {
                                return this.getSample(n2, n3);
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return chartSample;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.paintLines(graphics, rectangle, rectangle2);
    }

    public void reset() {
        super.reset();
        this.valueLabelStyle = 0;
        this.autoLabelSpacingOn = false;
        this.multiSeriesOn = true;
        this.selectedSample = -1;
        this.selectedSeries = -1;
        this.hasChanged = true;
    }

    public void setSampleColors(Color[] colorArray) {
        super.setSampleColors(colorArray);
        if (colorArray == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int n, int n2, double d) {
        this(n, n2, d, 0.0);
    }

    public LineChart(int n, int n2, double d, double d2) {
        super(n2);
        this.chartType = "line";
        this.multiSeriesOn = true;
        this.sampleHighlightOn = new boolean[n][n2];
        this.sampleHighlightStyle = new int[n];
        this.sampleHighlightSize = new int[n];
        this.seriesLinesOn = new boolean[n];
        this.lineWidth = new int[n];
        int n3 = 0;
        while (n3 < this.sampleHighlightSize.length) {
            this.sampleHighlightSize[n3] = 6;
            this.seriesLinesOn[n3] = true;
            this.lineWidth[n3] = 2;
            ++n3;
        }
        this.connectedLinesOn = new boolean[n];
        this.samplePosition = new Point[n][n2];
        n3 = 0;
        while (n3 < this.samplePosition.length) {
            int n4 = 0;
            while (n4 < this.samplePosition[n3].length) {
                this.samplePosition[n3][n4] = new Point();
                ++n4;
            }
            ++n3;
        }
        this.mousePosition = new Point();
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(n);
        this.setRange(0, d);
        this.setLowerRange(0, d2);
        this.setSampleColors(null);
        this.setAutomaticRepaintOn(true);
        this.selectedSample = -1;
        this.selectedSeries = -1;
    }

    private void paintLine(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        boolean bl2;
        int n2;
        int n3;
        int n4 = this.getSeriesCount();
        if (n < 0 || n >= n4) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        ChartSample[] chartSampleArray = this.getSamples(n);
        if (chartSampleArray == null || chartSampleArray.length == 0) {
            return;
        }
        double d = rectangle2.width;
        if (chartSampleArray.length - 1 > 0) {
            d = (double)(rectangle2.width - 1) / (double)(chartSampleArray.length - 1);
        }
        Color color2 = this.stackedOn || bl ? color.darker() : color;
        boolean bl3 = this.is3DModeOn();
        Graphics graphics2 = graphics;
        if (bl3) {
            graphics2.setClip(rectangle.x - this.depth3dPoint.x + 1, rectangle.y + 1, rectangle.width + this.depth3dPoint.x - 1, rectangle.height - this.depth3dPoint.y - 1);
        } else {
            graphics2.setClip(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height + 1);
        }
        double d2 = rectangle2.x + 1;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        boolean bl4 = false;
        double d3 = d2;
        double d4 = this.calculateYPos(n, 0, rectangle2);
        int n5 = 0;
        while (n5 < chartSampleArray.length - 1) {
            n3 = chartSampleArray[n5] == null || chartSampleArray[n5].value == null || chartSampleArray[n5].value.isNaN() ? 0 : 1;
            int n6 = n2 = chartSampleArray[n5 + 1] == null || chartSampleArray[n5 + 1].value == null || chartSampleArray[n5 + 1].value.isNaN() ? 0 : 1;
            if (n3 != 0) {
                d3 = d2;
                d4 = this.calculateYPos(n, n5, rectangle2);
                bl4 = true;
            }
            bl2 = n3 != 0 && n2 != 0;
            if ((bl2 |= n2 != 0 && this.connectedLinesOn[n]) && bl4) {
                int n7;
                if (this.connectedLinesOn[n]) {
                    nArray[0] = (int)d3;
                    nArray2[0] = (int)d4;
                } else {
                    nArray[0] = (int)d2;
                    nArray2[0] = this.calculateYPos(n, n5, rectangle2);
                }
                nArray[1] = (int)(d2 + d);
                nArray2[1] = this.calculateYPos(n, n5 + 1, rectangle2);
                if (bl3) {
                    nArray[0] = nArray[0] - this.depth3dPoint.x;
                    nArray[1] = nArray[1] - this.depth3dPoint.x;
                    nArray[2] = nArray[2] - this.depth3dPoint.x;
                    nArray[3] = nArray[3] - this.depth3dPoint.x;
                    if (!this.stackedOn) {
                        double d5 = (double)this.depth3dPoint.x / (double)n4;
                        n7 = (int)Math.round(d5 * (double)n);
                        nArray[0] = nArray[0] + n7;
                        nArray[1] = nArray[1] + n7;
                        nArray[2] = nArray[2] + n7;
                        nArray[3] = nArray[3] + n7;
                    }
                }
                if (this.stackedOn) {
                    nArray[2] = nArray[1];
                    nArray2[2] = this.calculateYPos(n - 1, n5 + 1, rectangle2);
                    nArray[3] = nArray[0];
                    nArray2[3] = this.calculateYPos(n - 1, n5, rectangle2);
                }
                boolean bl5 = false;
                int n8 = rectangle.x - (bl3 ? this.depth3dPoint.x * 2 : 0);
                n7 = rectangle.x + rectangle.width;
                bl5 |= nArray[0] >= n8 && nArray[0] <= n7;
                bl5 |= nArray[1] >= n8 && nArray[1] <= n7;
                if (bl5 |= nArray[0] <= n8 && nArray[1] >= n7) {
                    int n9;
                    if (this.seriesLinesOn[n]) {
                        if (bl3 && this.stackedOn) {
                            boolean bl6;
                            boolean bl7 = n == n4 - 1;
                            boolean bl8 = bl6 = n5 == chartSampleArray.length - 2;
                            if (n5 < chartSampleArray.length - 2) {
                                bl6 |= chartSampleArray[n5 + 2] == null || chartSampleArray[n5 + 2].value == null || chartSampleArray[n5 + 2].value.isNaN();
                                bl6 &= !this.connectedLinesOn[n];
                            }
                            this.paint3DLine(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, bl7, bl6);
                        } else if (bl3) {
                            this.paint3DLine(graphics2, nArray[0], nArray2[0], nArray[1], nArray2[1], nArray2[2], color2, true, false);
                        }
                    }
                    if (this.stackedOn && this.seriesLinesOn[n]) {
                        graphics2.setColor(bl ? color.darker() : color);
                        graphics2.fillPolygon(nArray, nArray2, 4);
                        graphics2.setColor(color.darker());
                        graphics2.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                    }
                    graphics2.setColor(color);
                    if (bl3 && this.stackedOn) {
                        graphics2.setColor(color.darker().darker());
                    } else if (bl3 || this.stackedOn) {
                        graphics2.setColor(color.darker());
                    }
                    nArray[0] = Math.max(nArray[0], -10000);
                    nArray[1] = Math.max(nArray[1], -10000);
                    nArray[0] = Math.min(nArray[0], 11000);
                    nArray[1] = Math.min(nArray[1], 11000);
                    nArray2[0] = Math.max(nArray2[0], -10000);
                    nArray2[1] = Math.max(nArray2[1], -10000);
                    nArray2[0] = Math.min(nArray2[0], 11000);
                    nArray2[1] = Math.min(nArray2[1], 11000);
                    if (this.seriesLinesOn[n] || bl) {
                        graphics2.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                        if (!bl3 && !this.stackedOn && this.lineWidth[n] > 1 && (this.seriesLinesOn[n] || bl)) {
                            double d6 = 0.0;
                            if (nArray[1] - nArray[0] != 0) {
                                d6 = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                            }
                            n9 = 1;
                            int n10 = 2;
                            while (n10 <= this.lineWidth[n]) {
                                int n11 = n10 / 2 * n9;
                                if (d6 <= 1.0) {
                                    graphics2.drawLine(nArray[0], nArray2[0] + n11, nArray[1], nArray2[1] + n11);
                                } else {
                                    graphics2.drawLine(nArray[0] - n11, nArray2[0], nArray[1] - n11, nArray2[1]);
                                }
                                n9 = -n9;
                                ++n10;
                            }
                        }
                    }
                    if (bl && this.seriesLinesOn[n] && !bl3 && !this.stackedOn) {
                        double d7 = 0.0;
                        if (nArray[1] - nArray[0] != 0) {
                            d7 = Math.abs((double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]));
                        }
                        n9 = this.lineWidth[n] / 2 + 1;
                        graphics2.setColor(color.darker().darker());
                        if (d7 <= 1.0) {
                            graphics2.drawLine(nArray[0], nArray2[0] + n9, nArray[1], nArray2[1] + n9);
                        } else {
                            graphics2.drawLine(nArray[0] - n9, nArray2[0], nArray[1] - n9, nArray2[1]);
                        }
                    }
                }
            }
            d2 += d;
            ++n5;
        }
        if (!bl3) {
            d2 = rectangle2.x + 1;
            n5 = 0;
            while (n5 < chartSampleArray.length) {
                ChartSample chartSample = chartSampleArray[n5];
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN() && this.sampleHighlightOn[n][n5]) {
                    n2 = this.calculateYPos(n, n5, rectangle2);
                    boolean bl9 = bl2 = n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height && d2 >= (double)rectangle.x && d2 <= (double)(rectangle.x + rectangle.width + 1);
                    if (bl2) {
                        this.paintSampleHighlight(graphics, n, (int)Math.round(d2), n2, color);
                    }
                }
                d2 += d;
                ++n5;
            }
        }
        d2 = rectangle2.x + 1;
        n5 = 0;
        while (n5 < chartSampleArray.length) {
            n3 = this.calculateYPos(n, n5, rectangle2);
            if (this.samplePosition != null && n < this.samplePosition.length && this.samplePosition[n] != null && n5 < this.samplePosition[n].length && this.samplePosition[n][n5] != null) {
                this.samplePosition[n][n5].x = (int)Math.round(d2);
                this.samplePosition[n][n5].y = Math.round(n3);
            }
            d2 += d;
            ++n5;
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public boolean isAutoLabelSpacingOn() {
        return this.autoLabelSpacingOn;
    }

    public boolean isStackedOn() {
        return this.stackedOn;
    }

    public boolean isConnectedLinesOn(int n) {
        if (n >= 0 && n < this.connectedLinesOn.length) {
            return this.connectedLinesOn[n];
        }
        if (n == -1) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.connectedLinesOn.length) {
                if (this.connectedLinesOn[n2]) {
                    bl = true;
                }
                ++n2;
            }
            return bl;
        }
        return false;
    }

    public void setLegendImage(int n, String string) {
        if (n >= 0 && n < 1000) {
            super.setLegendImage(n, string);
            if (this.highlightImages == null) {
                this.highlightImages = new String[n + 1];
            }
            if (n >= this.highlightImages.length) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.highlightImages, 0, stringArray, 0, this.highlightImages.length);
                this.highlightImages = stringArray;
            }
            this.highlightImages[n] = string;
            this.hasChanged = true;
            this.autoRepaint();
        }
    }

    private String constructFloatingLabel(int n, int n2, boolean bl) {
        String string;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return "";
        }
        String string2 = "";
        if (bl && (string = this.getSeriesLabel(n)) != null) {
            string2 = string2 + string;
            if (!string.endsWith("\n") && this.sampleLabelsOn && this.sampleLabelStyle == 2 && this.getSampleLabel(n2) != null) {
                string2 = string2 + " : ";
            }
        }
        if (this.sampleLabelsOn && this.sampleLabelStyle == 2 && this.getSampleLabel(n2) != null) {
            string2 = string2 + this.getSampleLabel(n2);
        }
        if (this.isValueLabelsOn() && this.valueLabelStyle == 2) {
            String string3;
            string = this.getLabel("valueLabelPrefix_" + n);
            if (string == null) {
                string = this.getLabel("valueLabelPrefix");
            }
            if ((string3 = this.getLabel("valueLabelPostfix_" + n)) == null) {
                string3 = this.getLabel("valueLabelPostfix");
            }
            if (string2.length() > 0) {
                String string4 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string4 = string != null ? string + string4 : string4;
                String string5 = string4 = string3 != null ? string4 + string3 : string4;
                string2 = string2.endsWith("\n") ? string2 + string4 : string2 + " : " + string4;
            } else {
                string2 = this.formatNumber(this.getSampleValue(n, n2), this.getSampleDecimalCount(n));
                string2 = string != null ? string + string2 : string2;
                string2 = string3 != null ? string2 + string3 : string2;
            }
        }
        return string2;
    }

    private int calculateYPos(int n, int n2, Rectangle rectangle) {
        int n3;
        double d = 0.0;
        if (n >= 0 && this.stackedOn) {
            n3 = 0;
            while (n3 <= n) {
                d += this.getSampleValue(n3, n2);
                ++n3;
            }
        } else if (n >= 0) {
            d = this.getSampleValue(n, n2);
        }
        n3 = this.getSeriesRange(n);
        double d2 = 0.0;
        if (this.currentUpperRange[n3] - this.currentLowerRange[n3] != 0.0) {
            d2 = (d - this.currentLowerRange[n3]) / (this.currentUpperRange[n3] - this.currentLowerRange[n3]);
        }
        int n4 = rectangle.y + rectangle.height - (int)(d2 * (double)rectangle.height);
        boolean bl = this.is3DModeOn();
        if (bl && this.stackedOn) {
            n4 -= this.depth3dPoint.y;
        } else if (bl) {
            n4 -= this.depth3dPoint.y;
            double d3 = (double)this.depth3dPoint.y / (double)this.getSeriesCount() * (double)n;
            n4 += (int)Math.round(d3);
        }
        return n4;
    }

    private void paintValueLabels(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, int n, boolean bl) {
        String string;
        if (this.valueLabelStyle == 2) {
            return;
        }
        Font font = this.getFont("valueLabelFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getAscent();
        int n3 = this.getSampleDecimalCount(n);
        int n4 = this.getSampleCount();
        int n5 = this.getSeriesCount();
        int n6 = this.getLabelAngle("valueLabelAngle");
        this.getSize();
        double d = rectangle2.x;
        double d2 = rectangle2.width;
        if (n4 > 2) {
            d2 = (double)rectangle2.width / (double)(n4 - 1);
        }
        double d3 = this.depth3dPoint.x;
        boolean bl2 = this.is3DModeOn();
        if (bl2) {
            d -= (double)this.depth3dPoint.x;
            d3 = (double)this.depth3dPoint.x / (double)n5 * (double)n;
            d += d3;
        }
        graphics.setColor(this.getChartForeground());
        String string2 = this.getLabel("valueLabelPrefix_" + n);
        if (string2 == null) {
            string2 = this.getLabel("valueLabelPrefix");
        }
        if ((string = this.getLabel("valueLabelPostfix_" + n)) == null) {
            string = this.getLabel("valueLabelPostfix");
        }
        ChartSample[] chartSampleArray = this.getSamples(n);
        int n7 = 0;
        while (n7 < chartSampleArray.length) {
            block27: {
                int n8;
                Serializable serializable;
                double d4;
                block29: {
                    block28: {
                        block26: {
                            if (bl || chartSampleArray[n7] != null && chartSampleArray[n7].value != null && !chartSampleArray[n7].value.isNaN()) break block26;
                            d += d2;
                            break block27;
                        }
                        d4 = 0.0;
                        if (!bl) break block28;
                        boolean bl3 = false;
                        int n9 = 0;
                        while (n9 < n5) {
                            serializable = this.getSample(n9, n7);
                            if (serializable != null && serializable.value != null && !serializable.value.isNaN()) {
                                d4 += serializable.value.doubleValue();
                                bl3 = true;
                            }
                            ++n9;
                        }
                        if (bl3) break block29;
                        d += d2;
                        break block27;
                    }
                    d4 = chartSampleArray[n7].getFloatValue();
                }
                String string3 = this.formatNumber(d4, n3);
                string3 = string2 != null ? string2 + string3 : string3;
                string3 = string != null ? string3 + string : string3;
                Dimension dimension = this.getLabelSize(string3, font);
                serializable = this.getAngledLabelSize(dimension, n6);
                int n10 = (int)Math.round(d - (double)(((Dimension)serializable).width / 2)) + 1;
                if (this.valueLabelStyle == 0) {
                    n10 = bl2 ? Math.max(rectangle2.x - this.depth3dPoint.x + 2, n10) : Math.max(rectangle2.x + 2, n10);
                    n10 = Math.min(n10, rectangle.x + rectangle.width - ((Dimension)serializable).width - 1);
                }
                if (n6 % 360 > 90 && n6 % 360 < 180 || n6 % 360 > 270) {
                    n10 = (int)(d - (double)(fontMetrics.getAscent() / 2));
                }
                int n11 = n8 = this.calculateYPos(n, n7, rectangle2) - 1;
                if (n6 % 180 != 0) {
                    n11 -= ((Dimension)serializable).height + 1;
                }
                if (this.valueLabelStyle == 1) {
                    n11 = n6 % 180 == 0 ? (n11 += n2 / 2) : n8 - ((Dimension)serializable).height / 2;
                } else if (!this.stackedOn) {
                    double d5;
                    double d6;
                    double d7 = n7 > 0 && chartSampleArray[n7 - 1] != null ? chartSampleArray[n7 - 1].getFloatValue() : d4;
                    double d8 = (d4 - d7) / d2;
                    if (d8 < (d6 = ((d5 = n7 < chartSampleArray.length - 1 && chartSampleArray[n7 + 1] != null ? chartSampleArray[n7 + 1].getFloatValue() : d4) - d4) / d2)) {
                        n11 = n6 % 180 == 0 ? (n11 += n2) : (n11 += ((Dimension)serializable).height + 4);
                        if (n6 % 360 > 90 && n6 % 360 < 180 || n6 % 360 > 270) {
                            n10 = (int)(d - (double)((Dimension)serializable).width + (double)(fontMetrics.getAscent() / 2));
                        }
                    } else if (bl2) {
                        double d9 = (double)this.depth3dPoint.x / (double)n5;
                        n10 = (int)((double)n10 + d9);
                        d9 = (double)this.depth3dPoint.y / (double)n5;
                        n11 = (int)((double)n11 + d9);
                    }
                    try {
                        boolean bl4 = this.sampleHighlightOn[n][n7];
                        int n12 = this.sampleHighlightSize[n];
                        if (bl4 && d8 < d6) {
                            n11 += n12 / 2;
                        } else if (bl4) {
                            n11 -= n12 / 2;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        System.out.println("Internal error with value labels");
                        indexOutOfBoundsException.printStackTrace();
                    }
                }
                boolean bl5 = false;
                if (bl2) {
                    bl5 = n8 >= rectangle.y - 10 && n8 <= rectangle.y + rectangle.height + 10 - this.depth3dPoint.y && d >= (double)(rectangle.x - 2 - this.depth3dPoint.x) && d <= (double)(rectangle.x + rectangle.width + 2);
                } else {
                    boolean bl6 = bl5 = n8 >= rectangle.y - 2 && n8 <= rectangle.y + rectangle.height + 2 && d >= (double)(rectangle.x - 4) && d <= (double)(rectangle.x + rectangle.width + 2);
                }
                if (bl5) {
                    this.paintLabel(graphics, string3, n10, n11, dimension, 0, n6);
                }
                d += d2;
            }
            ++n7;
        }
    }

    public void render(Graphics graphics) {
        this.render(graphics, !this.isServletModeOn());
    }

    void render(Graphics graphics, boolean bl) {
        Rectangle rectangle;
        Rectangle rectangle2;
        Chart chart;
        Dimension dimension = this.getSize();
        Rectangle rectangle3 = this.getGraphBounds();
        Rectangle rectangle4 = this.getDataBounds(rectangle3);
        this.calculateChartData(rectangle3, rectangle4);
        int n = 0;
        while (n < this.overlayCharts.size()) {
            chart = (Chart)this.overlayCharts.elementAt(n);
            if (chart != null) {
                rectangle2 = new Rectangle(rectangle3);
                rectangle = new Rectangle(rectangle4);
                if (this.is3DModeOn()) {
                    rectangle2.x -= this.depth3dPoint.x;
                    rectangle2.y -= this.depth3dPoint.y;
                    rectangle.x -= this.depth3dPoint.x;
                    rectangle.y -= this.depth3dPoint.y;
                }
                chart.calculateChartData(rectangle2, rectangle);
            }
            ++n;
        }
        if (bl && this.offscreen == null) {
            this.offscreen = this.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            this.hasChanged = true;
        }
        if (!bl || this.hasChanged || this.offscreen == null) {
            if (!this.externalGraphicsOn && !bl) {
                this.og = graphics;
            } else if (bl || this.externalGraphicsOn) {
                if (!this.externalGraphicsOn && this.offscreen != null) {
                    this.og = this.offscreen.getGraphics();
                }
                this.og.setColor(this.getBackground());
                this.og.fillRect(0, 0, dimension.width, dimension.height);
            }
            this.paintGrid(this.og, rectangle3);
            this.paintTitle(this.og, dimension);
            if (this.sampleLabelsOn && this.sampleLabelStyle != 2) {
                this.paintSampleLabels(this.og, rectangle3, rectangle4);
            }
            if (this.isLegendOn()) {
                this.paintLegend(this.og, rectangle3, this.getLegendLabels());
            }
            this.renderData(this.og, rectangle3, rectangle4);
            n = 0;
            while (n < this.overlayCharts.size()) {
                chart = (Chart)this.overlayCharts.elementAt(n);
                if (chart != null && this.isOverlayChartOn(n)) {
                    rectangle2 = new Rectangle(rectangle3);
                    rectangle = new Rectangle(rectangle4);
                    rectangle2.x -= this.depth3dPoint.x;
                    rectangle2.y -= this.depth3dPoint.y;
                    rectangle.x -= this.depth3dPoint.x;
                    rectangle.y -= this.depth3dPoint.y;
                    if (chart instanceof LineChart || chart instanceof PieChart) {
                        chart.renderData(this.og, rectangle2, rectangle);
                    } else {
                        chart.renderData(this.og, rectangle3, rectangle4);
                    }
                }
                ++n;
            }
            if (this.is3DModeOn()) {
                n = this.rangeOn.length - 1;
                while (n >= 0) {
                    this.paint3DZeroDivider(this.og, rectangle3, n);
                    --n;
                }
                this.paint3DEdges(this.og, rectangle3);
            }
            if (!this.externalGraphicsOn && this.og != graphics) {
                this.og.dispose();
            }
            this.hasChanged = false;
        }
        if ((bl || this.externalGraphicsOn) && this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, this);
        }
        this.paintFloatingLabels(graphics, rectangle3);
    }

    private void paintLines(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSeriesCount();
        if (n > 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = this.getSeriesRange(n2);
                if (this.currentUpperRange[n3] != this.currentLowerRange[n3]) {
                    this.paintLine(graphics, n2, rectangle, rectangle2, this.getSampleColor(n2), this.isSelected(n2, -1));
                }
                --n2;
            }
            if (this.stackedOn) {
                if (this.isValueLabelsOn(0)) {
                    this.paintValueLabels(graphics, rectangle, rectangle2, n - 1, true);
                }
            } else {
                n2 = n - 1;
                while (n2 >= 0) {
                    if (this.isValueLabelsOn(n2)) {
                        this.paintValueLabels(graphics, rectangle, rectangle2, n2, false);
                    }
                    --n2;
                }
            }
        }
    }

    public int getValuePosition(double d) {
        return this.getValuePosition(0, d, this.getGraphBounds());
    }

    public void setSeriesLabelsOn(boolean bl) {
        this.seriesLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(boolean bl) {
        int n = 0;
        while (n < this.sampleHighlightOn.length) {
            int n2 = 0;
            while (n2 < this.sampleHighlightOn[n].length) {
                this.sampleHighlightOn[n][n2] = bl;
                ++n2;
            }
            ++n;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, boolean bl) {
        try {
            int n2 = 0;
            while (n2 < this.sampleHighlightOn[n].length) {
                this.sampleHighlightOn[n][n2] = bl;
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, int n2, boolean bl) {
        try {
            this.sampleHighlightOn[n][n2] = bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSampleHighlightSize(int n) {
        try {
            return this.sampleHighlightSize[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    protected void checkDataIntegrity() {
        int n;
        super.checkDataIntegrity();
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = this.sampleHighlightOn.length;
        int n5 = n = n4 > 0 ? this.sampleHighlightOn[0].length : 0;
        if (n2 != n4 || n3 != n) {
            boolean[][] blArray = new boolean[n2][n3];
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n3) {
                    if (n6 < n4 && n7 < n) {
                        blArray[n6][n7] = this.sampleHighlightOn[n6][n7];
                    }
                    ++n7;
                }
                ++n6;
            }
            this.sampleHighlightOn = blArray;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean[] blArray2 = new boolean[n2];
            boolean[] blArray3 = new boolean[n2];
            int[] nArray3 = new int[n2];
            int n8 = 0;
            while (n8 < n2) {
                if (n8 < n4) {
                    nArray[n8] = this.sampleHighlightStyle[n8];
                    nArray2[n8] = this.sampleHighlightSize[n8];
                    blArray2[n8] = this.seriesLinesOn[n8];
                    blArray3[n8] = this.connectedLinesOn[n8];
                    nArray3[n8] = this.lineWidth[n8];
                } else {
                    nArray2[n8] = 6;
                    blArray2[n8] = true;
                    nArray3[n8] = 2;
                }
                ++n8;
            }
            this.sampleHighlightStyle = nArray;
            this.sampleHighlightSize = nArray2;
            this.seriesLinesOn = blArray2;
            this.connectedLinesOn = blArray3;
            this.lineWidth = nArray3;
        }
        this.samplePosition = new Point[n2][n3];
        int n9 = 0;
        while (n9 < this.samplePosition.length) {
            int n10 = 0;
            while (n10 < this.samplePosition[n9].length) {
                this.samplePosition[n9][n10] = new Point();
                ++n10;
            }
            ++n9;
        }
    }

    public Rectangle getGraphBounds() {
        Insets insets;
        String string;
        Object object;
        Object object2;
        if (!this.hasChanged && this.currentBounds != null) {
            return this.currentBounds;
        }
        Rectangle rectangle = super.getGraphBounds(this.getLegendLabels());
        Dimension dimension = this.getSize();
        int n = rectangle.x;
        int n2 = dimension.width - rectangle.width - rectangle.x;
        int n3 = rectangle.y;
        int n4 = dimension.height - rectangle.height - rectangle.y;
        int n5 = 0;
        while (n5 < this.rangeAdjusterOn.length) {
            if (this.rangeAdjusterOn[n5]) {
                if (this.rangeAdjusterPosition[n5] == 0) {
                    n += 6;
                } else {
                    n2 += 6;
                }
            }
            ++n5;
        }
        if (this.sampleLabelsOn && this.getSampleCount() > 0 && this.sampleLabelStyle != 2) {
            Dimension dimension2;
            Font font = this.getFont("sampleLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n6 = 0;
            int n7 = this.getLabelAngle("sampleLabelAngle");
            object2 = this.getSampleLabels();
            int n8 = 0;
            while (n8 < ((String[])object2).length) {
                Dimension dimension3 = this.getLabelSize(object2[n8], font);
                dimension2 = this.getAngledLabelSize(dimension3, n7);
                n6 = Math.max(dimension2.height, n6);
                ++n8;
            }
            n4 += n6 + 3;
            if (n7 % 180 == 0) {
                n4 -= fontMetrics.getMaxDescent();
            }
            String string2 = this.getSampleLabel(this.getSampleCount() - 1);
            int n9 = 0;
            if (string2 != null) {
                dimension2 = this.getLabelSize(string2, font);
                object = this.getAngledLabelSize(dimension2, n7);
                n9 = ((Dimension)object).width / 2 - 5;
            }
            int n10 = 0;
            if (this.isLegendOn() && this.getLegendPosition() == 1) {
                n10 = this.legend.width;
            }
            if (n9 > n10) {
                n2 += n9 - n10;
            }
        }
        boolean bl = false;
        int n11 = 0;
        while (n11 < this.rangeOn.length) {
            bl = this.rangeOn[n11] ? true : bl;
            ++n11;
        }
        if (bl || this.rangeLabelsOn || this.targetsLabel.size() > 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            String string3 = this.getLabel("rangeLabelPrefix");
            String string4 = this.getLabel("rangeLabelPostfix");
            int n12 = 0;
            int n13 = 0;
            Enumeration enumeration = this.targetsLabel.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                object = this.getTargetLabel(string5);
                if (object == null || ((String)object).length() <= 0) continue;
                if (this.rangePosition[0] == 0) {
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                    continue;
                }
                n13 = Math.max(n13, fontMetrics.stringWidth((String)object));
            }
            if (this.rangeLabelsOn && this.rangeOn[0]) {
                int n14 = this.getRangeDecimalCount(0);
                String string6 = this.formatNumber(this.upperRange[0], n14);
                object = this.formatNumber(this.lowerRange[0], n14);
                string6 = string3 != null ? string3 + string6 : string6;
                object = string3 != null ? string3 + (String)object : object;
                string6 = string4 != null ? string6 + string4 : string6;
                Object object3 = object = string4 != null ? (String)object + string4 : object;
                if (this.rangePosition[0] == 0) {
                    n12 = Math.max(n12, fontMetrics.stringWidth(string6));
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                } else {
                    n13 = Math.max(n13, fontMetrics.stringWidth(string6));
                    n13 = Math.max(n13, fontMetrics.stringWidth((String)object));
                }
            }
            if (this.rangeOn[1]) {
                int n15 = this.getRangeDecimalCount(1);
                String string7 = this.formatNumber(this.upperRange[1], n15);
                object = this.formatNumber(this.lowerRange[1], n15);
                if (this.rangePosition[1] == 0) {
                    n12 = Math.max(n12, fontMetrics.stringWidth(string7));
                    n12 = Math.max(n12, fontMetrics.stringWidth((String)object));
                } else {
                    n13 = Math.max(n13, fontMetrics.stringWidth(string7));
                    n13 = Math.max(n13, fontMetrics.stringWidth((String)object));
                }
            }
            n += n12 + 2;
            n2 += n13 > 0 ? n13 + 2 : 0;
        }
        if ((string = this.getLabel("sampleAxisLabel")) != null) {
            Font font = this.getFont("sampleAxisLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n16 = this.getLabelAngle("sampleAxisLabelAngle");
            Dimension dimension4 = this.getLabelSize(string, font);
            Dimension dimension5 = this.getAngledLabelSize(dimension4, n16);
            n4 += dimension5.height + 3;
            if (n16 % 180 == 0) {
                n4 -= fontMetrics.getDescent();
            }
        }
        int n17 = 0;
        do {
            String string8;
            String string9 = string8 = n17 == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
            if (string8 == null) continue;
            object2 = this.getFont("rangeAxisLabelFont");
            this.getFontMetrics((Font)object2);
            int n18 = n17 == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
            Dimension dimension6 = this.getLabelSize(string8, (Font)object2);
            Dimension dimension7 = this.getAngledLabelSize(dimension6, n18);
            if (this.rangePosition[n17] == 0) {
                n += dimension7.width + 20;
                continue;
            }
            n2 += dimension7.width + 20;
        } while (++n17 < 2);
        if (this.is3DModeOn()) {
            if (this.depth3d > -1) {
                n += this.depth3dPoint.x;
                n4 -= this.depth3dPoint.y;
            } else {
                n17 = Math.max(20, this.getSampleCount());
                int n19 = this.getSeriesCount();
                if (n19 > 1 && !this.stackedOn) {
                    n17 /= n19;
                    n17 = Math.max(n17, 4);
                }
                int n20 = (int)((float)rectangle.width * 1.25f / ((float)n17 + 1.25f));
                rectangle.width = dimension.width - (n += n20) - n2;
                double d = rectangle.width / n17;
                n4 += (int)Math.round(d / 1.25);
            }
        }
        if ((insets = this.getGraphInsets()) != null) {
            n3 = insets.top == -1 ? n3 : insets.top;
            n = insets.left == -1 ? n : insets.left;
            n4 = insets.bottom == -1 ? n4 : insets.bottom;
            n2 = insets.right == -1 ? n2 : insets.right;
        }
        rectangle.x = n;
        rectangle.width = dimension.width - n - n2;
        rectangle.y = n3;
        rectangle.height = dimension.height - n3 - n4;
        this.currentBounds = rectangle;
        return rectangle;
    }

    private void paint3DLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n6 = this.stackedOn ? 1 : Math.max(1, this.getSeriesCount());
        int n7 = (int)Math.round((double)this.depth3dPoint.x / (double)n6);
        int n8 = (int)Math.round((double)this.depth3dPoint.y / (double)n6);
        nArray[0] = n;
        nArray2[0] = n2;
        nArray[1] = n + n7;
        nArray2[1] = n2 + n8;
        nArray[2] = nArray[1] + (n3 - n);
        nArray2[2] = n4 + n8;
        nArray[3] = n3;
        nArray2[3] = n4;
        Color color2 = color.darker();
        if (bl) {
            double d = 0.0;
            if (nArray[1] - nArray[0] != 0) {
                d = (double)(n2 - n4) / (double)(n3 - n);
            }
            if (d > 0.69) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color);
            }
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
        }
        if (bl2) {
            nArray[0] = nArray[3];
            nArray2[0] = nArray2[3];
            nArray[1] = nArray[2];
            nArray2[1] = nArray2[2];
            nArray[2] = nArray[2];
            nArray2[2] = n5 + n8;
            nArray[3] = nArray[0];
            nArray2[3] = n5;
            graphics.setColor(color);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(color2);
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
            graphics.drawLine(nArray[3], nArray2[3], nArray[0], nArray2[0]);
        }
    }

    private void paint3DZeroDivider(Graphics graphics, Rectangle rectangle, int n) {
        if (this.rangeOn[n = Math.min(this.rangeOn.length - 1, Math.max(0, n))]) {
            int n2 = Math.max(this.zeroLine[n], rectangle.y);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
            int n3 = rectangle.x - this.depth3dPoint.x;
            int n4 = n2 - this.depth3dPoint.y;
            graphics.setColor(n == 0 ? this.getChartForeground() : this.getRangeColor(n));
            graphics.drawLine(n3, n4, n3 + rectangle.width, n4);
            graphics.drawLine(n3 + rectangle.width, n4, rectangle.x + rectangle.width, n2);
        }
    }

    private void paintFloatingLabel(Graphics graphics, Rectangle rectangle, int n, int n2, String string, Font font, FontMetrics fontMetrics) {
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.getSampleCount()) {
            return;
        }
        Point point = null;
        if (this.samplePosition != null && n < this.samplePosition.length && this.samplePosition[n] != null && n2 <= this.samplePosition[n].length) {
            point = this.samplePosition[n][n2];
        }
        if (point == null) {
            return;
        }
        int n3 = 0;
        if (this.is3DModeOn()) {
            if (this.stackedOn) {
                n3 = -this.depth3d;
            } else {
                double d = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                n3 = (int)Math.round(d * (double)n) - this.depth3dPoint.x;
            }
        }
        if (point.x < rectangle.x || point.x > rectangle.x + rectangle.width - n3) {
            return;
        }
        if (point.y < rectangle.y || point.y > (this.is3DModeOn() ? rectangle.y + rectangle.height - this.depth3dPoint.y : rectangle.y + rectangle.height)) {
            return;
        }
        Dimension dimension = this.getLabelSize(string, font);
        int n4 = point.x - dimension.width / 2 + n3;
        int n5 = point.y - dimension.height + fontMetrics.getAscent() - 3;
        Dimension dimension2 = this.getSize();
        n4 = Math.max(n4, 3);
        n4 = Math.min(n4, dimension2.width - dimension.width - 3);
        n5 = Math.max(n5, fontMetrics.getAscent());
        n5 = Math.min(n5, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n6 = fontMetrics.getHeight();
        int n7 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n4 - 2, n5 - n6 + n7 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(this.getChartForeground());
        graphics.setColor(this.getSampleColor(n).darker());
        graphics.drawRect(n4 - 3, n5 - n6 + n7 * 2 - 3, dimension.width + 5, dimension.height);
        graphics.setColor(Color.black);
        this.paintLabel(graphics, string, n4, n5, dimension, 0, 0);
    }

    public void setSampleHighlightStyle(int n, int n2) {
        int n3 = 0;
        while (n3 < this.sampleHighlightStyle.length) {
            this.setSampleHighlightStyle(n3, n, n2);
            ++n3;
        }
    }
}

