/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChartApplet;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.LineChartApplet;
import com.objectplanet.chart.NonFlickerPanel;
import com.objectplanet.chart.PieChartApplet;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class ChartApplet
extends Applet
implements Runnable,
ItemListener,
MouseMotionListener {
    public Chart theChart;
    protected Vector overlayChartApplets;
    private String prefix = "";
    private double[] rangeStep = new double[2];
    private int automaticRefreshTime = 2500;
    private Thread refreshThread;
    protected String labelDelimiter = ",";
    private Hashtable targets;
    private Hashtable urlList;
    private Hashtable urlTargetList;
    private static Cursor HAND_CURSOR;
    private static Cursor POINT_CURSOR;
    private int lastSelectedSample;
    private int lastSelectedSeries;
    private long lastSelectedTime;
    private static final int DOUBLE_CLICK_TIME = 350;
    private Applet parentApplet;

    public void stop() {
        if (this.refreshThread != null) {
            this.refreshThread.stop();
            this.refreshThread = null;
        }
    }

    protected Color[] getColorValues(String string) {
        Color[] colorArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            colorArray = new Color[stringTokenizer.countTokens()];
            int n = 0;
            while (n < colorArray.length) {
                if (stringTokenizer.hasMoreTokens()) {
                    colorArray[n] = ChartApplet.createColor(stringTokenizer.nextToken().trim());
                }
                ++n;
            }
        }
        return colorArray;
    }

    private URL getSampleURL(int n, int n2, int n3) {
        String string = this.createURLParam("url", n2, n3);
        URL uRL = (URL)this.urlList.get(string);
        if (uRL == null) {
            string = n > 1 ? this.createURLParam("url", n2, -1) : this.createURLParam("url", -1, n3);
            uRL = (URL)this.urlList.get(string);
        }
        if (uRL == null) {
            uRL = (URL)this.urlList.get(this.createURLParam("url", -1, -1));
        }
        return uRL;
    }

    public void reset() {
        this.urlList = new Hashtable();
        this.urlTargetList = new Hashtable();
        HAND_CURSOR = new Cursor(12);
        POINT_CURSOR = new Cursor(0);
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.theChart.reset();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public ChartApplet() {
        this.theChart = this.createChart(this.getParameter("chartClass"));
        this.overlayChartApplets = new Vector();
        this.setLayout(new BorderLayout());
        String string = this.getParameter("doubleBufferingOff");
        if (string != null && string.equals("true")) {
            this.add("Center", this.theChart);
        } else {
            NonFlickerPanel nonFlickerPanel = new NonFlickerPanel(new BorderLayout());
            nonFlickerPanel.add("Center", this.theChart);
            this.add("Center", nonFlickerPanel);
        }
        this.theChart.addItemListener(this);
        this.theChart.addMouseMotionListener(this);
        this.reset();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ChartSample chartSample = (ChartSample)itemEvent.getItem();
        Chart chart = (Chart)itemEvent.getSource();
        if (itemEvent.getStateChange() == 1 && chartSample != null && chart != null) {
            URL uRL;
            boolean bl;
            int n = chart.getSeriesCount();
            int n2 = chartSample.getIndex();
            int n3 = chartSample.getSeries();
            long l = System.currentTimeMillis();
            boolean bl2 = bl = n2 == this.lastSelectedSample && n3 == this.lastSelectedSeries;
            if (bl && l - this.lastSelectedTime < 350L && (uRL = this.getSampleURL(n, n3, n2)) != null) {
                AppletContext appletContext;
                String string = this.createURLParam("urltarget", n3, n2);
                String string2 = (String)this.urlTargetList.get(string);
                if (string2 == null) {
                    string = n > 1 ? this.createURLParam("urltarget", n3, -1) : this.createURLParam("urltarget", -1, n2);
                    string2 = (String)this.urlTargetList.get(string);
                }
                if (string2 == null) {
                    string2 = (String)this.urlTargetList.get("urltarget");
                }
                if ((appletContext = this.getAppletContext()) != null) {
                    appletContext.showDocument(uRL, string2);
                }
            }
            this.lastSelectedSample = n2;
            this.lastSelectedSeries = n3;
            this.lastSelectedTime = l;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        URL uRL;
        if (this.urlList.size() == 0) {
            return;
        }
        Chart chart = (Chart)mouseEvent.getSource();
        ChartSample chartSample = chart.checkSelection(new Point(mouseEvent.getX(), mouseEvent.getY()));
        int n = chart.getSeriesCount();
        Cursor cursor = POINT_CURSOR;
        if (chartSample != null && (uRL = this.getSampleURL(n, chartSample.getSeries(), chartSample.getIndex())) != null) {
            cursor = HAND_CURSOR;
        }
        this.setCursor(cursor);
    }

    private boolean shouldSet(String string, boolean bl) {
        String string2 = this.getParameter(string);
        return string2 != null && string2.trim().length() > 0 || bl;
    }

    static String convertLineBreaks(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (n2 < cArray.length - 1 && cArray[n2] == '\\' && cArray[n2 + 1] == 'n') {
                cArray2[n++] = 10;
                ++n2;
            } else {
                cArray2[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    private static int getFontType(String string) {
        if ((string = string.toLowerCase().trim()).equals("bold")) {
            return 1;
        }
        if (string.equals("italic")) {
            return 2;
        }
        if (string.equals("bolditalic") || string.equals("italicbold")) {
            return 3;
        }
        return 0;
    }

    public void setParentApplet(Applet applet) {
        if (applet == this) {
            applet = null;
        }
        this.parentApplet = applet;
    }

    protected static Color createColor(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.indexOf(",") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            try {
                return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (Exception exception) {
                System.out.println("Invalid RGB color: " + string);
            }
        } else if (string.startsWith("#")) {
            try {
                return new Color(Integer.parseInt(string.substring(1, 3), 16), Integer.parseInt(string.substring(3, 5), 16), Integer.parseInt(string.substring(5, 7), 16));
            }
            catch (Exception exception) {
                System.out.println("Invalid hex color: " + string);
            }
        } else {
            if ((string = string.toLowerCase()).equals("black")) {
                return Color.black;
            }
            if (string.equals("blue")) {
                return Color.blue;
            }
            if (string.equals("cyan")) {
                return Color.cyan;
            }
            if (string.equals("darkgray")) {
                return Color.darkGray;
            }
            if (string.equals("gray")) {
                return Color.gray;
            }
            if (string.equals("green")) {
                return Color.green;
            }
            if (string.equals("lightgray")) {
                return Color.lightGray;
            }
            if (string.equals("magenta")) {
                return Color.magenta;
            }
            if (string.equals("orange")) {
                return Color.orange;
            }
            if (string.equals("pink")) {
                return Color.pink;
            }
            if (string.equals("red")) {
                return Color.red;
            }
            if (string.equals("white")) {
                return Color.white;
            }
            if (string.equals("yellow")) {
                return Color.yellow;
            }
            System.out.println("Invalid color name: " + string);
        }
        return null;
    }

    protected void setRangeParameters(boolean bl) {
        if (this.shouldSet(this.prefix + "rangeStep", bl)) {
            this.setParameter("rangeStep", this.getParameter(this.prefix + "rangeStep"));
        }
        if (this.shouldSet(this.prefix + "range", bl)) {
            this.setParameter("range", this.getParameter(this.prefix + "range"));
        }
        if (this.shouldSet(this.prefix + "lowerRange", bl)) {
            this.setParameter("lowerRange", this.getParameter(this.prefix + "lowerRange"));
        }
        this.setParameter("rangeOn_2", this.getParameter(this.prefix + "rangeOn_2"));
        if (this.shouldSet(this.prefix + "rangeStep_2", bl)) {
            this.setParameter("rangeStep_2", this.getParameter(this.prefix + "rangeStep_2"));
        }
        if (this.shouldSet(this.prefix + "range_2", bl)) {
            this.setParameter("range_2", this.getParameter(this.prefix + "range_2"));
        }
        if (this.shouldSet(this.prefix + "lowerRange_2", bl)) {
            this.setParameter("lowerRange_2", this.getParameter(this.prefix + "lowerRange_2"));
        }
        this.initParameter("rangeAdjusterOn", this.getParameter(this.prefix + "rangeAdjusterOn"));
        this.initParameter("rangeAdjusterOn_2", this.getParameter(this.prefix + "rangeAdjusterOn_2"));
    }

    public void setParameterPrefix(String string) {
        this.prefix = string != null ? string : "";
    }

    public String getParameterPrefix() {
        return this.prefix;
    }

    protected abstract Chart createChart(String var1);

    public void start() {
        if (this.automaticRefreshTime > 0) {
            this.refreshThread = new Thread(this);
            this.refreshThread.start();
        }
    }

    private void initParameter(String string, String string2) {
        if (string2 != null) {
            this.setParameter(string, string2);
        }
    }

    protected static Double[] getDoubleValues(String string) {
        Double[] doubleArray = null;
        if (string != null && !string.equals("")) {
            boolean bl = string.trim().startsWith(",");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            doubleArray = new Double[stringTokenizer.countTokens() + (bl ? 1 : 0)];
            int n = bl ? 1 : 0;
            while (n < doubleArray.length) {
                try {
                    doubleArray[n] = new Double(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {}
                ++n;
            }
        }
        return doubleArray;
    }

    protected String[] getStringValues(String string) {
        String[] stringArray = null;
        if (string != null) {
            boolean bl = string.trim().startsWith(this.labelDelimiter);
            StringTokenizer stringTokenizer = new StringTokenizer(string, this.labelDelimiter);
            stringArray = new String[stringTokenizer.countTokens() + (bl ? 1 : 0)];
            int n = bl ? 1 : 0;
            while (n < stringArray.length) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        return stringArray;
    }

    public void setParameter(String string, String string2) {
        block325: {
            int n;
            if (string == null || this.theChart == null) {
                return;
            }
            if ((string = string.toLowerCase()).startsWith("series") && string.endsWith("_values")) {
                try {
                    n = Integer.parseInt(string.substring(6, string.indexOf("_values")));
                    string = "sampleValues_" + n;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (string.equals("width")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        n = Integer.parseInt(string2.trim());
                        this.setSize(n, this.theChart.getSize().height);
                        this.theChart.setSize(n, this.theChart.getSize().height);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid width: " + string2);
                    }
                }
            } else if (string.equals("height")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        n = Integer.parseInt(string2.trim());
                        this.setSize(this.theChart.getSize().width, n);
                        this.theChart.setSize(this.theChart.getSize().width, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid height: " + string2);
                    }
                }
            } else if (string.equals("samplevalues")) {
                Double[] doubleArray = ChartApplet.getDoubleValues(string2);
                if (doubleArray != null && string2.trim().length() > 0) {
                    int n2 = this.theChart.getSampleCount();
                    int n3 = 0;
                    while (n3 < n2) {
                        if (n3 < doubleArray.length && doubleArray[n3] != null) {
                            this.theChart.setSampleValue(0, n3, doubleArray[n3]);
                        } else {
                            ChartSample chartSample = this.theChart.getSample(0, n3);
                            if (chartSample != null) {
                                chartSample.clearValue();
                            }
                        }
                        ++n3;
                    }
                }
            } else if (string.equals("samplecount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setSampleCount(Math.max(0, Integer.parseInt(string2.trim())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid sampleCount: " + string2);
                    }
                }
            } else if (string.equals("samplecolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color[] colorArray = this.getColorValues(string2);
                    this.theChart.setSampleColors(colorArray);
                } else {
                    this.theChart.setSampleColors(null);
                }
            } else if (string.equals("legendcolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color[] colorArray = this.getColorValues(string2);
                    this.theChart.setLegendColors(colorArray);
                } else {
                    this.theChart.setLegendColors(null);
                }
            } else if (string.equals("seriescount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setSeriesCount(Math.max(1, Integer.parseInt(string2.trim())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid seriesCount: " + string2);
                    }
                } else {
                    this.theChart.setSeriesCount(1);
                }
            } else if (string.startsWith("samplevalues_")) {
                try {
                    n = Integer.parseInt(string.substring(13));
                    if (n >= 0 && n < this.theChart.getSeriesCount()) {
                        Double[] doubleArray = ChartApplet.getDoubleValues(string2);
                        int n4 = this.theChart.getSampleCount();
                        int n5 = 0;
                        while (n5 < n4) {
                            if (doubleArray != null && n5 < doubleArray.length && doubleArray[n5] != null) {
                                this.theChart.setSampleValue(n, n5, doubleArray[n5]);
                            } else {
                                ChartSample chartSample = this.theChart.getSample(n, n5);
                                if (chartSample != null) {
                                    chartSample.clearValue();
                                }
                            }
                            ++n5;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid series index: " + string2);
                }
            } else if (string.startsWith("seriesrange_")) {
                try {
                    n = Integer.parseInt(string.substring(12));
                    if (n < 0 || n >= this.theChart.getSeriesCount()) break block325;
                    if (string2 != null && string2.length() > 0) {
                        try {
                            int n6 = Integer.parseInt(string2.trim());
                            n6 = n6 == 2 ? 1 : 0;
                            this.theChart.setSeriesRange(n, n6);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid range index: " + string + " " + string2);
                        }
                        break block325;
                    }
                    this.theChart.setSeriesRange(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid series index: " + string + " " + string2);
                }
            } else if (string.startsWith("rangestep")) {
                n = string.equals("rangestep_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.rangeStep[n] = new Double(string2.trim());
                        this.rangeStep[n] = Math.abs(this.rangeStep[n]);
                        this.theChart.setRelativeRange(n, 1.0, this.rangeStep[n]);
                        this.theChart.setLowerRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block325;
                    }
                    this.rangeStep[n] = -1.0;
                    this.theChart.setRelativeRangeIndex(n, 1.0);
                    this.theChart.setLowerRelativeRangeIndex(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid rangeStep: " + string2);
                    this.rangeStep[n] = -1.0;
                    this.theChart.setLowerRelativeRange(1.0);
                }
            } else if (string.equals("range") || string.equals("range_2")) {
                n = string.equals("range_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setRange(n, new Double(string2.trim()));
                        break block325;
                    }
                    if (this.rangeStep[n] > -1.0) {
                        this.theChart.setRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block325;
                    }
                    this.theChart.setRelativeRangeIndex(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid range: " + string2);
                    if (this.rangeStep[n] != -1.0) {
                        this.theChart.setRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block325;
                    }
                    this.theChart.setRelativeRangeIndex(n, 1.0);
                }
            } else if (string.equals("lowerrange") || string.equals("lowerrange_2")) {
                n = string.equals("lowerrange_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setLowerRange(n, new Double(string2.trim()));
                        break block325;
                    }
                    if (this.rangeStep[n] != -1.0) {
                        this.theChart.setLowerRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block325;
                    }
                    this.theChart.setLowerRelativeRangeIndex(n, 1.0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid lowerRange: " + string2);
                    if (this.rangeStep[n] > -1.0) {
                        this.theChart.setLowerRelativeRange(n, 1.0, this.rangeStep[n]);
                        break block325;
                    }
                    this.theChart.setLowerRelativeRangeIndex(n, 1.0);
                }
            } else if (string.startsWith("rangeon")) {
                int n7 = n = string.equals("rangeon_2") ? 1 : 0;
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeOn(n, string2.trim().toLowerCase().equals("true"));
                }
            } else if (string.startsWith("rangecolor")) {
                int n8 = n = string.equals("rangecolor_2") ? 1 : 0;
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setRangeColor(n, ChartApplet.createColor(string2));
                }
            } else if (string.startsWith("rangeposition")) {
                int n9 = n = string.equals("rangeposition_2") ? 1 : 0;
                if (string2 != null && string2.length() > 0) {
                    if ((string2 = string2.trim().toLowerCase()).equals("right") || string2.equals("top")) {
                        this.theChart.setRangePosition(n, 1);
                    } else {
                        this.theChart.setRangePosition(n, 0);
                    }
                }
            } else if (string.startsWith("rangeadjusteron")) {
                n = string.equals("rangeadjusteron_2") ? 1 : 0;
                this.theChart.setRangeAdjusterOn(n, string2.trim().toLowerCase().equals("true"));
            } else if (string.startsWith("rangeadjusterposition")) {
                int n10 = n = string.equals("rangeadjusterposition_2") ? 1 : 0;
                if (string2 != null && string2.length() > 0) {
                    if ((string2 = string2.trim().toLowerCase()).equals("right") || string2.equals("top")) {
                        this.theChart.setRangeAdjusterPosition(n, 1);
                    } else {
                        this.theChart.setRangeAdjusterPosition(n, 0);
                    }
                }
            } else if (string.startsWith("rangeadjusted_")) {
                int n11 = n = string.equals("rangeadjusted_2") ? 1 : 0;
                if (string2 != null && string2.length() > 0) {
                    if (string2.trim().equals("1")) {
                        this.theChart.setRangeAdjusted(n, 0);
                    } else if (string2.trim().equals("2")) {
                        this.theChart.setRangeAdjusted(n, 1);
                    } else {
                        this.theChart.setRangeAdjusted(n, 2);
                    }
                }
            } else if (string.startsWith("rangedecimalcount")) {
                n = string.equals("rangedecimalcount_2") ? 1 : 0;
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setRangeDecimalCount(n, Integer.parseInt(string2.trim()));
                        break block325;
                    }
                    this.theChart.setRangeDecimalCount(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + ": " + string2);
                    this.theChart.setRangeDecimalCount(n, 0);
                }
            } else if (string.equals("labeldelimiter")) {
                this.labelDelimiter = string2 != null && string2.trim().length() > 0 ? string2 : ",";
            } else if (string.equals("serieslabels")) {
                this.theChart.setSeriesLabels(this.getStringValues(ChartApplet.convertLineBreaks(string2)));
            } else if (string.equals("serieslabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n12 = this.theChart.getSeriesCount();
                int n13 = 0;
                while (n13 < n12) {
                    if (colorArray != null && n13 < colorArray.length) {
                        this.theChart.setSeriesLabelColor(n13, colorArray[n13]);
                    } else {
                        this.theChart.setSeriesLabelColor(n13, null);
                    }
                    ++n13;
                }
            } else if (string.equals("samplelabels")) {
                this.theChart.setSampleLabels(this.getStringValues(ChartApplet.convertLineBreaks(string2)));
            } else if (string.equals("samplelabelcolors")) {
                Color[] colorArray = this.getColorValues(string2);
                int n14 = this.theChart.getSampleCount();
                int n15 = 0;
                while (n15 < n14) {
                    if (colorArray != null && n15 < colorArray.length) {
                        this.theChart.setSampleLabelColor(n15, colorArray[n15]);
                    } else {
                        this.theChart.setSampleLabelColor(n15, null);
                    }
                    ++n15;
                }
            } else if (string.equals("legendlabels")) {
                this.theChart.setLegendLabels(null);
                if (string2 != null && string2.trim().length() > 0) {
                    String[] stringArray = this.getStringValues(ChartApplet.convertLineBreaks(string2));
                    if (stringArray.length > 1) {
                        this.theChart.setLegendLabels(stringArray);
                    } else if (stringArray.length == 1 && stringArray[0] != null) {
                        if (stringArray[0].trim().toLowerCase().equals("samplelabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSampleLabels());
                        } else if (stringArray[0].trim().toLowerCase().equals("serieslabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSeriesLabels());
                        } else {
                            this.theChart.setLegendLabels(stringArray);
                        }
                    }
                }
            } else if (string.startsWith("valuelabelson")) {
                if (string.equals("valuelabelson")) {
                    this.theChart.setValueLabelsOn(-1, string2 != null && string2.trim().toLowerCase().equals("true"));
                } else if (string.startsWith("valuelabelson_")) {
                    try {
                        n = Integer.parseInt(string.substring(14));
                        if (n >= 0 && n < this.theChart.getSeriesCount()) {
                            this.theChart.setValueLabelsOn(n, string2 != null && string2.trim().toLowerCase().equals("true"));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid " + string + " " + string2);
                    }
                }
            } else if (string.startsWith("valuelabelprefix") || string.startsWith("valuelabelpostfix")) {
                this.theChart.setLabel(string, ChartApplet.convertLineBreaks(string2));
            } else if (string.startsWith("sampledecimalcount")) {
                try {
                    if (string.equals("sampledecimalcount")) {
                        if (string2 != null && string2.trim().length() > 0) {
                            this.theChart.setSampleDecimalCount(-1, Integer.parseInt(string2.trim()));
                        } else {
                            this.theChart.setSampleDecimalCount(-1, 0);
                        }
                        break block325;
                    }
                    if (!string.startsWith("sampledecimalcount_") || (n = Integer.parseInt(string.substring(19))) < 0 || n >= this.theChart.getSeriesCount()) break block325;
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setSampleDecimalCount(n, Integer.parseInt(string2.trim()));
                        break block325;
                    }
                    this.theChart.setSampleDecimalCount(n, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + " " + string2);
                }
            } else if (string.equals("charttitle") || string.equals("title")) {
                this.theChart.setTitle(ChartApplet.convertLineBreaks(string2));
                this.theChart.setTitleOn(string2 != null && string2.length() > 0);
            } else if (string.equals("legendon")) {
                this.theChart.setLegendOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("legendposition")) {
                this.theChart.setLegendPosition(1);
                if (string2 != null && string2.trim().length() > 0) {
                    if ((string2 = string2.toLowerCase()).equals("right")) {
                        this.theChart.setLegendPosition(1);
                    } else if (string2.equals("top")) {
                        this.theChart.setLegendPosition(2);
                    } else if (string2.equals("bottom")) {
                        this.theChart.setLegendPosition(3);
                    } else if (string2.equals("left")) {
                        this.theChart.setLegendPosition(0);
                    } else {
                        System.out.println("Invalid legendPosition: " + string2);
                    }
                }
            } else if (string.equals("automaticrefreshtime")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.automaticRefreshTime = Math.max(100, Integer.parseInt(string2));
                        break block325;
                    }
                    this.automaticRefreshTime = 3600000;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid automaticRefreshTime: " + string2);
                    this.automaticRefreshTime = 3600000;
                }
            } else if (string.equals("3dmodeon")) {
                this.theChart.set3DModeOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("3ddepth")) {
                this.theChart.set3DDepth(-1);
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        n = Integer.parseInt(string2.trim());
                        this.theChart.set3DDepth(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid 3DDepth: " + string2);
                    }
                }
            } else if (string.equals("foreground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setForeground(color);
                    } else {
                        this.theChart.setForeground(Color.black);
                    }
                } else {
                    this.theChart.setForeground(Color.black);
                }
            } else if (string.equals("background")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setBackground(color);
                    } else {
                        this.theChart.setBackground(new Color(231, 221, 231));
                    }
                } else {
                    this.theChart.setBackground(new Color(231, 221, 231));
                }
            } else if (string.equals("chartforeground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setChartForeground(color);
                    } else {
                        this.theChart.setChartForeground(Color.black);
                    }
                } else {
                    this.theChart.setChartForeground(Color.black);
                }
            } else if (string.equals("chartbackground")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setChartBackground(color);
                    } else {
                        this.theChart.setChartBackground(Color.white);
                    }
                } else {
                    this.theChart.setChartBackground(Color.white);
                }
            } else if (string.equals("titlefont")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont("titleFont", this.createFont(string2, "Dialog", 1, 14));
                } else {
                    this.theChart.setFont("titleFont", new Font("Dialog", 1, 14));
                }
            } else if (string.equals("font")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(new Font("Arial", 0, 11));
                }
            } else if (string.endsWith("font")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setFont(string, this.createFont(string2, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(string, null);
                }
            } else if (string.equals("graphinsets")) {
                if (string2 != null && string2.trim().length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), ",");
                    int n16 = -1;
                    int n17 = -1;
                    int n18 = -1;
                    int n19 = -1;
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n16 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n17 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n18 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n19 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        this.theChart.setGraphInsets(n16, n17, n18, n19);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid graphinsets: " + string2);
                    }
                } else {
                    this.theChart.setGraphInsets(-1, -1, -1, -1);
                }
            } else if (string.startsWith("urltarget")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.urlTargetList.put(string, string2);
                } else if (string.equals("urltarget")) {
                    this.urlTargetList.put(string, "_self");
                } else {
                    this.urlTargetList.remove(string);
                }
            } else if (string.startsWith("url")) {
                if (string2 != null && string2.trim().length() > 0) {
                    URL uRL = this.createURL(string2);
                    if (uRL != null) {
                        this.urlList.put(string, uRL);
                    } else {
                        this.urlList.remove(string);
                    }
                } else {
                    this.urlList.remove(string);
                }
            } else if (string.equals("sample_urltarget")) {
                System.out.println(string + " is deprecated, use urltarget");
                this.setParameter("urltarget", string2);
            } else if (string.startsWith("sample") && string.endsWith("_urltarget")) {
                System.out.println(string + " is deprecated, use urltarget_N_M");
                String string3 = string.substring(6, string.indexOf("_urltarget"));
                this.setParameter("urltarget_" + string3, string2);
            } else if (string.startsWith("sample") && string.endsWith("_url")) {
                System.out.println(string + " is deprecated, use url_N_M");
                String string4 = string.substring(6, string.indexOf("_url"));
                this.setParameter("url_" + string4, string2);
            } else if (string.equals("valuelineson")) {
                this.theChart.setValueLinesOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("maxvaluelinecount")) {
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.theChart.setMaxValueLineCount(Integer.parseInt(string2.trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid maxValueLineCount: " + string2);
                        this.theChart.setMaxValueLineCount(-1);
                    }
                } else {
                    this.theChart.setMaxValueLineCount(-1);
                }
            } else if (string.equals("gridlineson")) {
                this.theChart.setGridLinesOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("gridlines")) {
                Double[] doubleArray;
                this.theChart.setGridLines(null);
                if (string2 != null && (doubleArray = ChartApplet.getDoubleValues(string2)) != null) {
                    double[] dArray = new double[doubleArray.length];
                    int n20 = 0;
                    while (n20 < doubleArray.length) {
                        if (doubleArray[n20] != null) {
                            dArray[n20] = doubleArray[n20];
                        }
                        ++n20;
                    }
                    this.theChart.setGridLines(dArray);
                }
            } else if (string.equals("gridcolor")) {
                Color[] colorArray;
                this.theChart.setGridColor(null);
                if (string2 != null && string2.trim().length() > 0 && (colorArray = this.getColorValues(string2)) != null && colorArray.length > 0 && colorArray[0] != null) {
                    this.theChart.setGridColor(colorArray[0]);
                }
            } else if (string.equals("gridlinecolors")) {
                if (string2 != null && string2.trim().length() > 0) {
                    this.theChart.setGridLineColors(this.getColorValues(string2));
                } else {
                    this.theChart.setGridLineColors(null);
                }
            } else if (string.equals("valuelinescolor")) {
                if (string2 != null && string2.trim().length() > 0) {
                    Color color = ChartApplet.createColor(string2);
                    if (color != null) {
                        this.theChart.setValueLinesColor(color);
                    } else {
                        this.theChart.setValueLinesColor(Color.lightGray);
                    }
                } else {
                    this.theChart.setValueLinesColor(Color.lightGray);
                }
            } else if (string.equals("sampleaxisrange")) {
                Double[] doubleArray;
                this.theChart.setSampleAxisRange(0.0, 100.0);
                if (string2 != null && string2.trim().length() > 0 && (doubleArray = ChartApplet.getDoubleValues(string2)).length >= 2) {
                    this.theChart.setSampleAxisRange(doubleArray[0] != null ? doubleArray[0] : 0.0, doubleArray[1] != null ? doubleArray[1] : 100.0);
                }
            } else if (string.equals("rangelabelsoff")) {
                this.theChart.setRangeLabelsOn(string2 == null || !string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("sampleaxislabel") || string.equals("rangeaxislabel") || string.equals("rangeaxislabel_2")) {
                this.theChart.setLabel(string, ChartApplet.convertLineBreaks(string2));
            } else if (string.equals("rangelabelprefix") || string.equals("rangelabelpostfix")) {
                this.theChart.setLabel(string, ChartApplet.convertLineBreaks(string2));
            } else if (string.endsWith("angle") || string.equals("rangeaxislabelangle_2")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.theChart.setLabelAngle(string, Integer.parseInt(string2));
                        break block325;
                    }
                    this.theChart.setLabelAngle(string, 0);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid " + string + ": " + string2);
                }
            } else if (string.startsWith("targetvalueline")) {
                if (this.targets.containsKey(string)) {
                    String string5 = (String)this.targets.remove(string);
                    this.theChart.setTargetValueLine(string5, 0.0, null, 0);
                }
                if (string2 != null && string2.length() > 0) {
                    String string6;
                    Object object;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, this.labelDelimiter);
                    String string7 = null;
                    if (stringTokenizer.hasMoreElements()) {
                        string7 = (String)stringTokenizer.nextElement();
                    }
                    double d = 0.0;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            object = (String)stringTokenizer.nextElement();
                            d = new Double(((String)object).trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid targetValueLine value: " + string2);
                        }
                    }
                    object = this.theChart.getValueLinesColor();
                    if (stringTokenizer.hasMoreElements() && (object = ChartApplet.createColor((string6 = (String)stringTokenizer.nextElement()).trim())) == null) {
                        object = this.theChart.getValueLinesColor();
                    }
                    int n21 = 3;
                    if (stringTokenizer.hasMoreElements()) {
                        String string8 = ((String)stringTokenizer.nextElement()).trim();
                        n21 = string8.equals("label") ? 1 : (string8.equals("value") ? 2 : 3);
                    }
                    if (string7 != null) {
                        this.targets.put(string, string7);
                        this.theChart.setTargetValueLine(string7, d, (Color)object, n21);
                    }
                }
            } else if (string.equals("samplescrolleron")) {
                this.theChart.setSampleScrollerOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("visiblesamples")) {
                if (string2 != null && string2.length() > 0) {
                    n = 0;
                    int n22 = -1;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            n22 = Integer.parseInt(((String)stringTokenizer.nextElement()).trim());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid visibleSamples: " + string2);
                    }
                    this.theChart.setVisibleSamples(n, n22);
                } else {
                    this.theChart.setVisibleSamples(0, -1);
                }
            } else if (!string.equals("chart")) {
                if (string.startsWith("overlay")) {
                    if (string2 != null && string2.trim().length() > 0) {
                        string2 = string2.trim().toLowerCase();
                        ChartApplet chartApplet = null;
                        if (string2.equals("line")) {
                            chartApplet = new LineChartApplet();
                        } else if (string2.equals("bar")) {
                            chartApplet = new BarChartApplet();
                        } else if (string2.equals("pie")) {
                            chartApplet = new PieChartApplet();
                        } else {
                            System.out.println("invalid " + string + " " + string2);
                        }
                        if (chartApplet != null) {
                            chartApplet.setParentApplet(this);
                            chartApplet.setParameterPrefix(string + "_");
                            chartApplet.init();
                            this.overlayChartApplets.addElement(chartApplet);
                            this.theChart.addOverlayChart(chartApplet.theChart);
                        }
                    }
                } else {
                    if (string.startsWith("legendimage_")) {
                        try {
                            try {
                                Image image;
                                n = Integer.parseInt(string.substring(string.indexOf("_") + 1));
                                this.theChart.setLegendImage(n, null);
                                if (string2 != null && string2.trim().length() > 0 && (image = this.getImage(this.getDocumentBase(), string2)) != null) {
                                    this.theChart.addImage(string, image);
                                    this.theChart.setLegendImage(n, string);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Invalid legend index: " + string);
                            }
                            catch (SecurityException securityException) {
                                System.out.println("Security exception, could not load image: " + string2);
                            }
                            Object var11_52 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_53 = null;
                            throw throwable;
                        }
                    }
                    if (string.startsWith("printasbitmap")) {
                        this.theChart.setPrintAsBitmap(string2 != null && string2.trim().toLowerCase().equals("true"));
                    } else if (string.equals("floatingonlegendoff")) {
                        this.theChart.setFloatingOnLegendOn(string2 == null || !string2.trim().equalsIgnoreCase("true"));
                    } else {
                        System.out.println("Invalid parameter name: " + string);
                    }
                }
            }
        }
    }

    public String getParameter(String string) {
        String string2 = null;
        if (this.parentApplet != null) {
            string2 = this.parentApplet.getParameter(string);
        } else {
            try {
                string2 = super.getParameter(string);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return string2;
    }

    private URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL2 = this.getDocumentBase();
            if (uRL2 == null) {
                return null;
            }
            String string2 = uRL2.toExternalForm();
            int n = string2.lastIndexOf("?");
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            if (!string2.endsWith("/")) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            }
            if (string2.startsWith("file:/\\")) {
                string2 = "file://" + string2.substring(8);
            }
            try {
                uRL = new URL(string2 + string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Invalid URL: " + string2);
            }
        }
        return uRL;
    }

    protected void refresh() {
    }

    public void run() {
        try {
            Thread.sleep((int)Math.random() * 1000);
            while (true) {
                Thread.sleep(this.automaticRefreshTime);
                this.refresh();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void init() {
        int n;
        String string;
        if (this.theChart == null) {
            return;
        }
        this.theChart.setAutomaticRepaintOn(false);
        int n2 = 1;
        int n3 = 0;
        Double[] doubleArray = ChartApplet.getDoubleValues(this.getParameter(this.prefix + "sampleValues"));
        if (doubleArray != null) {
            n3 = doubleArray.length;
            string = this.getParameter(this.prefix + "sampleCount");
            if (string != null) {
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid sampleCount: " + string);
                }
            }
            this.theChart.setSeriesCount(n2);
            this.theChart.setSampleCount(n3);
            this.initParameter("sampleValues", this.getParameter(this.prefix + "sampleValues"));
        }
        if (doubleArray == null) {
            string = this.getParameter(this.prefix + "seriesCount");
            if (string != null) {
                try {
                    n2 = Math.max(1, Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid seriesCount: " + string);
                }
            }
            if ((string = this.getParameter(this.prefix + "sampleCount")) != null) {
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid sampleCount: " + string);
                }
            } else {
                n = 0;
                while (n < n2) {
                    doubleArray = ChartApplet.getDoubleValues(this.getParameter(this.prefix + "sampleValues_" + n));
                    if (doubleArray == null) {
                        doubleArray = ChartApplet.getDoubleValues(this.getParameter(this.prefix + "series" + n + "_values"));
                    }
                    if (doubleArray != null) {
                        n3 = Math.max(n3, doubleArray.length);
                    }
                    ++n;
                }
            }
            this.theChart.setSeriesCount(n2);
            this.theChart.setSampleCount(n3);
            n = 0;
            while (n < n2) {
                String string2 = this.getParameter(this.prefix + "sampleValues_" + n);
                if (string2 == null) {
                    string2 = this.getParameter(this.prefix + "series" + n + "_values");
                }
                this.initParameter("sampleValues_" + n, string2);
                ++n;
            }
        }
        if ((string = this.getParameter(this.prefix + "chartTitle")) != null && string.trim().length() > 0) {
            this.initParameter("chartTitle", string);
        } else {
            this.initParameter("chartTitle", this.getParameter(this.prefix + "title"));
        }
        this.initParameter("sampleColors", this.getParameter(this.prefix + "sampleColors"));
        this.initParameter("legendColors", this.getParameter(this.prefix + "legendColors"));
        this.initParameter("valueLabelsOn", this.getParameter(this.prefix + "valueLabelsOn"));
        this.initParameter("legendOn", this.getParameter(this.prefix + "legendOn"));
        this.initParameter("labelDelimiter", this.getParameter(this.prefix + "labelDelimiter"));
        this.initParameter("sampleLabels", this.getParameter(this.prefix + "sampleLabels"));
        this.initParameter("seriesLabels", this.getParameter(this.prefix + "seriesLabels"));
        this.initParameter("sampleLabelColors", this.getParameter(this.prefix + "sampleLabelColors"));
        this.initParameter("seriesLabelColors", this.getParameter(this.prefix + "seriesLabelColors"));
        this.initParameter("legendPosition", this.getParameter(this.prefix + "legendPosition"));
        this.initParameter("automaticRefreshTime", this.getParameter(this.prefix + "automaticRefreshTime"));
        this.initParameter("background", this.getParameter(this.prefix + "background"));
        this.initParameter("foreground", this.getParameter(this.prefix + "foreground"));
        this.initParameter("chartBackground", this.getParameter(this.prefix + "chartBackground"));
        this.initParameter("chartForeground", this.getParameter(this.prefix + "chartForeground"));
        this.initParameter("titleFont", this.getParameter(this.prefix + "titleFont"));
        this.initParameter("font", this.getParameter(this.prefix + "font"));
        this.initParameter("legendFont", this.getParameter(this.prefix + "legendFont"));
        this.initParameter("3DModeOn", this.getParameter(this.prefix + "3DModeOn"));
        this.initParameter("3DDepth", this.getParameter(this.prefix + "3DDepth"));
        this.initParameter("legendLabels", this.getParameter(this.prefix + "legendLabels"));
        this.initParameter("graphInsets", this.getParameter(this.prefix + "graphInsets"));
        this.initParameter("rangeDecimalCount", this.getParameter(this.prefix + "rangeDecimalCount"));
        this.initParameter("rangeDecimalCount_2", this.getParameter(this.prefix + "rangeDecimalCount_2"));
        this.initParameter("valueLinesOn", this.getParameter(this.prefix + "valueLinesOn"));
        this.initParameter("gridLinesOn", this.getParameter(this.prefix + "gridLinesOn"));
        this.initParameter("maxValueLineCount", this.getParameter(this.prefix + "maxValueLineCount"));
        this.initParameter("gridLines", this.getParameter(this.prefix + "gridLines"));
        this.initParameter("gridColor", this.getParameter(this.prefix + "gridColor"));
        this.initParameter("gridLineColors", this.getParameter(this.prefix + "gridLineColors"));
        this.initParameter("valueLinesColor", this.getParameter(this.prefix + "valueLinesColor"));
        this.initParameter("rangeLabelsOff", this.getParameter(this.prefix + "rangeLabelsOff"));
        this.initParameter("rangeLabelFont", this.getParameter(this.prefix + "rangeLabelFont"));
        this.initParameter("rangeLabelPrefix", this.getParameter(this.prefix + "rangeLabelPrefix"));
        this.initParameter("rangeLabelPostfix", this.getParameter(this.prefix + "rangeLabelPostfix"));
        this.initParameter("sampleAxisRange", this.getParameter(this.prefix + "sampleAxisRange"));
        this.initParameter("sampleAxisLabel", this.getParameter(this.prefix + "sampleAxisLabel"));
        this.initParameter("rangeAxisLabel", this.getParameter(this.prefix + "rangeAxisLabel"));
        this.initParameter("rangeAxisLabel_2", this.getParameter(this.prefix + "rangeAxisLabel_2"));
        this.initParameter("sampleAxisLabelFont", this.getParameter(this.prefix + "sampleAxisLabelFont"));
        this.initParameter("rangeAxisLabelFont", this.getParameter(this.prefix + "rangeAxisLabelFont"));
        this.initParameter("visibleSamples", this.getParameter(this.prefix + "visibleSamples"));
        this.initParameter("rangeAxisLabelAngle", this.getParameter(this.prefix + "rangeAxisLabelAngle"));
        this.initParameter("rangeAxisLabelAngle_2", this.getParameter(this.prefix + "rangeAxisLabelAngle_2"));
        this.initParameter("sampleAxisLabelAngle", this.getParameter(this.prefix + "sampleAxisLabelAngle"));
        this.initParameter("valueLabelAngle", this.getParameter(this.prefix + "valueLabelAngle"));
        this.initParameter("barLabelAngle", this.getParameter(this.prefix + "barLabelAngle"));
        this.initParameter("sampleLabelAngle", this.getParameter(this.prefix + "sampleLabelAngle"));
        this.initParameter("rangePosition", this.getParameter(this.prefix + "rangePosition"));
        this.initParameter("rangePosition_2", this.getParameter(this.prefix + "rangePosition_2"));
        this.initParameter("rangeAdjusterPosition", this.getParameter(this.prefix + "rangeAdjusterPosition"));
        this.initParameter("rangeAdjusterPosition_2", this.getParameter(this.prefix + "rangeAdjusterPosition_2"));
        this.initParameter("rangeColor", this.getParameter(this.prefix + "rangeColor"));
        this.initParameter("rangeColor_2", this.getParameter(this.prefix + "rangeColor_2"));
        this.initParameter("rangeAdjusted_1", this.getParameter(this.prefix + "rangeAdjusted_1"));
        this.initParameter("rangeAdjusted_2", this.getParameter(this.prefix + "rangeAdjusted_2"));
        this.initParameter("sampleDecimalCount", this.getParameter(this.prefix + "sampleDecimalCount"));
        this.initParameter("valueLabelPrefix", this.getParameter(this.prefix + "valueLabelPrefix"));
        this.initParameter("valueLabelPostfix", this.getParameter(this.prefix + "valueLabelPostfix"));
        this.initParameter("printAsBitmap", this.getParameter(this.prefix + "printAsBitmap"));
        this.initParameter("floatingLabelFont", this.getParameter(this.prefix + "floatingLabelFont"));
        this.initParameter("floatingOnLegendOff", this.getParameter(this.prefix + "floatingOnLegendOff"));
        n = 0;
        while (n < n2) {
            this.initParameter("valueLabelPrefix_" + n, this.getParameter(this.prefix + "valueLabelPrefix_" + n));
            this.initParameter("valueLabelPostfix_" + n, this.getParameter(this.prefix + "valueLabelPostfix_" + n));
            this.initParameter("seriesRange_" + n, this.getParameter(this.prefix + "seriesRange_" + n));
            this.initParameter("valueLabelsOn_" + n, this.getParameter(this.prefix + "valueLabelsOn_" + n));
            this.initParameter("sampleDecimalCount_" + n, this.getParameter(this.prefix + "sampleDecimalCount_" + n));
            ++n;
        }
        this.initParameter("urltarget", this.getParameter(this.prefix + "sample_urltarget"));
        n = 0;
        while (n < n3) {
            this.initParameter("url_" + n, this.getParameter(this.prefix + "sample" + n + "_url"));
            this.initParameter("urltarget_" + n, this.getParameter(this.prefix + "sample" + n + "_urltarget"));
            ++n;
        }
        this.initParameter("url", this.getParameter(this.prefix + "url"));
        this.setParameter("urltarget", "_self");
        this.initParameter("urltarget", this.getParameter(this.prefix + "urltarget"));
        n = Math.max(n2, n3);
        int n4 = 0;
        while (n4 < n) {
            this.initParameter("url_" + n4, this.getParameter(this.prefix + "url_" + n4));
            this.initParameter("urltarget_" + n4, this.getParameter(this.prefix + "urltarget_" + n4));
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                String string3 = "url_" + n4 + "_" + n5;
                this.initParameter(string3, this.getParameter(this.prefix + string3));
                string3 = "urltarget_" + n4 + "_" + n5;
                this.initParameter(string3, this.getParameter(this.prefix + string3));
                ++n5;
            }
            ++n4;
        }
        n = 0;
        this.targets = new Hashtable();
        String string4 = this.getParameter(this.prefix + "targetValueLine_0");
        while (string4 != null && string4.length() > 0) {
            this.initParameter("targetValueLine_" + n, string4);
            string4 = this.getParameter(this.prefix + "targetValueLine_" + ++n);
        }
        String[] stringArray = this.theChart.getLegendLabels();
        if (stringArray != null) {
            int n6 = 0;
            while (n6 < stringArray.length) {
                String string5 = this.getParameter(this.prefix + "legendImage_" + n6);
                this.initParameter("legendImage_" + n6, string5);
                ++n6;
            }
        }
        this.theChart.setAutomaticRepaintOn(true);
    }

    protected Font createFont(String string, String string2, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string3 = string2;
        int n3 = Math.max(0, n2);
        int n4 = n;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            n4 = ChartApplet.getFontType(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 12;
            }
        }
        return new Font(string3, n4, n3);
    }

    public void print(Graphics graphics) {
        this.theChart.print(graphics);
    }

    private String createURLParam(String string, int n, int n2) {
        String string2 = string;
        if (n >= 0) {
            string2 = string2 + "_" + n;
        }
        if (n2 >= 0) {
            string2 = string2 + "_" + n2;
        }
        return string2;
    }

    protected void init(Chart chart) {
        this.theChart = chart;
        this.init();
    }

    protected void setParameter(Chart chart, String string, String string2) {
        this.theChart = chart;
        this.setParameter(string, string2);
    }
}

