/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart2;
import com.objectplanet.chart.ChartData;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Chart
extends Component
implements ItemSelectable,
Runnable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    static final int BELOW = 0;
    static final int FLOATING = 1;
    static final int BELOW_AND_FLOATING = 2;
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    protected ChartData chartData;
    protected Vector overlayCharts;
    private Color[] sampleColors;
    private Color[] sampleLabelColors;
    private Color[] seriesLabelColors;
    private String chartTitle;
    private boolean chartTitleOn;
    private int[] sampleDecimalCount;
    private boolean legendOn;
    private int legendPosition;
    private boolean[] valueLabelsOn;
    private boolean display3dOn;
    private Color chartBackground;
    private Color chartForeground;
    private Hashtable labels;
    private Hashtable labelFonts;
    private Hashtable labelAngles;
    String[] legendLabels;
    private Color[] legendColors;
    private String[] legendImages;
    private boolean automaticRepaintOn;
    private Insets graphInsets;
    private Dimension preferredSize;
    private int lastSelectedSample;
    private int lastSelectedSeries;
    boolean multiSeriesOn;
    int barLabelStyle;
    private boolean printAsBitmap;
    Hashtable images;
    private boolean overlayChartOn;
    private boolean servletModeOn;
    private boolean floatingOnLegendOn;
    boolean[] rangeOn;
    double[] upperRange;
    double[] lowerRange;
    double[] currentUpperRange;
    double[] currentLowerRange;
    double leftSampleAxisRange;
    double rightSampleAxisRange;
    int[] rangePosition;
    Color[] rangeColor;
    int[] seriesRange;
    boolean valueLinesOn;
    boolean gridLinesOn;
    int maxValueLineCount;
    int maxGridLineCount;
    double[] gridLines;
    Color valueLinesColor;
    Color[] gridLineColors;
    boolean rangeLabelsOn;
    int[] rangeDecimalCount;
    boolean sampleLabelsOn;
    Hashtable targetsLabel;
    Hashtable targetsValue;
    Hashtable targetsColor;
    Hashtable targetsStyle;
    int[] zeroLine;
    Point depth3dPoint;
    int depth3d;
    int gridAlignment;
    static final double[] STEPS = new double[]{1.0, 2.0, 2.5, 5.0};
    static final float ANGLE = 1.25f;
    static final float DEPTH = 0.75f;
    Rectangle currentBounds;
    String[] barLabels;
    boolean[] rangeAdjusterOn;
    int[] rangeAdjusterPosition;
    int[] rangeAdjusted;
    boolean adjustingUpper;
    boolean adjustingLower;
    boolean slidingAdjuster;
    int adjusterIndex;
    int lastAdjusterClick;
    Rectangle[] rangeAdjusterBounds;
    static Cursor RESIZE_CURSOR;
    static Cursor RESIZE_HOR_CURSOR;
    static Cursor MOVE_CURSOR;
    static Cursor DEFAULT_CURSOR;
    boolean sampleScrollerOn;
    boolean leftPushed;
    boolean rightPushed;
    boolean adjustingLeft;
    boolean adjustingRight;
    boolean slidingScroller;
    boolean insideLeftButton;
    boolean insideRightButton;
    int lastScrollerClick;
    double leftScrollerFactor;
    double rightScrollerFactor;
    int leftAdjusterPos;
    int rightAdjusterPos;
    int sampleScrollerSpace;
    Thread scrollerThread;
    Rectangle sampleScrollerBounds;
    Rectangle chartDataBounds;
    String chartType;
    Chart parentChart;
    private ChartSample selectedSample;
    Rectangle[] legendBounds;
    boolean[] legendSelection;
    private Vector listeners;
    private NumberFormat numberFormatter;
    boolean hasChanged;
    Rectangle legend;
    private long lastClickTime;
    private Image rotateImage;
    private Image rotateImageBackground;
    private Hashtable angledLabelCache;
    private Hashtable labelSizeCache;
    double[] valueLines;
    Image offscreen;
    Graphics og;
    private long lastRenderTime;
    private boolean colorDepth;
    long chartColorDepth;
    private static final int DOUBLE_CLICK_TIME = 350;
    MediaTracker imageTracker;
    boolean externalGraphicsOn;
    private static Color[] DEFAULT_SAMPLE_COLORS;

    public boolean isValueLinesOn() {
        return this.valueLinesOn;
    }

    public void setGridLinesOn(boolean bl) {
        this.gridLinesOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setRangeLabelsOn(boolean bl) {
        this.rangeLabelsOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Image createImage(int n, int n2) {
        Image image = super.createImage(n = Math.max(1, n), n2 = Math.max(1, n2));
        if (image == null) {
            Frame frame = new Frame();
            frame.addNotify();
            image = frame.createImage(n, n2);
            frame.dispose();
        }
        return image;
    }

    private int[] rotateImage(int[] nArray, int n, Dimension dimension, int n2) {
        if (n % 360 == 0) {
            return nArray;
        }
        if (n % 360 == 90) {
            int[] nArray2 = new int[nArray.length];
            int n3 = 0;
            while (n3 < dimension.height) {
                int n4 = 0;
                while (n4 < dimension.width) {
                    nArray2[n4 * dimension.height + n3] = nArray[dimension.width * dimension.height - dimension.width - n3 * dimension.width + n4];
                    ++n4;
                }
                ++n3;
            }
            n3 = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n3;
            return nArray2;
        }
        if (n % 360 == 180) {
            int[] nArray3 = new int[nArray.length];
            int n5 = 0;
            while (n5 < dimension.width) {
                int n6 = 0;
                while (n6 < dimension.height) {
                    nArray3[n6 * dimension.width + n5] = nArray[dimension.width * dimension.height - 1 - n6 * dimension.width - n5];
                    ++n6;
                }
                ++n5;
            }
            return nArray3;
        }
        if (n % 360 == 270) {
            int[] nArray4 = new int[nArray.length];
            int n7 = 0;
            while (n7 < dimension.height) {
                int n8 = 0;
                while (n8 < dimension.width) {
                    nArray4[n8 * dimension.height + n7] = nArray[n7 * dimension.width + dimension.width - n8 - 1];
                    ++n8;
                }
                ++n7;
            }
            n7 = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n7;
            return nArray4;
        }
        n = -n;
        double d = Math.sin((double)n * (Math.PI / 180));
        double d2 = Math.cos((double)n * (Math.PI / 180));
        double[] dArray = new double[2];
        Rectangle rectangle = new Rectangle(dimension);
        this.getAngledBounds(d2, d, rectangle, dArray);
        int n9 = -rectangle.x;
        int n10 = -rectangle.y;
        int[] nArray5 = new int[rectangle.width * rectangle.height];
        int[] nArray6 = new int[rectangle.width];
        int n11 = 0;
        while (n11 < rectangle.height) {
            this.itransform(d2, d, 0 - n9, n11 - n10, dArray);
            double d3 = dArray[0];
            double d4 = dArray[1];
            this.itransform(d2, d, rectangle.width - n9, n11 - n10, dArray);
            double d5 = dArray[0];
            double d6 = dArray[1];
            double d7 = (d5 - d3) / (double)rectangle.width;
            double d8 = (d6 - d4) / (double)rectangle.width;
            int n12 = 0;
            while (n12 < rectangle.width) {
                int n13 = (int)Math.round(d3);
                int n14 = (int)Math.round(d4);
                nArray6[n12] = n13 < 0 || n14 < 0 || n13 >= dimension.width || n14 >= dimension.height ? n2 & 0xFFFFFF : nArray[n14 * dimension.width + n13];
                d3 += d7;
                d4 += d8;
                ++n12;
            }
            System.arraycopy(nArray6, 0, nArray5, n11 * rectangle.width, nArray6.length);
            ++n11;
        }
        dimension.width = rectangle.width;
        dimension.height = rectangle.height;
        return nArray5;
    }

    public void setTargetValueLine(String string, double d, Color color, int n) {
        if (color == null) {
            this.targetsLabel.remove(string);
            this.targetsValue.remove(string);
            this.targetsColor.remove(string);
            this.targetsStyle.remove(string);
        } else {
            this.targetsLabel.put(string, string);
            this.targetsValue.put(string, new Double(d));
            this.targetsColor.put(string, color);
            this.targetsStyle.put(string, new Integer(n));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getTargetValueLine(String string) {
        if (this.targetsValue.get(string) != null) {
            return (Double)this.targetsValue.get(string);
        }
        return 0.0;
    }

    public void setLegendLabels(String[] stringArray) {
        this.legendLabels = stringArray != null ? stringArray : null;
        this.checkDataIntegrity();
        this.labelSizeCache.clear();
        this.hasChanged = true;
        this.autoRepaint();
    }

    public String[] getLegendLabels() {
        if (this.legendLabels != null) {
            return this.legendLabels;
        }
        if (this.getSeriesCount() == 1) {
            return this.getSampleLabels();
        }
        return this.getSeriesLabels();
    }

    private void getColorPixels(Color[] colorArray, int[] nArray) {
        colorArray[0] = Color.white;
        if (colorArray[0].equals(colorArray[1])) {
            colorArray[0] = Color.black;
        }
        if (this.rotateImageBackground == null) {
            this.rotateImageBackground = this.createImage(2, 1);
        }
        if (this.rotateImageBackground != null) {
            Graphics graphics = this.rotateImageBackground.getGraphics();
            graphics.setColor(colorArray[0]);
            graphics.drawLine(0, 0, 0, 0);
            graphics.setColor(colorArray[1]);
            graphics.drawLine(1, 0, 1, 0);
            PixelGrabber pixelGrabber = new PixelGrabber(this.rotateImageBackground, 0, 0, 2, 1, nArray, 0, 2);
            pixelGrabber.startGrabbing();
            pixelGrabber.getPixels();
            if (nArray[0] == nArray[1]) {
                colorArray[0] = new Color(0x7FFFFF);
            }
            graphics.dispose();
        }
    }

    public synchronized void setLowerRange(int n, double d) {
        n = Math.max(0, Math.min(1, n));
        this.lowerRange[n] = d;
        this.currentLowerRange[n] = Math.max(this.currentLowerRange[n], d);
        if (!this.rangeAdjusterOn[n]) {
            this.currentLowerRange[n] = d;
        }
        int n2 = 0;
        while (n2 < this.overlayCharts.size()) {
            ((Chart)this.overlayCharts.elementAt(n2)).setLowerRange(n, d);
            ++n2;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized double getLowerRange(int n) {
        return (long)this.lowerRange[Math.max(0, Math.min(1, n))];
    }

    public void setSeriesRange(int n, int n2) {
        if (n >= 0 && n < this.getSeriesCount()) {
            this.seriesRange[n] = Math.max(0, Math.min(this.rangeOn.length - 1, n2));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getSeriesRange(int n) {
        if (n >= 0 && n < this.getSeriesCount()) {
            return this.seriesRange[n];
        }
        return 0;
    }

    public boolean is3DModeOn() {
        return this.display3dOn;
    }

    boolean isServletModeOn() {
        return this.servletModeOn;
    }

    public synchronized void setLowerRange(double d) {
        this.setLowerRange(0, d);
    }

    public void setChartForeground(Color color) {
        this.chartForeground = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setGridColor(Color color) {
        if (this.gridLines != null) {
            Color[] colorArray = new Color[this.gridLines.length];
            int n = 0;
            while (n < this.gridLines.length) {
                colorArray[n] = color;
                ++n;
            }
            this.setGridLineColors(colorArray);
        }
    }

    public void setGridLineColor(int n, Color color) {
        if (n >= this.maxGridLineCount || n < 0) {
            throw new IllegalArgumentException("Illegal vertical grid line index: " + n);
        }
        if (this.gridLineColors == null) {
            this.gridLineColors = new Color[n + 1];
        }
        if (n >= this.gridLineColors.length) {
            Color[] colorArray = new Color[n + 1];
            System.arraycopy(this.gridLineColors, 0, colorArray, 0, this.gridLineColors.length);
            this.gridLineColors = colorArray;
        }
        this.gridLineColors[n] = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getGridLineColor(int n) {
        if (this.gridLineColors == null || n >= this.gridLineColors.length) {
            return this.getValueLinesColor();
        }
        return this.gridLineColors[n];
    }

    public Color getChartForeground() {
        return this.chartForeground;
    }

    public synchronized long getLowerRange() {
        return (long)this.getLowerRange(0);
    }

    public void autoRepaint() {
        if (this.automaticRepaintOn) {
            this.repaint();
        }
    }

    public void set3DDepth(int n) {
        if (n >= -1 && n < Short.MAX_VALUE) {
            this.depth3d = n;
            if (n >= 0) {
                this.depth3dPoint.x = this.depth3d;
                this.depth3dPoint.y = -this.depth3d;
            }
            this.hasChanged = true;
            this.autoRepaint();
        }
    }

    public int get3DDepth() {
        return this.depth3d;
    }

    private void paintRange(Graphics graphics, Rectangle rectangle, int n) {
        String string;
        Object object;
        String string2;
        double d;
        int n2;
        double d2;
        if (!this.rangeOn[n = Math.max(0, Math.min(1, n))]) {
            return;
        }
        String string3 = this.getLabel("rangeLabelPrefix");
        String string4 = this.getLabel("rangeLabelPostfix");
        graphics.setFont(this.getFont("rangeLabelFont"));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = 0;
        if (this.gridAlignment == 1) {
            n3 = (int)Math.round((double)rectangle.height / (double)fontMetrics.getHeight());
        } else {
            String string5 = this.formatNumber(this.upperRange[n], this.rangeDecimalCount[n]);
            String string6 = this.formatNumber(this.lowerRange[n], this.rangeDecimalCount[n]);
            if (string3 != null && string3.length() > 0) {
                string5 = string3 + string5;
                string6 = string3 + string6;
            }
            if (string4 != null && string4.length() > 0) {
                string5 = string5 + string4;
                string6 = string6 + string4;
            }
            int n4 = Math.max(fontMetrics.stringWidth(string5), fontMetrics.stringWidth(string6)) + 4;
            n3 = (int)Math.round((double)rectangle.width / (double)n4);
        }
        n3 = Math.min(this.maxValueLineCount, n3);
        int n5 = (int)Math.round((this.currentUpperRange[n] - this.currentLowerRange[n]) * Math.pow(10.0, this.rangeDecimalCount[n]));
        n3 = Math.min(n3, n5);
        n3 = Math.max(1, n3);
        double d3 = d2 = (this.currentUpperRange[n] - this.currentLowerRange[n]) / (double)n3;
        boolean bl = false;
        double d4 = 1.0E-12;
        while (!bl && d4 < 1.0E14) {
            n2 = 0;
            while (n2 < STEPS.length) {
                if (STEPS[n2] * d4 >= d2) {
                    d3 = STEPS[n2] * d4;
                    bl = true;
                    break;
                }
                ++n2;
            }
            d4 *= 10.0;
        }
        n2 = 0;
        if (n == 1 && Math.round(d3) >= 1L) {
            this.valueLines = new double[(int)((this.currentUpperRange[1] - this.currentLowerRange[1]) / d3) + 2];
        }
        Color color = this.getRangeColor(n);
        if (this.currentUpperRange[n] > 0.0) {
            d = Math.max(0.0, this.currentLowerRange[n] - this.currentLowerRange[n] % d3);
            while (d < this.currentUpperRange[n]) {
                if (d != 0.0) {
                    String string7 = string2 = this.rangeLabelsOn || n > 0 ? this.formatNumber(d, this.rangeDecimalCount[n]) : null;
                    if (n == 0) {
                        if (string2 != null && string3 != null) {
                            string2 = string3 + string2;
                        }
                        if (string2 != null && string4 != null) {
                            string2 = string2 + string4;
                        }
                    }
                    if (n == 1 && this.valueLines != null) {
                        this.valueLines[n2++] = d;
                    }
                    this.paintGridLine(graphics, rectangle, d, this.valueLinesColor, string2, color, n == 0 && this.valueLinesOn, false, n, 0);
                }
                d += d3;
            }
        }
        if (this.currentLowerRange[n] < 0.0) {
            d = Math.min(0.0, this.currentUpperRange[n] - this.currentUpperRange[n] % d3);
            while (d > this.currentLowerRange[n]) {
                if (d != 0.0) {
                    String string8 = string2 = this.rangeLabelsOn || n > 0 ? this.formatNumber(d, this.rangeDecimalCount[n]) : null;
                    if (n == 0) {
                        if (string2 != null && string3 != null) {
                            string2 = string3 + string2;
                        }
                        if (string2 != null && string4 != null) {
                            string2 = string2 + string4;
                        }
                    }
                    if (n == 1 && this.valueLines != null) {
                        this.valueLines[n2++] = d;
                    }
                    this.paintGridLine(graphics, rectangle, d, this.valueLinesColor, string2, color, n == 0 && this.valueLinesOn, false, n, 0);
                }
                d -= d3;
            }
        }
        if (this.rangeLabelsOn || n > 0) {
            String string9 = this.formatNumber(this.currentUpperRange[n], this.currentUpperRange[n] != 0.0 ? this.rangeDecimalCount[n] : 0);
            if (n == 0) {
                string9 = string3 != null ? string3 + string9 : string9;
                string9 = string4 != null ? string9 + string4 : string9;
            }
            this.paintGridLine(graphics, rectangle, this.currentUpperRange[n], this.chartForeground, string9, color, n == 0, false, n, 0);
            String string10 = this.rangeLabelsOn || n > 0 ? this.formatNumber(this.currentLowerRange[n], this.currentLowerRange[n] != 0.0 ? this.rangeDecimalCount[n] : 0) : (string9 = null);
            if (n == 0) {
                string9 = string3 != null ? string3 + string9 : string9;
                string9 = string4 != null ? string9 + string4 : string9;
            }
            this.paintGridLine(graphics, rectangle, this.currentLowerRange[n], this.chartForeground, string9, color, n == 0, false, n, 0);
        }
        if (this.rangeLabelsOn || n > 0) {
            String string11 = "0";
            if (n == 0) {
                string11 = string3 != null ? string3 + string11 : string11;
                string11 = string4 != null ? string11 + string4 : string11;
            }
            this.paintGridLine(graphics, rectangle, 0.0, n == 0 ? this.chartForeground : color, string11, color, true, false, n, 0);
        }
        if (n == 0) {
            Enumeration enumeration = this.targetsLabel.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                string2 = this.getTargetLabel((String)object);
                Double d5 = (Double)this.targetsValue.get(object);
                Color color2 = (Color)this.targetsColor.get(object);
                if (d5 == null) continue;
                this.paintGridLine(graphics, rectangle, d5, color2, string2, color2, true, true, 0, 0);
            }
        }
        if (this.gridLinesOn && this.gridLines != null) {
            int n6 = 0;
            while (n6 < this.gridLines.length) {
                object = this.valueLinesColor;
                if (this.gridLineColors != null && this.gridLineColors.length > n6 && this.gridLineColors[n6] != null) {
                    object = this.gridLineColors[n6];
                }
                this.paintGridLine(graphics, rectangle, this.gridLines[n6], (Color)object, null, null, true, true, 0, 1);
                ++n6;
            }
        }
        String string12 = string = n == 0 ? this.getLabel("rangeAxisLabel") : this.getLabel("rangeAxisLabel_2");
        if (string != null) {
            object = this.getFont("rangeAxisLabelFont");
            graphics.setFont((Font)object);
            graphics.setColor(color);
            fontMetrics = graphics.getFontMetrics();
            int n7 = 0;
            int n8 = 0;
            int n9 = n == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_2");
            n9 = this.gridAlignment == 1 ? n9 : 0;
            Dimension dimension = this.getLabelSize(string, (Font)object);
            Dimension dimension2 = this.getAngledLabelSize(dimension, n9);
            int n10 = this.getRangeWidth(n, true);
            if (this.gridAlignment == 1) {
                n7 = this.rangePosition[n] == 0 ? rectangle.x - dimension2.width - n10 - 15 : rectangle.x + rectangle.width + n10 + 15;
                n8 = rectangle.y + rectangle.height / 2 - dimension2.height / 2;
                if (n9 % 180 == 0) {
                    n8 += fontMetrics.getAscent();
                }
                if (this.display3dOn && this.rangePosition[n] == 0) {
                    n8 -= this.depth3dPoint.y;
                    n7 -= this.depth3dPoint.x;
                }
            } else {
                n7 = rectangle.x + rectangle.width / 2 - dimension2.width / 2;
                int n11 = this.getFontMetrics(this.getFont("rangeLabelFont")).getHeight();
                if (this.rangePosition[n] == 0) {
                    n8 = rectangle.y + rectangle.height + 5 + (this.rangeLabelsOn ? n11 : 0) + (n9 % 180 == 0 ? fontMetrics.getMaxAscent() - 3 : 0);
                    if (this.rangeAdjusterOn[0] && this.rangeAdjusterPosition[0] == 0 || this.rangeAdjusterOn[1] && this.rangeAdjusterPosition[1] == 0) {
                        n8 += 6;
                    }
                } else {
                    n8 = rectangle.y - 4 - (this.rangeLabelsOn ? n11 : 0);
                    if (this.rangeAdjusterOn[0] && this.rangeAdjusterPosition[0] == 0 || this.rangeAdjusterOn[1] && this.rangeAdjusterPosition[1] == 0) {
                        n8 -= 10;
                    }
                    if (n9 % 180 != 0) {
                        n8 -= dimension2.height - 5;
                    }
                }
                if (this.display3dOn && this.rangePosition[n] == 0) {
                    n8 -= this.depth3dPoint.y;
                    n7 -= this.depth3dPoint.x;
                }
            }
            this.paintLabel(graphics, string, n7, n8, dimension, 0, n9);
        }
    }

    public static String getVersion() {
        return "2.6pre2";
    }

    public void setVisibleSamples(int n, int n2) {
        int n3 = this.getSampleCount();
        n2 = n2 != -1 ? n2 : n3;
        n = Math.max(0, n);
        n = Math.min(n3 - 1, n);
        n2 = Math.max(1, n2);
        n2 = Math.min(n3 - n, n2);
        n = Math.min(n3 - n2, n);
        this.leftScrollerFactor = (double)n / (double)n3;
        this.rightScrollerFactor = (double)(n3 - n2 - n) / (double)n3;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isFloatingOnLegendOn() {
        return this.floatingOnLegendOn;
    }

    public boolean isRangeAdjusterOn(int n) {
        n = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, n));
        return this.rangeAdjusterOn[n];
    }

    public boolean isRangeAdjusterOn() {
        return this.isRangeAdjusterOn(0);
    }

    synchronized void setLowerRelativeRangeIndex(int n, double d) {
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        double d2 = this.getLowestValue(n);
        if (n == 0) {
            Enumeration enumeration = this.targetsValue.elements();
            while (enumeration.hasMoreElements()) {
                d2 = Math.min((Double)enumeration.nextElement(), d2);
            }
        }
        if (d2 < 0.0) {
            this.setLowerRange(n, d2 * Math.abs(d));
        } else {
            this.setLowerRange(n, 0.0);
        }
    }

    public void setLabelAngle(String string, int n) {
        if (string != null && string.length() > 0) {
            string = string.toLowerCase().trim();
            this.labelAngles.put(string, new Integer(n %= 360));
            this.angledLabelCache.clear();
            this.hasChanged = true;
            this.autoRepaint();
        }
    }

    public int getLabelAngle(String string) {
        if (string != null && this.labelAngles.get(string = string.toLowerCase().trim()) != null) {
            return (Integer)this.labelAngles.get(string);
        }
        return 0;
    }

    public Object[] getSelectedObjects() {
        int n;
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n3) {
                if (this.isSelected(n5, n)) {
                    ++n4;
                }
                ++n;
            }
            ++n5;
        }
        if (n4 > 0) {
            Object[] objectArray = new Object[n4];
            n = 0;
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n3) {
                    if (this.isSelected(n6, n7) && n < objectArray.length) {
                        objectArray[n++] = this.getSample(n6, n7);
                    }
                    ++n7;
                }
                ++n6;
            }
            return objectArray;
        }
        return null;
    }

    void paint3DEdges(Graphics graphics, Rectangle rectangle) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y - this.depth3dPoint.y);
        polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
        graphics.drawPolygon(polygon);
        if (this.rangeOn[1] && this.valueLines != null) {
            int cfr_ignored_0 = this.depth3dPoint.y / this.valueLines.length;
            int n = 0;
            while (n < this.valueLines.length) {
                int n2;
                double d = (this.valueLines[n] - this.currentLowerRange[1]) / (this.currentUpperRange[1] - this.currentLowerRange[1]);
                if (this.gridAlignment == 1) {
                    n2 = (int)Math.round((double)(rectangle.y + rectangle.height) - d * (double)rectangle.height - (double)this.depth3dPoint.y);
                    if (this.valueLines[n] != 0.0 && n2 > rectangle.y - this.depth3dPoint.y + 1) {
                        graphics.drawLine(rectangle.x + rectangle.width - this.depth3dPoint.x, n2, rectangle.x + rectangle.width - this.depth3dPoint.x + 2, n2 - 2);
                    }
                } else {
                    n2 = (int)Math.round((double)(rectangle.x + rectangle.width) - d * (double)rectangle.width);
                    n2 = rectangle.x * 2 + rectangle.width - n2 - this.depth3dPoint.x;
                    if (this.valueLines[n] != 0.0 && n2 < rectangle.x + rectangle.width - this.depth3dPoint.x) {
                        graphics.drawLine(n2 - 1, rectangle.y - this.depth3dPoint.y, n2 + 2, rectangle.y - this.depth3dPoint.y - 2);
                    }
                }
                ++n;
            }
        }
        polygon.xpoints[1] = rectangle.x - this.depth3dPoint.x;
        polygon.ypoints[1] = rectangle.y - this.depth3dPoint.y;
        graphics.drawPolygon(polygon);
        polygon.xpoints[1] = rectangle.x + rectangle.width;
        polygon.ypoints[1] = rectangle.y;
        graphics.drawPolygon(polygon);
    }

    public void setExternalGraphics(Graphics graphics, Image image) {
        this.externalGraphicsOn = true;
        this.offscreen = image;
        this.og = graphics;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setOverlayChart(int n, Chart chart) {
        if (chart != null) {
            int n2 = this.overlayCharts.size();
            if (n >= 0 && n <= n2) {
                if (n == n2) {
                    this.overlayCharts.addElement(chart);
                } else {
                    this.overlayCharts.setElementAt(chart, n);
                }
                chart.setRange(0, this.getRange(0));
                chart.setRange(1, this.getRange(1));
                chart.setLowerRange(0, this.getLowerRange(0));
                chart.setLowerRange(1, this.getLowerRange(1));
                this.hasChanged = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid index for overlay chart: " + n);
            }
        }
    }

    public Chart getOverlayChart(int n) {
        if (n >= 0 && n < this.overlayCharts.size()) {
            return (Chart)this.overlayCharts.elementAt(n);
        }
        return null;
    }

    public boolean isGridLinesOn() {
        return this.gridLinesOn;
    }

    public void setLegendImage(int n, String string) {
        if (n >= 0 && n < 1000) {
            if (this.legendImages == null) {
                this.legendImages = new String[n + 1];
            }
            if (n >= this.legendImages.length) {
                String[] stringArray = new String[n + 1];
                System.arraycopy(this.legendImages, 0, stringArray, 0, this.legendImages.length);
                this.legendImages = stringArray;
            }
            this.legendImages[n] = string;
            this.hasChanged = true;
            this.autoRepaint();
        }
    }

    public String getLegendImage(int n) {
        if (this.legendImages != null && n >= 0 && n < this.legendImages.length) {
            return this.legendImages[n];
        }
        return null;
    }

    public void removeExternalGraphics() {
        this.externalGraphicsOn = false;
        this.hasChanged = true;
        this.autoRepaint();
    }

    int getRangeWidth(int n, boolean bl) {
        String string;
        int n2;
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
        int n3 = 0;
        if (this.rangeOn[n] && (n == 0 && this.rangeLabelsOn || n > 0)) {
            String string2;
            String string3;
            n2 = this.getRangeDecimalCount(n);
            string = this.formatNumber(this.upperRange[n], n2);
            if (n == 0 && this.rangeLabelsOn) {
                string3 = this.getLabel("rangeLabelPrefix");
                string2 = this.getLabel("rangeLabelPostfix");
                string = string + (string3 != null ? string3 : "");
                string = string + (string2 != null ? string2 : "");
            }
            n3 = fontMetrics.stringWidth(string);
            string = this.formatNumber(this.lowerRange[n], n2);
            if (n == 0 && this.rangeLabelsOn) {
                string3 = this.getLabel("rangeLabelPrefix");
                string2 = this.getLabel("rangeLabelPostfix");
                string = string + (string3 != null ? string3 : "");
                string = string + (string2 != null ? string2 : "");
            }
            n3 = Math.max(fontMetrics.stringWidth(string), n3);
        }
        if (bl && n == 0) {
            Enumeration enumeration = this.targetsLabel.keys();
            while (enumeration.hasMoreElements()) {
                string = this.getTargetLabel((String)enumeration.nextElement());
                if (string == null) continue;
                n3 = Math.max(fontMetrics.stringWidth(string), n3);
            }
        }
        n2 = this.rangeAdjusterOn[n] && this.rangeAdjusterPosition[n] == this.rangePosition[n] ? 6 : 0;
        return n3 + 4 + n2;
    }

    public void removeItemListener(ItemListener itemListener) {
        if (itemListener != null && this.listeners != null) {
            this.listeners.removeElement(itemListener);
        }
    }

    public void setGridLines(double[] dArray) {
        this.gridLines = dArray;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double[] getGridLines() {
        return this.gridLines;
    }

    public void setAutomaticRepaintOn(boolean bl) {
        this.automaticRepaintOn = bl;
    }

    public void setOverlayChartOn(int n, boolean bl) {
        Chart chart = this.getOverlayChart(n);
        if (chart != null) {
            chart.overlayChartOn = bl;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public abstract Rectangle getGraphBounds();

    Rectangle getGraphBounds(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Labels is NULL");
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(10, 10, dimension.width - 20, dimension.height - 20);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont("legendFont"));
        fontMetrics.getHeight();
        Dimension dimension2 = null;
        if (this.chartTitleOn) {
            dimension2 = this.getLabelSize(this.chartTitle, this.getFont("titleFont"));
            rectangle.y += dimension2.height;
            rectangle.height -= dimension2.height;
        }
        if (this.legendOn) {
            this.getSampleCount();
            this.getSeriesCount();
            Font font = this.getFont("legendFont");
            fontMetrics = this.getFontMetrics(font);
            this.legend.width = 0;
            this.legend.height = 0;
            int n = 6;
            int n2 = 0;
            while (n2 < stringArray.length) {
                Dimension dimension3 = this.getLabelSize(stringArray[n2], font);
                Dimension dimension4 = this.getImageSize(this.getLegendImage(n2));
                if (this.legendPosition == 1 || this.legendPosition == 0) {
                    dimension4.width = Math.max(dimension4.width, n);
                    this.legend.width = Math.max(this.legend.width, dimension3.width + dimension4.width + n + 2);
                    this.legend.height += Math.max(Math.max(dimension4.height, dimension3.height), n + 6) + 2;
                } else {
                    this.legend.height = Math.max(Math.max(this.legend.height, dimension3.height), dimension4.height + 1);
                    dimension4.width = Math.max(dimension4.width, n);
                    this.legend.width += dimension4.width + n + dimension3.width;
                    if (n2 < stringArray.length - 1) {
                        this.legend.width += n + 2;
                    }
                }
                ++n2;
            }
            switch (this.legendPosition) {
                default: {
                    this.legend.x = dimension.width - this.legend.width - 3;
                    this.legend.y = dimension.height / 2 - this.legend.height / 2 + fontMetrics.getDescent();
                    rectangle.width -= this.legend.width;
                    break;
                }
                case 0: {
                    this.legend.x = 6;
                    this.legend.y = dimension.height / 2 - this.legend.height / 2 + fontMetrics.getDescent();
                    rectangle.x += this.legend.width;
                    rectangle.width -= this.legend.width;
                    break;
                }
                case 2: {
                    this.legend.x = dimension.width / 2 - this.legend.width / 2;
                    this.legend.y = dimension2 != null ? dimension2.height + 9 : 9;
                    rectangle.y += this.legend.height + fontMetrics.getDescent();
                    rectangle.height -= this.legend.height + fontMetrics.getDescent();
                    break;
                }
                case 3: {
                    this.legend.x = dimension.width / 2 - this.legend.width / 2;
                    this.legend.y = dimension.height - this.legend.height - 2;
                    rectangle.height -= this.legend.height + 4;
                    break;
                }
            }
        }
        if (this.sampleScrollerOn) {
            if (this.gridAlignment == 1) {
                rectangle.height -= 10;
            } else {
                rectangle.width -= 10;
                rectangle.x += 10;
            }
        }
        return rectangle;
    }

    public void run() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {}
        double d = (double)(this.chartDataBounds.width / this.getSampleCount()) / (double)this.chartDataBounds.width;
        while (true) {
            if (this.insideLeftButton) {
                d = Math.min(d, this.leftScrollerFactor);
                this.leftScrollerFactor -= d;
                this.rightScrollerFactor += d;
                this.hasChanged = true;
                this.repaint();
            }
            if (this.insideRightButton) {
                d = Math.min(d, this.rightScrollerFactor);
                this.leftScrollerFactor += d;
                this.rightScrollerFactor -= d;
                this.hasChanged = true;
                this.repaint();
            }
            try {
                Thread.sleep(35L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    synchronized void paintLegend(Graphics graphics, Rectangle rectangle, String[] stringArray) {
        int n;
        if (graphics == null || rectangle == null || stringArray == null) {
            return;
        }
        if (this.legendBounds == null || this.legendBounds.length != stringArray.length) {
            this.legendBounds = new Rectangle[stringArray.length];
            n = 0;
            while (n < this.legendBounds.length) {
                this.legendBounds[n] = new Rectangle();
                ++n;
            }
        }
        n = 6;
        int n2 = this.legend.y;
        int n3 = this.legend.x;
        int n4 = n3 + n;
        int n5 = this.legend.y;
        int n6 = 0;
        while (n6 < stringArray.length) {
            Dimension dimension = this.getImageSize(this.getLegendImage(n6));
            n4 = Math.max(n4, n3 + n + dimension.width);
            ++n6;
        }
        if (n4 == n3 + n) {
            n4 += n;
        }
        n6 = this.getSampleCount();
        int n7 = this.getSeriesCount();
        Font font = this.getFont("legendFont");
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = 0;
        while (n8 < stringArray.length) {
            int n9;
            Object object;
            String string = this.getLegendImage(n8);
            Dimension dimension = this.getImageSize(string);
            if (this.legendPosition == 2 || this.legendPosition == 3) {
                n2 = this.legend.y + (this.legend.height - (dimension.height > 0 ? dimension.height : 6)) / 2;
            }
            if (string != null && dimension.width > 0 && dimension.height > 0) {
                object = (Image)this.images.get(string);
                if (object != null) {
                    if (this.legendPosition == 1 || this.legendPosition == 0) {
                        int n10 = dimension.width < n ? n3 + n / 2 - dimension.width / 2 + 1 : n3;
                        n9 = dimension.height < n ? n2 + n / 2 - dimension.height / 2 + 1 : n2;
                        graphics.drawImage((Image)object, n10, n9, this);
                    } else {
                        graphics.drawImage((Image)object, n3, n2, this);
                    }
                }
            } else {
                object = this.getLegendColor(n8);
                if (object != null) {
                    graphics.setColor((Color)object);
                }
                graphics.fillRect(n3, n2, n, n);
                graphics.setColor(Color.black);
                graphics.drawRect(n3, n2, n, n);
            }
            graphics.setColor(this.getForeground());
            if (n7 == 1 && n8 < n6) {
                object = this.getSampleLabelColor(n8);
                if (object != null) {
                    graphics.setColor((Color)object);
                }
            } else if (n7 > 1 && n8 < n7 && (object = this.getSeriesLabelColor(n8)) != null) {
                graphics.setColor((Color)object);
            }
            object = this.getLabelSize(stringArray[n8], font);
            dimension.width = Math.max(dimension.width, n);
            dimension.height = Math.max(dimension.height, n);
            n5 = n2 + dimension.height / 2 + fontMetrics.getMaxAscent() / 2 - 1;
            if (this.legendPosition == 2 || this.legendPosition == 3) {
                n4 = n3 + dimension.width + n;
                n5 = this.legend.y + (this.legend.height - ((Dimension)object).height) / 2 + ((Dimension)object).height - 2;
            }
            this.paintLabel(graphics, stringArray[n8], n4, n5, (Dimension)object, -1, 0);
            Rectangle rectangle2 = this.legendBounds[n8];
            rectangle2.x = n3 - 3;
            rectangle2.y = Math.min(n5 - fontMetrics.getAscent(), n2 - 3);
            rectangle2.width = ((Dimension)object).width + n4 - n3 + 6;
            rectangle2.height = Math.max(dimension.height + 5, ((Dimension)object).height + 1);
            rectangle2.height = Math.max(rectangle2.height, n + 7);
            if (n8 >= 0 && n8 < this.legendSelection.length && this.legendSelection[n8]) {
                graphics.setColor(this.getForeground());
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            if (this.legendPosition == 0 || this.legendPosition == 1) {
                n9 = Math.max(dimension.height, ((Dimension)object).height);
                n9 = Math.max(n9, n + 6) + 2;
                n2 += n9;
            } else {
                n3 += rectangle2.width + 2;
            }
            ++n8;
        }
    }

    public synchronized String formatNumber(double d, int n) {
        if (n == 0 && d < 1000.0 && d > -1000.0) {
            return Math.round(d) + "";
        }
        if (this.numberFormatter == null) {
            this.numberFormatter = NumberFormat.getInstance();
        }
        this.numberFormatter.setMaximumFractionDigits(n);
        this.numberFormatter.setMinimumFractionDigits(n);
        return this.numberFormatter.format(d);
    }

    public boolean isLegendOn() {
        return this.legendOn;
    }

    public synchronized void setSeriesLabel(int n, String string) {
        this.chartData.setSeriesLabel(n, string);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized String getSeriesLabel(int n) {
        return this.chartData.getSeriesLabel(n);
    }

    void paintLabel(Graphics graphics, String string, int n, int n2, Dimension dimension, int n3, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (string != null && n4 == 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2 != null && string2.length() > 0) {
                    if (n3 == -1) {
                        graphics.drawString(string2, n, n2);
                    } else if (n3 == 1) {
                        graphics.drawString(string2, n + dimension.width - fontMetrics.stringWidth(string2), n2);
                    } else {
                        graphics.drawString(string2, n + dimension.width / 2 - fontMetrics.stringWidth(string2) / 2, n2);
                    }
                }
                n2 += fontMetrics.getMaxAscent() + 1;
            }
        } else if (string != null) {
            Long l = new Long(string.hashCode() + n4 + graphics.getFont().hashCode());
            Image image = (Image)this.angledLabelCache.get(l);
            if (image == null) {
                if (this.rotateImage == null || dimension.width > this.rotateImage.getWidth(this) || dimension.height > this.rotateImage.getHeight(this)) {
                    if (this.rotateImage != null) {
                        this.rotateImage.flush();
                    }
                    this.rotateImage = this.createImage(dimension.width, dimension.height);
                }
                Color[] colorArray = new Color[2];
                colorArray[1] = graphics.getColor();
                int[] nArray = new int[2];
                this.getColorPixels(colorArray, nArray);
                Graphics graphics2 = this.rotateImage.getGraphics();
                graphics2.setColor(colorArray[0]);
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
                graphics2.setColor(colorArray[1]);
                graphics2.setFont(graphics.getFont());
                this.paintLabel(graphics2, string, 0, fontMetrics.getMaxAscent() - fontMetrics.getDescent() + 2, dimension, 0, 0);
                graphics2.dispose();
                graphics2 = null;
                int[] nArray2 = new int[dimension.width * dimension.height];
                PixelGrabber pixelGrabber = new PixelGrabber(this.rotateImage, 0, 0, dimension.width, dimension.height, nArray2, 0, dimension.width);
                pixelGrabber.startGrabbing();
                pixelGrabber.getPixels();
                int n5 = colorArray[1].getRGB();
                int n6 = 0;
                while (n6 < nArray2.length) {
                    nArray2[n6] = nArray2[n6] == nArray[0] ? nArray[0] & 0xFFFFFF : n5;
                    ++n6;
                }
                Dimension dimension2 = new Dimension(dimension.width, dimension.height);
                int[] nArray3 = this.rotateImage(nArray2, n4, dimension2, nArray[0]);
                image = this.createImage(new MemoryImageSource(dimension2.width, dimension2.height, nArray3, 0, dimension2.width));
                if (!this.servletModeOn) {
                    this.angledLabelCache.put(l, image);
                }
            }
            if (n4 == 180) {
                n2 -= fontMetrics.getAscent() - 2;
            }
            graphics.drawImage(image, n, n2, null);
        }
    }

    void paintGrid(Graphics graphics, Rectangle rectangle) {
        if (this.depth3d > -1) {
            this.depth3dPoint.x = this.depth3d;
            this.depth3dPoint.y = -this.depth3d;
        }
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(rectangle.x - this.depth3dPoint.x, rectangle.y - this.depth3dPoint.y);
        polygon.addPoint(polygon.xpoints[1], polygon.ypoints[1] + rectangle.height);
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x, rectangle.y);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon2.addPoint(polygon.xpoints[2], polygon.ypoints[2]);
        polygon2.addPoint(polygon2.xpoints[1] + rectangle.width, polygon2.ypoints[1]);
        polygon2.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        polygon2.addPoint(polygon2.xpoints[0], polygon2.ypoints[0]);
        Color color = this.getChartBackground();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.display3dOn) {
            graphics.setColor(this.gridAlignment == 1 ? color : color.darker());
            graphics.fillPolygon(polygon);
            graphics.setColor(this.gridAlignment == 0 ? color : color.darker());
            graphics.fillPolygon(polygon2);
        }
        graphics.setColor(this.chartForeground);
        if (this.display3dOn) {
            graphics.drawPolygon(polygon);
            graphics.drawPolygon(polygon2);
        }
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(this.getFont("rangeLabelFont"));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.rangeOn.length - 1;
        while (n >= 0) {
            this.paintRange(graphics, rectangle, n);
            --n;
        }
        graphics.setColor(this.chartForeground);
        if (this.getLabel("sampleAxisLabel") != null) {
            Dimension dimension;
            int n2;
            Object object;
            Dimension dimension2 = new Dimension();
            if (this.sampleLabelsOn && this.barLabelStyle != 1) {
                object = this.getFont();
                int n3 = 0;
                if (this.chartType.equals("bar")) {
                    object = this.getFont("barLabelFont");
                    n3 = this.getLabelAngle("barLabelAngle");
                } else if (this.chartType.equals("line")) {
                    object = this.getFont("sampleLabelFont");
                    n3 = this.getLabelAngle("sampleLabelAngle");
                }
                String[] stringArray = this.barLabels != null ? this.barLabels : this.getSampleLabels();
                n2 = 0;
                while (n2 < stringArray.length) {
                    Dimension dimension3 = this.getLabelSize(stringArray[n2], (Font)object);
                    dimension = this.getAngledLabelSize(dimension3, n3);
                    dimension2.width = Math.max(dimension2.width, dimension.width);
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                    ++n2;
                }
            }
            object = this.getLabel("sampleAxisLabel");
            Font font = this.getFont("sampleAxisLabelFont");
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics();
            int n4 = 0;
            n2 = 0;
            int n5 = this.getLabelAngle("sampleAxisLabelAngle");
            n5 = this.gridAlignment == 0 ? n5 : 0;
            dimension = this.getLabelSize((String)object, font);
            Dimension dimension4 = this.getAngledLabelSize(dimension, n5);
            if (this.gridAlignment == 1) {
                n4 = rectangle.x + rectangle.width / 2 - dimension4.width / 2;
                n2 = rectangle.y + rectangle.height + 7;
                if (n5 % 180 == 0) {
                    n2 += fontMetrics.getMaxAscent() - 2;
                }
                if (this.display3dOn) {
                    n4 -= this.depth3dPoint.x;
                    n2 -= this.depth3dPoint.y;
                }
                if (this.sampleLabelsOn) {
                    n2 += dimension2.height + 1;
                }
                if (this.sampleScrollerOn) {
                    n2 += 10;
                }
            } else {
                n4 = rectangle.x - dimension4.width - 5;
                n2 = rectangle.y + rectangle.height / 2 - dimension4.height / 2;
                if (n5 % 180 == 0) {
                    n2 += fontMetrics.getAscent();
                }
                if (this.sampleLabelsOn) {
                    n4 -= dimension2.width + 4;
                }
                if (this.display3dOn) {
                    n2 -= this.depth3dPoint.y;
                    n4 -= this.depth3dPoint.x;
                }
                if (this.sampleScrollerOn) {
                    n4 -= 10;
                }
            }
            this.paintLabel(graphics, (String)object, n4, n2, dimension, 0, n5);
        }
        int n6 = 0;
        while (n6 < this.rangeAdjusterOn.length) {
            this.paintRangeAdjuster(graphics, rectangle, n6);
            ++n6;
        }
        if (this.sampleScrollerOn) {
            this.paintSampleScroller(graphics, rectangle);
        }
    }

    private void itransform(double d, double d2, double d3, double d4, double[] dArray) {
        dArray[0] = d * d3 - d2 * d4;
        dArray[1] = d * d4 + d2 * d3;
    }

    public void setSampleScrollerOn(boolean bl) {
        this.sampleScrollerOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    protected abstract void calculateChartData(Rectangle var1, Rectangle var2);

    public synchronized void setSampleValue(int n, int n2, double d) {
        this.chartData.setSampleValue(n, n2, d);
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.autoRepaint();
    }

    public synchronized double getSampleValue(int n, int n2) {
        return this.chartData.getSampleValue(n, n2);
    }

    public synchronized int appendSampleValue(int n, double d, boolean bl) {
        int n2 = this.chartData.appendSampleValue(n, d, bl);
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.autoRepaint();
        return n2;
    }

    double getLowestValue(int n) {
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        int n2 = this.getSeriesCount();
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            if (this.getSeriesRange(n3) == n) {
                d = Math.min(this.getMinValue(n3), d);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.overlayCharts.size()) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n3);
            if (chart != null && !(chart instanceof PieChart) && chart.getSeriesRange(n3) == n) {
                d = Math.min(chart.getMinValue(n3), d);
            }
            ++n3;
        }
        return d;
    }

    public void setPrintAsBitmap(boolean bl) {
        this.printAsBitmap = bl;
    }

    private void paintGridLine(Graphics graphics, Rectangle rectangle, double d, Color color, String string, Color color2, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        Serializable serializable;
        double d2 = 0.0;
        if (n2 == 0) {
            if (this.currentUpperRange[n = Math.max(0, Math.min(this.rangeOn.length - 1, n))] - this.currentLowerRange[n] != 0.0) {
                d2 = (d - this.currentLowerRange[n]) / (this.currentUpperRange[n] - this.currentLowerRange[n]);
            }
        } else if (n2 == 1) {
            double d3;
            double d4;
            serializable = this.getDataBounds(rectangle);
            if (this.gridAlignment == 1) {
                d4 = (double)(rectangle.x - ((Rectangle)serializable).x) / (double)((Rectangle)serializable).width * (this.rightSampleAxisRange - this.leftSampleAxisRange) + this.leftSampleAxisRange;
                d3 = (double)(rectangle.width + rectangle.x - ((Rectangle)serializable).x) / (double)((Rectangle)serializable).width * (this.rightSampleAxisRange - this.leftSampleAxisRange) + this.leftSampleAxisRange;
            } else {
                d4 = (double)(rectangle.y - ((Rectangle)serializable).y) / (double)((Rectangle)serializable).height * (this.rightSampleAxisRange - this.leftSampleAxisRange) + this.leftSampleAxisRange;
                d3 = (double)(rectangle.height + rectangle.y - ((Rectangle)serializable).y) / (double)((Rectangle)serializable).height * (this.rightSampleAxisRange - this.leftSampleAxisRange) + this.leftSampleAxisRange;
            }
            d2 = (d - d4) / (d3 - d4);
        }
        serializable = graphics.getFontMetrics();
        int n4 = ((FontMetrics)serializable).getHeight();
        int n5 = ((FontMetrics)serializable).getDescent();
        int n6 = n3 = string != null ? ((FontMetrics)serializable).stringWidth(string) : 0;
        if (this.gridAlignment == 1 && n2 == 0 || this.gridAlignment == 0 && n2 == 1) {
            int n7 = (int)Math.round((double)(rectangle.y + rectangle.height) - d2 * (double)rectangle.height);
            if (n2 == 1) {
                n7 = (int)Math.round((double)rectangle.y + d2 * (double)rectangle.height);
            }
            boolean bl3 = n7 >= rectangle.y && n7 <= rectangle.y + rectangle.height;
            boolean bl4 = n7 - n4 / 2 > rectangle.y + n5 / 2;
            bl4 &= n7 + n4 / 2 < rectangle.y + rectangle.height - n5 / 2;
            bl4 |= n2 == 1 && n7 > rectangle.y && n7 < rectangle.y + rectangle.height;
            if (bl3 && ((bl4 |= n2 == 0 && d == 0.0) || bl2) || n2 == 0 && (d == this.currentLowerRange[n] || d == this.currentUpperRange[n])) {
                if (bl) {
                    graphics.setColor(color);
                    graphics.drawLine(rectangle.x + 1, n7, rectangle.x + rectangle.width - 1, n7);
                    if (this.display3dOn) {
                        graphics.drawLine(rectangle.x, n7, rectangle.x - this.depth3dPoint.x, n7 - this.depth3dPoint.y);
                    }
                }
                if (string != null) {
                    int n8 = rectangle.x - (this.display3dOn && this.rangePosition[n] == 0 ? this.depth3dPoint.x : 0);
                    n7 -= this.display3dOn && this.rangePosition[n] == 0 ? this.depth3dPoint.y : 0;
                    int n9 = 0;
                    graphics.setColor(color2);
                    if (this.rangePosition[n] == 0) {
                        graphics.drawLine(n8, n7, n8 - 3, n7);
                        n9 = n8 - n3 - 4;
                        if (this.rangeAdjusterOn[0] && this.rangeAdjusterPosition[0] == 0 || this.rangeAdjusterOn[1] && this.rangeAdjusterPosition[1] == 0) {
                            n9 -= 6;
                        }
                    } else {
                        graphics.drawLine(n8 + rectangle.width, n7, n8 + rectangle.width + 2, n7);
                        n9 = rectangle.x + rectangle.width + 5;
                        if (this.rangeAdjusterOn[0] && this.rangeAdjusterPosition[0] == 1 || this.rangeAdjusterOn[1] && this.rangeAdjusterPosition[1] == 1) {
                            n9 += 7;
                        }
                    }
                    int n10 = n7 + n4 - ((FontMetrics)serializable).getAscent() + 1;
                    graphics.drawString(string, n9, n10);
                }
            }
        } else {
            String string2 = this.formatNumber(this.currentUpperRange[n], this.rangeDecimalCount[n]);
            String string3 = this.formatNumber(this.currentLowerRange[n], this.rangeDecimalCount[n]);
            int n11 = (int)(d != 0.0 || n2 == 1 ? Math.round((double)rectangle.x + d2 * (double)rectangle.width) : (long)this.zeroLine[n]);
            boolean bl5 = n11 >= rectangle.x && n11 <= rectangle.x + rectangle.width;
            boolean bl6 = n11 - n3 / 2 > rectangle.x + ((FontMetrics)serializable).stringWidth(string3) / 2;
            bl6 &= n11 + n3 / 2 < rectangle.x + rectangle.width - ((FontMetrics)serializable).stringWidth(string2) / 2;
            bl6 |= n2 == 1 && n11 > rectangle.x && n11 < rectangle.x + rectangle.width;
            if (bl5 && ((bl6 |= n2 == 0 && d == 0.0) || bl2) || n2 == 0 && (d == this.currentLowerRange[n] || d == this.currentUpperRange[n])) {
                if (bl) {
                    graphics.setColor(color);
                    graphics.drawLine(n11, rectangle.y + 1, n11, rectangle.y + rectangle.height - 1);
                    if (this.display3dOn) {
                        graphics.drawLine(n11, rectangle.y + rectangle.height, n11 - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
                    }
                }
                if (string != null) {
                    int n12 = rectangle.y - (this.display3dOn && this.rangePosition[n] == 0 ? this.depth3dPoint.y : 0);
                    int n13 = this.display3dOn && this.rangePosition[n] == 0 ? this.depth3dPoint.x : 0;
                    graphics.setColor(color2);
                    int n14 = (n11 -= n13) - n3 / 2;
                    int n15 = 0;
                    if (this.rangePosition[n] == 0) {
                        graphics.drawLine(n11, n12 + rectangle.height, n11, n12 + rectangle.height + 3);
                        n15 = n12 + rectangle.height + ((FontMetrics)serializable).getHeight();
                        if (this.rangeAdjusterOn[0] && this.rangeAdjusterPosition[0] == 0 || this.rangeAdjusterOn[1] && this.rangeAdjusterPosition[1] == 0) {
                            n15 += 7;
                        }
                        if (bl2) {
                            n15 += ((FontMetrics)serializable).getHeight();
                        }
                    } else {
                        graphics.drawLine(n11, n12, n11, n12 - 3);
                        n15 = n12 - 5;
                        if (this.rangeAdjusterOn[0] && this.rangeAdjusterPosition[0] == 1 || this.rangeAdjusterOn[1] && this.rangeAdjusterPosition[1] == 1) {
                            n15 -= 6;
                        }
                        if (bl2) {
                            n15 -= ((FontMetrics)serializable).getHeight();
                        }
                    }
                    graphics.setColor(color2);
                    graphics.drawString(string, n14, n15);
                }
            }
        }
    }

    public synchronized void setLowerRelativeRange(double d) {
        this.setLowerRelativeRangeIndex(0, d);
    }

    public synchronized void setLowerRelativeRange(double d, double d2) {
        this.setLowerRelativeRange(0, d, d2);
    }

    public synchronized void setLowerRelativeRange(int n, double d, double d2) {
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        double d3 = this.getLowestValue(n);
        if (n == 0) {
            Enumeration enumeration = this.targetsValue.elements();
            while (enumeration.hasMoreElements()) {
                d3 = Math.min((Double)enumeration.nextElement(), d3);
            }
        }
        if (d3 < 0.0) {
            d2 = Math.abs(d2);
            double d4 = d3 * Math.abs(d);
            if (d2 % 1.0 == 0.0) {
                if (d4 % d2 == 0.0) {
                    this.setLowerRange(n, d4);
                } else {
                    this.setLowerRange(n, d4 - d4 % d2 - d2);
                }
            } else {
                double d5 = 0.0;
                while (d5 > d4) {
                    d5 -= d2;
                }
                this.setLowerRange(n, d5);
            }
        } else {
            this.setLowerRange(n, 0.0);
        }
    }

    public void setCurrentRange(int n, double d) {
        n = Math.min(this.upperRange.length - 1, Math.max(0, n));
        int n2 = this.rangeAdjusted[n];
        if (n == 0 && n2 == 2) {
            n2 = 0;
        } else if (n == 1 && n2 == 2) {
            n2 = 1;
        }
        d = Math.min(this.upperRange[n2], d);
        this.currentUpperRange[n2] = d = Math.max(this.currentLowerRange[n2], d);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getCurrentRange(int n) {
        n = Math.min(this.currentUpperRange.length - 1, Math.max(0, n));
        return this.currentUpperRange[n];
    }

    public void setValueLinesOn(boolean bl) {
        this.valueLinesOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setSampleAxisRange(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("Min is more or equal than max: " + d + ", " + d2);
        }
        this.leftSampleAxisRange = d;
        this.rightSampleAxisRange = d2;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public void setGraphInsets(int n, int n2, int n3, int n4) {
        this.graphInsets.top = n;
        this.graphInsets.left = n2;
        this.graphInsets.bottom = n3;
        this.graphInsets.right = n4;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Insets getGraphInsets() {
        return this.graphInsets;
    }

    public synchronized void setSampleLabels(String[] stringArray) {
        this.chartData.setSampleLabels(stringArray);
        this.hasChanged = true;
        if (this.sampleLabelsOn && (this.getLabelAngle("sampleLabelAngle") != 0 || this.getLabelAngle("barLabelAngle") != 0)) {
            this.angledLabelCache.clear();
        }
        this.labelSizeCache.clear();
        this.autoRepaint();
    }

    public synchronized String[] getSampleLabels() {
        return this.chartData.getSampleLabels();
    }

    public Image getImage(String string) {
        return (Image)this.images.get(string);
    }

    public synchronized double getFloatLowerRange() {
        return this.getLowerRange(0);
    }

    public void setCurrentRange(double d) {
        this.setCurrentRange(0, d);
    }

    public double getCurrentRange() {
        return this.getCurrentRange(0);
    }

    public Image getImage(int n, int n2) {
        Graphics graphics;
        n = Math.max(1, n);
        n2 = Math.max(1, n2);
        Dimension dimension = this.getSize();
        Image image = this.createImage(n, n2);
        if (image != null && (graphics = image.getGraphics()) != null) {
            this.offscreen = null;
            this.setSize(n, n2);
            this.paint(graphics);
        }
        this.setSize(dimension.width, dimension.height);
        return image;
    }

    private void paintRangeAdjuster(Graphics graphics, Rectangle rectangle, int n) {
        if (!this.rangeAdjusterOn[n = Math.min(1, Math.max(0, n))]) {
            return;
        }
        int n2 = this.rangeAdjusted[n];
        if (n == 0 && n2 == 2) {
            n2 = 0;
        } else if (n == 1 && n2 == 2) {
            n2 = 1;
        }
        if (this.gridAlignment == 1) {
            int n3 = 0;
            int n4 = rectangle.y;
            if (this.rangeAdjusterPosition[n] == 0) {
                n3 = rectangle.x - 5 - (this.display3dOn ? this.depth3dPoint.x : 0);
                n4 -= this.display3dOn ? this.depth3dPoint.y : 0;
            } else {
                n3 = rectangle.x + rectangle.width + 5;
            }
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(n3, n4, n3, n4 + rectangle.height);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(n3 + 1, n4, n3 + 1, n4 + rectangle.height);
            double d = 0.0;
            double d2 = 0.0;
            if (this.upperRange[n2] - this.lowerRange[n2] != 0.0) {
                d = (this.currentUpperRange[n2] - this.lowerRange[n2]) / (this.upperRange[n2] - this.lowerRange[n2]);
                d2 = (this.currentLowerRange[n2] - this.lowerRange[n2]) / (this.upperRange[n2] - this.lowerRange[n2]);
            }
            int n5 = (int)Math.round((double)(n4 + rectangle.height) - d * (double)rectangle.height);
            int n6 = (int)Math.round((double)(n4 + rectangle.height) - d2 * (double)rectangle.height);
            this.rangeAdjusterBounds[n].setBounds(n3 - 3, n5, 7, n6 - n5);
            this.paintBox(graphics, Color.lightGray, n3 - 3, n5, 6, n6 - n5, false);
            graphics.setColor(Color.gray);
            graphics.drawLine(n3 - 2, n5 + 2, n3 + 2, n5 + 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n3 - 2, n6 - 2, n3 + 2, n6 - 2);
        } else {
            int n7 = 0;
            int n8 = rectangle.x;
            if (this.rangeAdjusterPosition[n] == 0) {
                n7 = rectangle.y + rectangle.height + 5 - (this.display3dOn ? this.depth3dPoint.y : 0);
                n8 -= this.display3dOn ? this.depth3dPoint.x : 0;
            } else {
                n7 = rectangle.y - 5;
            }
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(n8, n7, n8 + rectangle.width, n7);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(n8, n7 + 1, n8 + rectangle.width, n7 + 1);
            double d = 0.0;
            double d3 = 0.0;
            if (this.upperRange[n2] - this.lowerRange[n2] != 0.0) {
                d = (this.currentUpperRange[n2] - this.lowerRange[n2]) / (this.upperRange[n2] - this.lowerRange[n2]);
                d3 = (this.currentLowerRange[n2] - this.lowerRange[n2]) / (this.upperRange[n2] - this.lowerRange[n2]);
            }
            int n9 = (int)Math.round((double)n8 + d3 * (double)rectangle.width);
            int n10 = (int)Math.round((double)n8 + d * (double)rectangle.width);
            this.rangeAdjusterBounds[n].setBounds(n9, n7 - 3, n10 - n9, 7);
            this.paintBox(graphics, Color.lightGray, n9, n7 - 3, n10 - n9, 6, false);
            graphics.setColor(Color.gray);
            graphics.drawLine(n9 + 2, n7 - 2, n9 + 2, n7 + 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n10 - 2, n7 - 2, n10 - 2, n7 + 2);
        }
    }

    private void paintBox(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(bl ? color.darker() : Color.white);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4);
        graphics.setColor(bl ? Color.white : color.darker());
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4);
    }

    void paintTitle(Graphics graphics, Dimension dimension) {
        if (this.chartTitleOn && this.chartTitle != null) {
            Font font = this.getFont("titleFont");
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Dimension dimension2 = this.getLabelSize(this.chartTitle, font);
            int n = dimension.width / 2 - dimension2.width / 2;
            int n2 = fontMetrics.getMaxAscent() + 2;
            graphics.setColor(this.getForeground());
            this.paintLabel(graphics, this.chartTitle, n, n2, dimension2, 2, 0);
        }
    }

    public boolean isRangeOn(int n) {
        return this.rangeOn[Math.min(1, Math.max(0, n))];
    }

    public void set3DModeOn(boolean bl) {
        this.display3dOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    void setServletModeOn(boolean bl) {
        this.servletModeOn = bl;
    }

    public Chart(int n) {
        this(1, n);
    }

    public Chart(int n, int n2) {
        this.chartData = new ChartData(n, n2);
        this.sampleLabelColors = new Color[n2];
        this.seriesLabelColors = new Color[n];
        this.listeners = new Vector();
        this.labels = new Hashtable();
        this.labelFonts = new Hashtable();
        this.labelAngles = new Hashtable();
        this.graphInsets = new Insets(-1, -1, -1, -1);
        this.preferredSize = new Dimension(300, 200);
        this.targetsLabel = new Hashtable();
        this.targetsValue = new Hashtable();
        this.targetsColor = new Hashtable();
        this.targetsStyle = new Hashtable();
        this.chartDataBounds = new Rectangle();
        this.depth3dPoint = new Point();
        this.depth3d = -1;
        this.rangeAdjusterBounds = new Rectangle[2];
        this.rangeAdjusterBounds[0] = new Rectangle();
        this.rangeAdjusterBounds[1] = new Rectangle();
        this.sampleScrollerBounds = new Rectangle();
        RESIZE_CURSOR = new Cursor(8);
        RESIZE_HOR_CURSOR = new Cursor(11);
        MOVE_CURSOR = new Cursor(12);
        DEFAULT_CURSOR = new Cursor(0);
        this.legend = new Rectangle();
        this.angledLabelCache = new Hashtable();
        this.labelSizeCache = new Hashtable();
        this.valueLabelsOn = new boolean[n];
        this.rangeOn = new boolean[2];
        this.rangePosition = new int[this.rangeOn.length];
        this.upperRange = new double[this.rangeOn.length];
        this.lowerRange = new double[this.rangeOn.length];
        this.currentUpperRange = new double[this.rangeOn.length];
        this.currentLowerRange = new double[this.rangeOn.length];
        this.rangeDecimalCount = new int[this.rangeOn.length];
        this.rangeColor = new Color[this.rangeOn.length];
        this.zeroLine = new int[this.rangeOn.length];
        this.seriesRange = new int[n];
        this.rangeAdjusterOn = new boolean[this.rangeOn.length];
        this.rangeAdjusterPosition = new int[this.rangeOn.length];
        this.rangeAdjusterPosition[0] = 1;
        this.rangeAdjusterPosition[1] = 1;
        this.rangeAdjusted = new int[this.rangeOn.length];
        this.rangeAdjusted[1] = 1;
        this.overlayCharts = new Vector();
        this.legendSelection = new boolean[n > 1 ? n : n2];
        this.enableEvents(49L);
        try {
            Chart2 chart2 = new Chart2();
            chart2.checkColorDepth(this);
        }
        catch (Throwable throwable) {}
        this.reset();
    }

    public synchronized void setSampleLabelColor(int n, Color color) {
        try {
            this.sampleLabelColors[n] = color;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid sample index: " + n);
        }
    }

    public Color getSampleLabelColor(int n) {
        try {
            return this.sampleLabelColors[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid sample index: " + n);
        }
    }

    public synchronized void setSampleCount(int n) {
        this.chartData.setSampleCount(n);
        this.checkDataIntegrity();
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized int getSampleCount() {
        return this.chartData.getSampleCount();
    }

    public void setSampleDecimalCount(int n, int n2) {
        if (n == -1) {
            int n3 = 0;
            while (n3 < this.sampleDecimalCount.length) {
                this.sampleDecimalCount[n3] = n2;
                ++n3;
            }
        } else if (n >= 0 && n < this.sampleDecimalCount.length) {
            this.sampleDecimalCount[n] = n2;
        }
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.autoRepaint();
    }

    public int getSampleDecimalCount(int n) {
        if (n >= 0 && n < this.sampleDecimalCount.length) {
            return this.sampleDecimalCount[n];
        }
        return 0;
    }

    public boolean isSelected(int n, int n2) {
        return this.chartData.isSelected(n, n2);
    }

    public int getLastSelectedSample() {
        return this.lastSelectedSample;
    }

    public void setSampleDecimalCount(int n) {
        this.setSampleDecimalCount(0, n);
    }

    public int getSampleDecimalCount() {
        return this.getSampleDecimalCount(0);
    }

    public final void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getForeground());
        if (!this.colorDepth) {
            if (this.chartData.hasChangedSince(this.lastRenderTime)) {
                this.hasChanged = true;
            }
            this.render(graphics);
            this.hasChanged = false;
            this.lastRenderTime = System.currentTimeMillis();
        }
        if (this.chartColorDepth != 983763298745252854L) {
            if (this.colorDepth) {
                this.paintChart(graphics);
            } else {
                graphics.setColor(Color.red);
                graphics.fill3DRect(1, dimension.height - 10, 9, 9, true);
            }
        }
    }

    synchronized void setRelativeRangeIndex(int n, double d) {
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        double d2 = this.getHighestValue(n);
        double d3 = this.getLowestValue(n);
        if (n == 0) {
            Enumeration enumeration = this.targetsValue.elements();
            while (enumeration.hasMoreElements()) {
                d2 = Math.max((Double)enumeration.nextElement(), d2);
            }
        }
        if (d2 > 0.0) {
            this.setRange(n, d2 * Math.abs(d));
        } else if (d2 == 0.0 && d3 == 0.0) {
            this.setRange(n, 100.0);
        } else {
            this.setRange(n, 0.0);
        }
    }

    public boolean isPrintAsBitmap() {
        return this.printAsBitmap;
    }

    public int addOverlayChart(Chart chart) {
        if (chart != null) {
            chart.overlayChartOn = true;
            chart.parentChart = this;
            this.overlayCharts.addElement(chart);
            chart.setRange(0, this.getRange(0));
            chart.setRange(1, this.getRange(1));
            chart.setLowerRange(0, this.getLowerRange(0));
            chart.setLowerRange(1, this.getLowerRange(1));
            this.hasChanged = true;
            this.autoRepaint();
            return this.overlayCharts.lastIndexOf(chart);
        }
        return 0;
    }

    public int getLastSelectedSeries() {
        return this.lastSelectedSeries;
    }

    public synchronized void setRange(int n, double d) {
        n = Math.max(0, Math.min(1, n));
        this.upperRange[n] = d;
        this.currentUpperRange[n] = Math.min(this.currentUpperRange[n], d);
        if (!this.rangeAdjusterOn[n]) {
            this.currentUpperRange[n] = d;
        }
        int n2 = 0;
        while (n2 < this.overlayCharts.size()) {
            ((Chart)this.overlayCharts.elementAt(n2)).setRange(n, d);
            ++n2;
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized double getRange(int n) {
        return this.upperRange[Math.max(0, Math.min(1, n))];
    }

    public void setCurrentLowerRange(int n, double d) {
        n = Math.min(this.currentLowerRange.length - 1, Math.max(0, n));
        int n2 = this.rangeAdjusted[n];
        if (n == 0 && n2 == 2) {
            n2 = 0;
        } else if (n == 1 && n2 == 2) {
            n2 = 1;
        }
        d = Math.max(this.lowerRange[n2], d);
        this.currentLowerRange[n2] = d = Math.min(this.currentUpperRange[n2], d);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getCurrentLowerRange(int n) {
        n = Math.min(this.currentLowerRange.length - 1, Math.max(0, n));
        return this.currentLowerRange[n];
    }

    public synchronized void setRange(double d) {
        this.setRange(0, d);
    }

    public synchronized long getRange() {
        return (long)this.getRange(0);
    }

    public void setCurrentLowerRange(double d) {
        this.setCurrentLowerRange(0, d);
    }

    public double getCurrentLowerRange() {
        return this.getCurrentLowerRange(0);
    }

    public Rectangle getDataBounds(Rectangle rectangle) {
        this.chartDataBounds.setBounds(rectangle);
        double d = 1.0 - this.leftScrollerFactor - this.rightScrollerFactor;
        if (this.gridAlignment == 1) {
            this.chartDataBounds.width = (int)Math.round((double)rectangle.width / d);
            this.chartDataBounds.x = (int)((long)this.chartDataBounds.x - Math.round(this.leftScrollerFactor * (double)this.chartDataBounds.width));
        } else {
            this.chartDataBounds.height = (int)Math.round((double)rectangle.height / d);
            this.chartDataBounds.y = (int)((long)this.chartDataBounds.y - Math.round(this.leftScrollerFactor * (double)this.chartDataBounds.height));
        }
        return this.chartDataBounds;
    }

    void calculateZeroLines(Rectangle rectangle) {
        int n = 0;
        while (n < this.zeroLine.length) {
            if (this.currentUpperRange[n] - this.currentLowerRange[n] != 0.0) {
                int n2;
                if (this.gridAlignment == 1) {
                    n2 = (int)Math.round((double)rectangle.height * (this.currentUpperRange[n] / (this.currentUpperRange[n] - this.currentLowerRange[n])));
                    this.zeroLine[n] = rectangle.y + n2;
                } else {
                    n2 = (int)Math.round((double)rectangle.width * (this.currentUpperRange[n] / (this.currentUpperRange[n] - this.currentLowerRange[n])));
                    this.zeroLine[n] = rectangle.x + rectangle.width - n2;
                }
            }
            ++n;
        }
    }

    public void setRangePosition(int n, int n2) {
        this.rangePosition[Math.min((int)1, (int)Math.max((int)0, (int)n))] = Math.min(1, Math.max(0, n2));
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getRangePosition(int n) {
        return this.rangePosition[Math.min(1, Math.max(0, n))];
    }

    public boolean isTitleOn() {
        return this.chartTitleOn;
    }

    public void setLegendPosition(int n) {
        if (n != 2 && n != 3 && n != 0 && n != 1) {
            throw new IllegalArgumentException("Should be TOP, BOTTOM, LEFT, or RIGHT");
        }
        this.legendPosition = n;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void addImage(String string, Image image) {
        if (string != null) {
            try {
                if (image != null) {
                    this.images.put(string, image);
                    this.imageTracker.addImage(image, 0);
                    this.imageTracker.waitForAll();
                } else {
                    this.images.remove(string);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void setRangeDecimalCount(int n, int n2) {
        n = Math.max(0, Math.min(this.rangeDecimalCount.length - 1, n));
        this.rangeDecimalCount[n] = n2;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getRangeDecimalCount(int n) {
        n = Math.max(0, Math.min(this.rangeDecimalCount.length - 1, n));
        return this.rangeDecimalCount[n];
    }

    public void setRangeDecimalCount(int n) {
        this.setRangeDecimalCount(0, n);
    }

    public void setLegendColors(Color[] colorArray) {
        this.legendColors = colorArray;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color[] getLegendColors() {
        return this.legendColors;
    }

    public int getRangeDecimalCount() {
        return this.getRangeDecimalCount(0);
    }

    public static void main(String[] stringArray) {
        System.out.println("EasyCharts " + Chart.getVersion());
        System.out.println("Copyright 1998-2001, ObjectPlanet, Inc.");
    }

    public void setSampleColor(int n, Color color) {
        if (n < 0) {
            throw new IllegalArgumentException("Negativ index");
        }
        this.sampleColors[n % this.sampleColors.length] = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getSampleColor(int n) {
        Color color = DEFAULT_SAMPLE_COLORS[n % DEFAULT_SAMPLE_COLORS.length];
        if (this.sampleColors != null && this.sampleColors.length > 0 && (color = this.sampleColors[n % this.sampleColors.length]) == null) {
            int n2 = Math.min(this.sampleColors.length, DEFAULT_SAMPLE_COLORS.length);
            color = DEFAULT_SAMPLE_COLORS[n % n2];
        }
        return color;
    }

    private void paintSampleScroller(Graphics graphics, Rectangle rectangle) {
        if (this.gridAlignment == 1) {
            int n = rectangle.x;
            int n2 = rectangle.y + rectangle.height + 1;
            if (this.display3dOn) {
                n -= this.depth3dPoint.x;
                n2 -= this.depth3dPoint.y;
            }
            this.sampleScrollerBounds.x = n;
            this.sampleScrollerBounds.y = n2;
            this.sampleScrollerBounds.height = 8;
            this.sampleScrollerBounds.width = rectangle.width;
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(n, n2 + 4, n + this.sampleScrollerBounds.width, n2 + 4);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(n, n2 + 5, n + this.sampleScrollerBounds.width, n2 + 5);
            this.paintBox(graphics, Color.lightGray, n, n2, 8, 8, this.leftPushed);
            int n3 = this.leftPushed ? 1 : 0;
            graphics.setColor(Color.black);
            graphics.drawLine((n += n3) + 3, n2 + 4, n + 3, n2 + 4);
            graphics.drawLine(n + 4, n2 + 3, n + 4, n2 + 5);
            graphics.drawLine(n + 5, n2 + 2, n + 5, n2 + 6);
            n = this.sampleScrollerBounds.x + this.sampleScrollerBounds.width - 8;
            this.paintBox(graphics, Color.lightGray, n, n2, 8, 8, this.rightPushed);
            int n4 = this.rightPushed ? 1 : 0;
            graphics.setColor(Color.black);
            graphics.drawLine((n += n4) + 3, n2 + 2, n + 3, n2 + 6);
            graphics.drawLine(n + 4, n2 + 3, n + 4, n2 + 5);
            graphics.drawLine(n + 5, n2 + 4, n + 5, n2 + 4);
            this.sampleScrollerSpace = this.sampleScrollerBounds.width - 18;
            int n5 = (int)Math.round(this.leftScrollerFactor * (double)this.sampleScrollerSpace);
            n = rectangle.x + 9 + n5;
            if (this.display3dOn) {
                n -= this.depth3dPoint.x;
            }
            int n6 = this.sampleScrollerSpace - (int)Math.round(this.rightScrollerFactor * (double)this.sampleScrollerSpace) - n5;
            this.leftAdjusterPos = n;
            this.rightAdjusterPos = this.leftAdjusterPos + n6;
            this.paintBox(graphics, Color.lightGray, n, n2, n6, 8, false);
            graphics.setColor(Color.gray);
            graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 7);
            graphics.setColor(Color.white);
            graphics.drawLine(n + n6 - 2, n2 + 1, n + n6 - 2, n2 + 7);
        } else {
            int n = rectangle.x - 10;
            int n7 = rectangle.y;
            if (this.display3dOn) {
                n -= this.depth3dPoint.x;
                n7 -= this.depth3dPoint.y;
            }
            this.sampleScrollerBounds.x = n;
            this.sampleScrollerBounds.y = n7;
            this.sampleScrollerBounds.height = rectangle.height;
            this.sampleScrollerBounds.width = 7;
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(n + 4, n7, n + 4, n7 + this.sampleScrollerBounds.height);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(n + 5, n7, n + 5, n7 + this.sampleScrollerBounds.height);
            this.paintBox(graphics, Color.lightGray, n, n7, 8, 8, this.leftPushed);
            int n8 = this.leftPushed ? 1 : 0;
            graphics.setColor(Color.black);
            graphics.drawLine(n + 4, (n7 += n8) + 3, n + 4, n7 + 3);
            graphics.drawLine(n + 3, n7 + 4, n + 5, n7 + 4);
            graphics.drawLine(n + 2, n7 + 5, n + 6, n7 + 5);
            n7 = this.sampleScrollerBounds.y + this.sampleScrollerBounds.height - 8;
            this.paintBox(graphics, Color.lightGray, n, n7, 8, 8, this.rightPushed);
            int n9 = this.rightPushed ? 1 : 0;
            graphics.setColor(Color.black);
            graphics.drawLine(n + 4, (n7 += n9) + 5, n + 4, n7 + 5);
            graphics.drawLine(n + 3, n7 + 4, n + 5, n7 + 4);
            graphics.drawLine(n + 2, n7 + 3, n + 6, n7 + 3);
            this.sampleScrollerSpace = this.sampleScrollerBounds.height - 18;
            int n10 = (int)Math.round(this.leftScrollerFactor * (double)this.sampleScrollerSpace);
            n7 = rectangle.y + 9 + n10;
            if (this.display3dOn) {
                n7 -= this.depth3dPoint.y;
            }
            int n11 = this.sampleScrollerSpace - (int)Math.round(this.rightScrollerFactor * (double)this.sampleScrollerSpace) - n10;
            this.leftAdjusterPos = n7;
            this.rightAdjusterPos = this.leftAdjusterPos + n11;
            this.paintBox(graphics, Color.lightGray, n, n7, 8, n11, false);
            graphics.setColor(Color.gray);
            graphics.drawLine(n + 1, n7 + 2, n + 7, n7 + 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n + 1, n7 + n11 - 2, n + 7, n7 + n11 - 2);
        }
    }

    public void setLegendOn(boolean bl) {
        this.legendOn = bl;
        this.legend.width = 0;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setSamples(int n, ChartSample[] chartSampleArray) {
        this.chartData.setSamples(n, chartSampleArray);
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.labelSizeCache.clear();
        this.autoRepaint();
    }

    public synchronized ChartSample[] getSamples(int n) {
        return this.chartData.getSamples(n);
    }

    protected abstract void renderData(Graphics var1, Rectangle var2, Rectangle var3);

    public double getMinValue(int n) {
        return this.chartData.getMinValue(n);
    }

    public String toString() {
        return this.getTitle();
    }

    public void setGridLine(int n, double d) {
        if (n >= this.maxGridLineCount || n < 0) {
            throw new IllegalArgumentException("Illegal vertical grid line index: " + n);
        }
        if (this.gridLines == null) {
            this.gridLines = new double[n + 1];
            int n2 = 0;
            while (n2 < this.gridLines.length) {
                this.gridLines[n2] = -2.147483648E9;
                ++n2;
            }
        }
        if (n >= this.gridLines.length) {
            double[] dArray = new double[n + 1];
            System.arraycopy(this.gridLines, 0, dArray, 0, this.gridLines.length);
            int n3 = this.gridLines.length;
            while (n3 < dArray.length - 1) {
                dArray[n3] = -2.147483648E9;
                ++n3;
            }
            this.gridLines = dArray;
        }
        this.gridLines[n] = d;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public double getGridLine(int n) {
        if (this.gridLines == null || n >= this.gridLines.length) {
            return -2.147483648E9;
        }
        return this.gridLines[n];
    }

    public void setChartData(ChartData chartData) {
        this.chartData = chartData;
        this.checkDataIntegrity();
        this.autoRepaint();
    }

    public ChartData getChartData() {
        return this.chartData;
    }

    public boolean isRangeLabelsOn() {
        return this.rangeLabelsOn;
    }

    public void setValueLabelsOn(boolean bl) {
        this.setValueLabelsOn(-1, bl);
    }

    public void setValueLabelsOn(int n, boolean bl) {
        if (n >= 0 && n < this.valueLabelsOn.length) {
            this.valueLabelsOn[n] = bl;
        } else if (n == -1) {
            int n2 = 0;
            while (n2 < this.valueLabelsOn.length) {
                this.valueLabelsOn[n2] = bl;
                ++n2;
            }
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized void setRelativeRange(double d) {
        this.setRelativeRangeIndex(0, d);
    }

    public synchronized void setRelativeRange(double d, double d2) {
        this.setRelativeRange(0, d, d2);
    }

    public synchronized void setRelativeRange(int n, double d, double d2) {
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        double d3 = this.getHighestValue(n);
        double d4 = this.getLowestValue(n);
        if (n == 0) {
            Enumeration enumeration = this.targetsValue.elements();
            while (enumeration.hasMoreElements()) {
                d3 = Math.max((Double)enumeration.nextElement(), d3);
            }
        }
        if (d3 > 0.0) {
            d2 = Math.abs(d2);
            double d5 = d3 * Math.abs(d);
            if (d2 % 1.0 == 0.0) {
                if (d5 % d2 == 0.0) {
                    this.setRange(n, d5);
                } else {
                    this.setRange(n, d5 - d5 % d2 + d2);
                }
            } else {
                double d6 = 0.0;
                while (d6 < d5) {
                    d6 += d2;
                }
                this.setRange(n, d6);
            }
        } else if (d3 == 0.0 && d4 == 0.0) {
            this.setRange(n, 100.0);
        } else {
            this.setRange(n, 0.0);
        }
    }

    public void setFont(String string, Font font) {
        if (string == null || string.trim().length() < 1) {
            return;
        }
        string = string.trim().toLowerCase();
        if (font != null) {
            this.labelFonts.put(string, font);
        } else {
            this.labelFonts.remove(string);
        }
        this.labelSizeCache.clear();
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Font getFont(String string) {
        Font font;
        if (string == null) {
            this.getFont();
        }
        if ((font = (Font)this.labelFonts.get(string.trim().toLowerCase())) != null) {
            return font;
        }
        return this.getFont();
    }

    public synchronized void setSeriesLabels(String[] stringArray) {
        this.chartData.setSeriesLabels(stringArray);
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized String[] getSeriesLabels() {
        return this.chartData.getSeriesLabels();
    }

    public synchronized double getFloatRange() {
        return this.getRange(0);
    }

    private void adjustRange(Chart chart, int n, double d, double d2) {
        double d3;
        if (d != 0.0) {
            d3 = chart.lowerRange[n] + d * (chart.upperRange[n] - chart.lowerRange[n]);
            if (d3 > chart.currentLowerRange[n]) {
                chart.currentUpperRange[n] = d3;
            }
            chart.currentUpperRange[n] = Math.min(chart.currentUpperRange[n], chart.upperRange[n]);
        }
        if (d2 != 0.0) {
            d3 = chart.lowerRange[n] + d2 * (chart.upperRange[n] - chart.lowerRange[n]);
            if (d3 < chart.currentUpperRange[n]) {
                chart.currentLowerRange[n] = d3;
            }
            chart.currentLowerRange[n] = Math.max(chart.currentLowerRange[n], chart.lowerRange[n]);
        }
    }

    protected abstract void render(Graphics var1);

    void render(Graphics graphics, boolean bl) {
    }

    public boolean isValueLabelsOn() {
        return this.isValueLabelsOn(-1);
    }

    public void setRangeOn(int n, boolean bl) {
        this.rangeOn[Math.min((int)1, (int)Math.max((int)0, (int)n))] = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isValueLabelsOn(int n) {
        if (n >= 0 && n < this.valueLabelsOn.length) {
            return this.valueLabelsOn[n];
        }
        if (n == -1) {
            int n2 = 0;
            while (n2 < this.valueLabelsOn.length) {
                if (!this.valueLabelsOn[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void setSelection(int n, int n2, boolean bl) {
        this.setSelection(n, n2, bl, false);
    }

    private void setSelection(int n, int n2, boolean bl, boolean bl2) {
        this.chartData.setSelection(n, n2, bl, bl2);
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        int n3 = 0;
        while (n3 < this.legendSelection.length) {
            this.legendSelection[n3] = false;
            ++n3;
        }
        if (n2 == -1 && n == -1) {
            if (this.selectedSample != null) {
                this.notifyListeners(this, 2, this.selectedSample);
                this.selectedSample = null;
            }
        } else if (n2 == -1 && n != -1) {
            ChartSample chartSample = new ChartSample(n2);
            chartSample.setSeries(n);
            if (this.legendLabels != null && n < this.legendLabels.length && this.legendLabels[n] != null) {
                chartSample.setLabel(this.legendLabels[n]);
            } else if (n >= 0 && n < this.getSeriesCount()) {
                chartSample.setLabel(this.getSeriesLabel(n));
            }
            if (bl) {
                this.lastSelectedSeries = n;
                if ((this.selectedSample == null || chartSample.getSeries() != this.selectedSample.getSeries()) && this.selectedSample != null) {
                    this.notifyListeners(this, 2, this.selectedSample);
                }
                this.notifyListeners(this, 1, chartSample);
                this.selectedSample = chartSample;
            } else {
                this.notifyListeners(this, 2, chartSample);
                if (chartSample == this.selectedSample) {
                    this.selectedSample = null;
                }
            }
        } else if (n2 != -1 && n != -1) {
            ChartSample chartSample = this.getSample(n, n2);
            if (bl) {
                this.lastSelectedSample = n2;
                this.lastSelectedSeries = n;
                if (this.selectedSample != null && chartSample != this.selectedSample) {
                    this.notifyListeners(this, 2, this.selectedSample);
                }
                this.notifyListeners(this, 1, chartSample);
                this.selectedSample = chartSample;
            } else {
                this.notifyListeners(this, 2, chartSample);
                if (chartSample == this.selectedSample) {
                    this.selectedSample = null;
                }
            }
        }
        if (this.getSeriesCount() > 1 || this.multiSeriesOn) {
            if (n >= 0 && n < this.legendSelection.length) {
                this.legendSelection[n] = bl;
            }
        } else if (n2 >= 0 && n2 < this.legendSelection.length) {
            this.legendSelection[n2] = bl;
        }
        if (n2 == -1) {
            int n4 = 0;
            while (n4 < this.overlayCharts.size()) {
                Chart chart = (Chart)this.overlayCharts.elementAt(n4);
                if (chart != null) {
                    chart.setSelection(n, n2, bl, bl2);
                }
                ++n4;
            }
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    int getValuePosition(int n, double d, Rectangle rectangle) {
        n = Math.min(this.upperRange.length - 1, Math.max(0, n));
        int n2 = 0;
        int n3 = 0;
        if (this.gridAlignment == 1) {
            if (this.currentUpperRange[n] - this.currentLowerRange[n] != 0.0) {
                n2 = (int)((double)rectangle.height * (this.currentUpperRange[n] / (this.currentUpperRange[n] - this.currentLowerRange[n])));
            }
            n3 = rectangle.y + n2;
        } else {
            if (this.currentUpperRange[n] - this.currentLowerRange[n] != 0.0) {
                n2 = (int)((double)rectangle.width * (this.currentUpperRange[n] / (this.currentUpperRange[n] - this.currentLowerRange[n])));
            }
            n3 = rectangle.x + rectangle.width - n2;
        }
        int n4 = 0;
        if (this.currentUpperRange[n] - this.currentLowerRange[n] != 0.0) {
            n4 = this.gridAlignment == 1 ? (int)((double)n3 - (double)rectangle.height * (d / (this.currentUpperRange[n] - this.currentLowerRange[n]))) : (int)((double)n3 + (double)rectangle.width * (d / (this.currentUpperRange[n] - this.currentLowerRange[n])));
        }
        return n4;
    }

    public final void print(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getForeground());
        this.hasChanged = true;
        this.render(graphics, this.printAsBitmap);
        if (this.chartColorDepth != 983763298745252854L) {
            graphics.setColor(Color.red);
            graphics.fill3DRect(1, dimension.height - 10, 9, 9, true);
        }
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setRangeColor(int n, Color color) {
        this.rangeColor[Math.min((int)1, (int)Math.max((int)0, (int)n))] = color != null ? color : this.chartForeground;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getRangeColor(int n) {
        if (this.rangeColor[n = Math.min(1, Math.max(0, n))] != null) {
            return this.rangeColor[n];
        }
        return this.chartForeground;
    }

    public synchronized void setSeriesLabelColor(int n, Color color) {
        try {
            this.seriesLabelColors[n] = color;
            this.hasChanged = true;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
    }

    public Color getSeriesLabelColor(int n) {
        try {
            return this.seriesLabelColors[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
    }

    public synchronized ChartSample getSample(Object object) {
        return this.chartData.getSample(object);
    }

    public synchronized int appendSample(int n, ChartSample chartSample, boolean bl) {
        int n2 = this.chartData.appendSample(n, chartSample, bl);
        this.checkDataIntegrity();
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.autoRepaint();
        return n2;
    }

    public synchronized void setSample(int n, int n2, ChartSample chartSample) {
        this.chartData.setSample(n, n2, chartSample);
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.autoRepaint();
    }

    public void setLabel(String string, String string2) {
        if (string != null && string.length() > 0) {
            string = string.toLowerCase().trim();
            if (string2 != null && string2.length() > 0) {
                this.labels.put(string, string2);
            } else {
                this.labels.remove(string);
            }
            this.hasChanged = true;
            if (this.getLabelAngle(string + "Angle") != 0) {
                this.angledLabelCache.clear();
            }
            this.autoRepaint();
        }
    }

    public String getLabel(String string) {
        if (string != null) {
            string = string.toLowerCase().trim();
            return (String)this.labels.get(string);
        }
        return null;
    }

    public synchronized ChartSample getSample(int n, int n2) {
        return this.chartData.getSample(n, n2);
    }

    public void setValueLinesColor(Color color) {
        this.valueLinesColor = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getValueLinesColor() {
        return this.valueLinesColor;
    }

    String getTargetLabel(String string) {
        String string2 = "";
        int n = (Integer)this.targetsStyle.get(string);
        double d = (Double)this.targetsValue.get(string);
        String string3 = this.formatNumber(d, this.rangeDecimalCount[0]);
        if (this.getLabel("rangeLabelPrefix") != null) {
            string3 = this.getLabel("rangeLabelPrefix") + string3;
        }
        if (this.getLabel("rangeLabelPostfix") != null) {
            string3 = string3 + this.getLabel("rangeLabelPostfix");
        }
        switch (n) {
            case 0: {
                string2 = "";
                break;
            }
            case 1: {
                string2 = string;
                break;
            }
            case 2: {
                string2 = string3;
                break;
            }
            case 3: {
                if (this.rangePosition[0] == 0) {
                    string2 = string + " " + string3;
                    break;
                }
                string2 = string3 + " " + string;
                break;
            }
        }
        return string2;
    }

    public void setLegendColor(int n, Color color) {
        if (this.legendColors == null) {
            this.legendColors = new Color[n + 1];
        }
        if (n >= this.legendColors.length) {
            Color[] colorArray = new Color[n + 1];
            System.arraycopy(this.legendColors, 0, colorArray, 0, this.legendColors.length);
            this.legendColors = colorArray;
        }
        this.legendColors[n] = color;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color getLegendColor(int n) {
        if (this.legendColors == null || n >= this.legendColors.length) {
            return this.getSampleColor(n);
        }
        return this.legendColors[n];
    }

    public void setRangeAdjusted(int n, int n2) {
        n = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, n));
        this.rangeAdjusted[n] = n2 = Math.min(2, Math.max(0, n2));
    }

    public int getRangeAdjusted(int n) {
        n = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, n));
        return this.rangeAdjusted[n];
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.depth3d > -1) {
            this.depth3dPoint.x = this.depth3d;
            this.depth3dPoint.y = -this.depth3d;
        }
        if (aWTEvent instanceof MouseEvent && (this.rangeAdjusterOn[0] || this.rangeAdjusterOn[1] || this.sampleScrollerOn)) {
            this.handleAdjusters(aWTEvent);
        }
        switch (aWTEvent.getID()) {
            case 501: {
                if (this.colorDepth) {
                    this.colorDepth = false;
                    this.repaint();
                    break;
                }
                if (this.chartColorDepth == 983763298745252854L) break;
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Dimension dimension = this.getSize();
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n <= 0 || n >= 11 || n2 <= dimension.height - 11 || n2 >= dimension.height) break;
                this.colorDepth = true;
                this.repaint();
                break;
            }
            case 502: {
                int n = ((MouseEvent)aWTEvent).getX();
                int n3 = ((MouseEvent)aWTEvent).getY();
                int n4 = this.currentBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0);
                int n5 = this.currentBounds.x + this.currentBounds.width;
                int n6 = this.currentBounds.y + this.currentBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0);
                ChartSample chartSample = this.checkSelection(new Point(n, n3));
                if (chartSample != null) {
                    int n7 = chartSample.getSeries();
                    if (n7 < 0) break;
                    this.setSelection(n7, chartSample.getIndex(), true, true);
                    this.repaint();
                    break;
                }
                if (n < n4 || n > n5 || n3 < this.currentBounds.y || n3 > n6 || this.selectedSample == null) break;
                this.setSelection(-1, -1, false, true);
                this.repaint();
                break;
            }
            case 101: {
                if (this.offscreen != null) {
                    this.offscreen.flush();
                }
                if (!this.externalGraphicsOn) {
                    this.offscreen = null;
                }
                this.hasChanged = true;
                this.repaint();
                break;
            }
        }
        super.processEvent(aWTEvent);
    }

    public double getMaxValue(int n) {
        return this.chartData.getMaxValue(n);
    }

    double getHighestValue(int n) {
        n = Math.min(this.rangeOn.length - 1, Math.max(0, n));
        int n2 = this.getSeriesCount();
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            if (this.getSeriesRange(n3) == n) {
                d = Math.max(this.getMaxValue(n3), d);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.overlayCharts.size()) {
            Chart chart = (Chart)this.overlayCharts.elementAt(n3);
            if (chart != null && !(chart instanceof PieChart) && chart.getSeriesRange(n3) == n) {
                d = Math.max(chart.getMaxValue(-1), d);
            }
            ++n3;
        }
        return d;
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void adjustRangeSlide(Chart chart, int n, double d) {
        double d2 = d * (chart.upperRange[n] - chart.lowerRange[n]);
        double d3 = d2 = this.gridAlignment == 1 ? d2 : -d2;
        if (d2 >= 0.0) {
            d2 = Math.min(chart.upperRange[n] - chart.currentUpperRange[n], d2);
        } else if (chart.currentLowerRange[n] + d2 < chart.lowerRange[n]) {
            d2 = chart.lowerRange[n] - chart.currentLowerRange[n];
        }
        int n2 = n;
        chart.currentUpperRange[n2] = chart.currentUpperRange[n2] + d2;
        int n3 = n;
        chart.currentLowerRange[n3] = chart.currentLowerRange[n3] + d2;
    }

    public void setTitle(String string) {
        if (this.chartTitle != null) {
            Long l = new Long(this.chartTitle.hashCode() + this.getFont("titleFont").hashCode());
            this.labelSizeCache.remove(l);
        }
        this.chartTitle = string;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public String getTitle() {
        return this.chartTitle;
    }

    public void removeOverlayChart(int n) {
        if (n < 0 || n >= this.overlayCharts.size()) {
            throw new IllegalArgumentException("invalid overlay index: " + n);
        }
        this.overlayCharts.removeElementAt(n);
        this.hasChanged = true;
        this.autoRepaint();
    }

    private void transform(double d, double d2, double d3, double d4, double[] dArray) {
        dArray[0] = d * d3 + d2 * d4;
        dArray[1] = d * d4 - d2 * d3;
    }

    private void paintChart(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.height / 2;
        int n2 = dimension.width / 2;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Dialog", 1, 20));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = "EasyCharts " + Chart.getVersion();
        graphics.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n - 20);
        graphics.setFont(new Font("Dialog", 0, 10));
        fontMetrics = graphics.getFontMetrics();
        string = "(banner removed with registration)";
        graphics.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n - 5);
        string = "Copyright 1998-2001";
        graphics.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n + 10);
        string = "ObjectPlanet, Inc. - all rights reserved";
        graphics.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n + 25);
        string = "www.objectplanet.com/EasyCharts";
        graphics.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n + 40);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener != null) {
            this.listeners.addElement(itemListener);
        }
    }

    public synchronized void setSampleValues(int n, double[] dArray) {
        this.chartData.setSampleValues(n, dArray);
        this.hasChanged = true;
        if (this.isValueLabelsOn(n) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.angledLabelCache.clear();
        }
        this.labelSizeCache.clear();
        this.autoRepaint();
    }

    public synchronized double[] getSampleValues(int n) {
        return this.chartData.getSampleValues(n);
    }

    private void getAngledBounds(double d, double d2, Rectangle rectangle, double[] dArray) {
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        int n = 0;
        do {
            int n2 = 0;
            do {
                this.transform(d, d2, rectangle.x + n2 * rectangle.width, rectangle.y + n * rectangle.height, dArray);
                d3 = Math.min(d3, dArray[0]);
                d4 = Math.min(d4, dArray[1]);
                d5 = Math.max(d5, dArray[0]);
                d6 = Math.max(d6, dArray[1]);
            } while (++n2 <= 1);
        } while (++n <= 1);
        rectangle.x = (int)Math.floor(d3);
        rectangle.y = (int)Math.floor(d4);
        rectangle.width = (int)Math.ceil(d5) - rectangle.x + 1;
        rectangle.height = (int)Math.ceil(d6) - rectangle.y + 1;
    }

    public void setGridLineColors(Color[] colorArray) {
        this.gridLineColors = colorArray;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color[] getGridLineColors() {
        return this.gridLineColors;
    }

    public void setRangeAdjusterPosition(int n, int n2) {
        n = Math.min(this.rangeAdjusterPosition.length - 1, Math.max(0, n));
        this.rangeAdjusterPosition[n] = Math.min(1, Math.max(0, n2));
    }

    public int getRangeAdjusterPosition(int n) {
        n = Math.min(this.rangeAdjusterPosition.length - 1, Math.max(0, n));
        return this.rangeAdjusterPosition[n];
    }

    public void setTitleOn(boolean bl) {
        this.chartTitleOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isAutomaticRepaintOn() {
        return this.automaticRepaintOn;
    }

    public boolean isOverlayChartOn(int n) {
        Chart chart = this.getOverlayChart(n);
        if (chart != null) {
            return chart.overlayChartOn;
        }
        return false;
    }

    public void reset() {
        this.automaticRepaintOn = true;
        this.chartTitle = null;
        this.chartTitleOn = false;
        this.sampleDecimalCount = new int[this.getSeriesCount()];
        this.legendOn = false;
        this.legendPosition = 1;
        this.display3dOn = false;
        this.chartBackground = Color.white;
        this.chartForeground = Color.black;
        this.setForeground(Color.black);
        this.setBackground(new Color(231, 221, 231));
        this.labelFonts.clear();
        this.labels.clear();
        this.legendLabels = null;
        this.graphInsets.right = -1;
        this.graphInsets.left = -1;
        this.graphInsets.bottom = -1;
        this.graphInsets.top = -1;
        this.preferredSize.setSize(300, 200);
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.setFont(new Font("Arial", 0, 11));
        this.setFont("titleFont", new Font("Arial", 1, 14));
        this.setSampleColors(null);
        this.seriesRange = new int[this.getSeriesCount()];
        this.valueLabelsOn = new boolean[this.getSeriesCount()];
        this.barLabelStyle = 0;
        this.overlayChartOn = true;
        this.servletModeOn = false;
        this.externalGraphicsOn = false;
        this.floatingOnLegendOn = true;
        this.gridLinesOn = false;
        this.maxValueLineCount = Integer.MAX_VALUE;
        this.maxGridLineCount = 1000;
        this.gridLines = null;
        this.leftSampleAxisRange = 0.0;
        this.rightSampleAxisRange = 100.0;
        this.gridLineColors = null;
        this.valueLinesOn = false;
        this.valueLinesColor = Color.lightGray;
        this.rangeLabelsOn = true;
        this.rangeOn[0] = true;
        this.rangeOn[1] = false;
        this.rangeDecimalCount[0] = 0;
        this.rangeDecimalCount[1] = 0;
        this.sampleLabelsOn = false;
        this.targetsLabel.clear();
        this.targetsValue.clear();
        this.targetsColor.clear();
        this.targetsStyle.clear();
        this.gridAlignment = 1;
        this.rangeAdjusterOn[0] = false;
        this.rangeAdjusterOn[1] = false;
        this.sampleScrollerOn = false;
        this.setSize(300, 200);
        this.upperRange[0] = 100.0;
        this.upperRange[1] = 100.0;
        this.lowerRange[0] = 0.0;
        this.lowerRange[1] = 0.0;
        this.currentUpperRange[0] = 100.0;
        this.currentUpperRange[1] = 100.0;
        this.currentLowerRange[0] = 0.0;
        this.currentLowerRange[1] = 0.0;
        this.rangeAdjusterPosition[0] = 1;
        this.rangeAdjusterPosition[1] = 1;
        this.adjusterIndex = -1;
        this.rangePosition[0] = 0;
        this.rangePosition[1] = 1;
        this.rangeAdjusted[0] = 0;
        this.rangeAdjusted[1] = 1;
        this.gridLinesOn = false;
        this.gridLines = null;
        this.gridLineColors = null;
        this.leftSampleAxisRange = 0.0;
        this.rightSampleAxisRange = 100.0;
        this.images = new Hashtable();
        this.imageTracker = new MediaTracker(this);
    }

    public void setMaxValueLineCount(int n) {
        this.maxValueLineCount = n > -1 ? n : Integer.MAX_VALUE;
        this.hasChanged = true;
        this.autoRepaint();
    }

    public int getMaxValueLineCount() {
        if (this.maxValueLineCount != Integer.MAX_VALUE) {
            return this.maxValueLineCount;
        }
        return -1;
    }

    public synchronized void setSeriesCount(int n) {
        this.chartData.setSeriesCount(n);
        this.checkDataIntegrity();
        this.hasChanged = true;
        this.autoRepaint();
    }

    public synchronized int getSeriesCount() {
        return this.chartData.getSeriesCount();
    }

    public void setSampleColors(Color[] colorArray) {
        if (colorArray != null) {
            this.sampleColors = colorArray;
        } else {
            this.sampleColors = new Color[DEFAULT_SAMPLE_COLORS.length];
            System.arraycopy(DEFAULT_SAMPLE_COLORS, 0, this.sampleColors, 0, this.sampleColors.length);
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public Color[] getSampleColors() {
        return this.sampleColors;
    }

    protected ChartSample checkSelection(Point point) {
        if (this.legendBounds == null || !this.legendOn) {
            return null;
        }
        ChartSample chartSample = null;
        int n = this.getSeriesCount();
        int n2 = this.getSampleCount();
        if (n2 > 0 && n > 0) {
            int n3 = 0;
            while (n3 < this.legendBounds.length) {
                if (this.legendBounds[n3] != null && this.legendBounds[n3].contains(point)) {
                    if (n > 1 || this.chartType.equals("line") || this.multiSeriesOn) {
                        chartSample = new ChartSample(-1);
                        chartSample.setSeries(n3);
                        break;
                    }
                    chartSample = this.getSample(0, n3);
                    break;
                }
                ++n3;
            }
        }
        return chartSample;
    }

    public void setFloatingOnLegendOn(boolean bl) {
        this.floatingOnLegendOn = bl;
        this.hasChanged = true;
        this.autoRepaint();
    }

    Dimension getImageSize(String string) {
        Image image;
        Dimension dimension = new Dimension(0, 0);
        if (string != null && (image = (Image)this.images.get(string)) != null) {
            dimension.width = image.getWidth(this);
            dimension.height = image.getHeight(this);
        }
        return dimension;
    }

    Dimension getLabelSize(String string, Font font) {
        Long l;
        Dimension dimension;
        if (string == null) {
            return new Dimension(0, 0);
        }
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        if ((dimension = (Dimension)this.labelSizeCache.get(l = new Long(string.hashCode() + font.hashCode()))) == null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            dimension = new Dimension();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = (String)stringTokenizer.nextElement();
                    dimension.height += fontMetrics.getMaxAscent() + 1;
                    if (string2 == null) continue;
                    dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(string2));
                }
            }
            dimension.height = Math.max(dimension.height, fontMetrics.getMaxAscent());
            if (!this.servletModeOn) {
                this.labelSizeCache.put(l, dimension);
            }
        }
        return dimension;
    }

    Dimension getAngledLabelSize(Dimension dimension, int n) {
        if (n == 90 || n == 270) {
            return new Dimension(dimension.height, dimension.width);
        }
        if (n > 0 && n < 360) {
            double d = Math.sin((double)n * (Math.PI / 180));
            double d2 = Math.cos((double)n * (Math.PI / 180));
            int n2 = (int)(Math.abs((double)dimension.width * d2) + Math.abs((double)dimension.height * d) + 0.5);
            int n3 = (int)(Math.abs((double)dimension.width * d) + Math.abs((double)dimension.height * d2) + 0.5);
            return new Dimension(n2, n3);
        }
        return dimension;
    }

    public synchronized void setSampleLabel(int n, String string) {
        String string2 = this.getSampleLabel(n);
        this.chartData.setSampleLabel(n, string);
        this.hasChanged = true;
        if (this.sampleLabelsOn && (this.getLabelAngle("sampleLabelAngle") != 0 || this.getLabelAngle("barLabelAngle") != 0)) {
            this.angledLabelCache.clear();
        }
        if (string2 != null) {
            Long l = new Long(string2.hashCode() + this.getFont("sampleLabelFont").hashCode());
            this.labelSizeCache.remove(l);
            l = new Long(string2.hashCode() + this.getFont("barLabelFont").hashCode());
            this.labelSizeCache.remove(l);
        }
        this.autoRepaint();
    }

    public synchronized String getSampleLabel(int n) {
        return this.chartData.getSampleLabel(n);
    }

    static {
        DEFAULT_SAMPLE_COLORS = new Color[]{new Color(132, 130, 255), new Color(132, 32, 99), new Color(255, 255, 198), new Color(165, 227, 231), new Color(99, 0, 132), new Color(255, 130, 132), new Color(0, 130, 198), new Color(198, 195, 255), new Color(0, 0, 132), new Color(255, 0, 255), new Color(255, 255, 0), new Color(0, 255, 255), new Color(132, 0, 132), new Color(132, 0, 0), new Color(0, 130, 132), new Color(0, 0, 255), new Color(0, 207, 255), new Color(107, 255, 255), new Color(206, 255, 206), new Color(255, 255, 156)};
    }

    public void setRangeAdjusterOn(int n, boolean bl) {
        n = Math.min(this.rangeAdjusterOn.length - 1, Math.max(0, n));
        this.rangeAdjusterOn[n] = bl;
        if (!bl) {
            int n2 = this.rangeAdjusted[n];
            if (n == 0 && n2 == 2) {
                n2 = 0;
            } else if (n == 1 && n2 == 2) {
                n2 = 1;
            }
            this.setCurrentRange(n, this.getRange(n2));
            this.setCurrentLowerRange(n, this.getLowerRange(n2));
        }
        this.hasChanged = true;
        this.autoRepaint();
    }

    public boolean isSampleScrollerOn() {
        return this.sampleScrollerOn;
    }

    protected synchronized void checkDataIntegrity() {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        int n2 = this.chartData.getSeriesCount();
        if (n2 != this.seriesLabelColors.length) {
            this.hasChanged = true;
            objectArray2 = new Color[n2];
            n = Math.min(n2, this.seriesLabelColors.length);
            System.arraycopy(this.seriesLabelColors, 0, objectArray2, 0, n);
            this.seriesLabelColors = objectArray2;
            objectArray = new int[n2];
            System.arraycopy(this.seriesRange, 0, objectArray, 0, Math.min(this.seriesRange.length, objectArray.length));
            this.seriesRange = (int[])objectArray;
            int[] nArray = new int[n2];
            System.arraycopy(this.sampleDecimalCount, 0, nArray, 0, Math.min(this.sampleDecimalCount.length, nArray.length));
            this.sampleDecimalCount = nArray;
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.valueLabelsOn, 0, blArray, 0, Math.min(this.valueLabelsOn.length, blArray.length));
            this.valueLabelsOn = blArray;
        }
        if (this.legendSelection.length != (objectArray2 = this.getLegendLabels()).length) {
            boolean[] blArray = new boolean[objectArray2.length];
            System.arraycopy(this.legendSelection, 0, blArray, 0, Math.min(this.legendSelection.length, blArray.length));
            this.legendSelection = blArray;
        }
        if ((n = this.chartData.getSampleCount()) != this.sampleLabelColors.length) {
            this.hasChanged = true;
            objectArray = new Color[n];
            int n3 = Math.min(n, this.sampleLabelColors.length);
            System.arraycopy(this.sampleLabelColors, 0, objectArray, 0, n3);
            this.sampleLabelColors = objectArray;
        }
    }

    public void setRangeAdjusterOn(boolean bl) {
        this.setRangeAdjusterOn(0, bl);
    }

    public void setPreferredSize(int n, int n2) {
        this.preferredSize.width = n;
        this.preferredSize.height = n2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 70);
    }

    private void handleAdjusters(AWTEvent aWTEvent) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        this.insideLeftButton = false;
        this.insideRightButton = false;
        int n = -1;
        int n2 = ((MouseEvent)aWTEvent).getX();
        int n3 = ((MouseEvent)aWTEvent).getY();
        if (this.gridAlignment == 1) {
            bl = n2 >= this.rangeAdjusterBounds[0].x && n2 <= this.rangeAdjusterBounds[0].x + this.rangeAdjusterBounds[0].width;
            bl = bl && n3 >= this.rangeAdjusterBounds[0].y - 3 && n3 <= this.rangeAdjusterBounds[0].y + this.rangeAdjusterBounds[0].height + 1;
            bl2 = n3 >= this.rangeAdjusterBounds[0].y - 1 && n3 <= this.rangeAdjusterBounds[0].y + 3;
            bl3 = n3 >= this.rangeAdjusterBounds[0].y + this.rangeAdjusterBounds[0].height - 3 && n3 <= this.rangeAdjusterBounds[0].y + this.rangeAdjusterBounds[0].height + 1;
            int n4 = n = bl || bl2 || bl3 ? 0 : -1;
            if (this.rangeAdjusterOn[1] && !bl) {
                bl = n2 >= this.rangeAdjusterBounds[1].x && n2 <= this.rangeAdjusterBounds[1].x + this.rangeAdjusterBounds[1].width;
                bl = bl && n3 >= this.rangeAdjusterBounds[1].y - 3 && n3 <= this.rangeAdjusterBounds[1].y + this.rangeAdjusterBounds[1].height + 1;
                bl2 = n3 >= this.rangeAdjusterBounds[1].y - 1 && n3 <= this.rangeAdjusterBounds[1].y + 3;
                bl3 = n3 >= this.rangeAdjusterBounds[1].y + this.rangeAdjusterBounds[1].height - 3 && n3 <= this.rangeAdjusterBounds[1].y + this.rangeAdjusterBounds[1].height + 1;
                n = bl || bl2 || bl3 ? 1 : -1;
            }
        } else {
            bl = n3 >= this.rangeAdjusterBounds[0].y && n3 <= this.rangeAdjusterBounds[0].y + this.rangeAdjusterBounds[0].height;
            bl = bl && n2 >= this.rangeAdjusterBounds[0].x - 1 && n2 <= this.rangeAdjusterBounds[0].x + this.rangeAdjusterBounds[0].width + 1;
            bl3 = n2 >= this.rangeAdjusterBounds[0].x - 1 && n2 <= this.rangeAdjusterBounds[0].x + 2;
            bl2 = n2 >= this.rangeAdjusterBounds[0].x + this.rangeAdjusterBounds[0].width - 3 && n2 <= this.rangeAdjusterBounds[0].x + this.rangeAdjusterBounds[0].width + 1;
            int n5 = n = bl || bl2 || bl3 ? 0 : -1;
            if (this.rangeAdjusterOn[1] && !bl) {
                bl = n3 >= this.rangeAdjusterBounds[1].y && n3 <= this.rangeAdjusterBounds[1].y + this.rangeAdjusterBounds[1].height;
                bl = bl && n2 >= this.rangeAdjusterBounds[1].x - 1 && n2 <= this.rangeAdjusterBounds[1].x + this.rangeAdjusterBounds[1].width + 1;
                bl3 = n2 >= this.rangeAdjusterBounds[1].x - 1 && n2 <= this.rangeAdjusterBounds[1].x + 2;
                bl2 = n2 >= this.rangeAdjusterBounds[1].x + this.rangeAdjusterBounds[1].width - 3 && n2 <= this.rangeAdjusterBounds[1].x + this.rangeAdjusterBounds[1].width + 1;
                int n6 = n = bl || bl2 || bl3 ? 1 : -1;
            }
        }
        if (!bl) {
            int n7;
            int n8;
            if (this.gridAlignment == 1) {
                n8 = this.sampleScrollerBounds.x;
                n7 = this.sampleScrollerBounds.x + this.sampleScrollerBounds.width;
                bl4 = n3 >= this.sampleScrollerBounds.y && n3 <= this.sampleScrollerBounds.y + this.sampleScrollerBounds.height;
                bl4 = bl4 && n2 >= n8 - 1 && n2 <= n7 + 1;
                this.insideLeftButton = bl4 && n2 >= n8 && n2 <= n8 + 8;
                this.insideRightButton = bl4 && n2 >= n7 - 8 && n2 <= n7;
                bl5 = bl4 && n2 >= this.leftAdjusterPos && n2 <= this.leftAdjusterPos + 2;
                bl6 = bl4 && n2 >= this.rightAdjusterPos - 2 && n2 <= this.rightAdjusterPos;
                bl4 = bl4 && n2 > this.leftAdjusterPos + 2 && n2 < this.rightAdjusterPos - 2;
            } else {
                n8 = this.sampleScrollerBounds.y;
                n7 = this.sampleScrollerBounds.y + this.sampleScrollerBounds.height;
                bl4 = n2 >= this.sampleScrollerBounds.x && n2 <= this.sampleScrollerBounds.x + this.sampleScrollerBounds.width;
                bl4 = bl4 && n3 >= n8 - 1 && n3 <= n7 + 1;
                this.insideLeftButton = bl4 && n3 >= n8 && n3 <= n8 + 8;
                this.insideRightButton = bl4 && n3 >= n7 - 8 && n3 <= n7;
                bl5 = bl4 && n3 >= this.leftAdjusterPos && n3 <= this.leftAdjusterPos + 2;
                bl6 = bl4 && n3 >= this.rightAdjusterPos - 2 && n3 <= this.rightAdjusterPos;
                bl4 = bl4 && n3 > this.leftAdjusterPos + 2 && n3 < this.rightAdjusterPos - 2;
            }
        }
        switch (aWTEvent.getID()) {
            case 503: {
                if ((bl2 || bl3) && bl) {
                    this.setCursor(this.gridAlignment == 1 ? RESIZE_CURSOR : RESIZE_HOR_CURSOR);
                    break;
                }
                if (bl) {
                    this.setCursor(MOVE_CURSOR);
                    break;
                }
                if (bl5 || bl6) {
                    this.setCursor(this.gridAlignment == 1 ? RESIZE_HOR_CURSOR : RESIZE_CURSOR);
                    break;
                }
                if (bl4) {
                    this.setCursor(MOVE_CURSOR);
                    break;
                }
                this.setCursor(DEFAULT_CURSOR);
                break;
            }
            case 501: {
                this.adjustingUpper = bl2 && bl;
                this.adjustingLower = bl3 && bl;
                this.slidingAdjuster = bl && !bl2 && !bl3;
                this.adjusterIndex = n;
                this.leftPushed = this.insideLeftButton;
                this.rightPushed = this.insideRightButton;
                this.adjustingLeft = bl5;
                this.adjustingRight = bl6;
                this.slidingScroller = bl4 && !bl5 && !bl6;
                this.lastAdjusterClick = this.gridAlignment == 1 ? n3 : n2;
                this.lastScrollerClick = this.gridAlignment == 1 ? n2 : n3;
                long l = System.currentTimeMillis();
                int n9 = this.getSampleCount();
                if (this.insideLeftButton) {
                    double d = (double)(this.chartDataBounds.width / n9) / (double)this.chartDataBounds.width;
                    if (this.gridAlignment == 0) {
                        d = (double)(this.chartDataBounds.height / n9) / (double)this.chartDataBounds.height;
                    }
                    d = Math.min(d, this.leftScrollerFactor);
                    this.leftScrollerFactor -= d;
                    this.rightScrollerFactor += d;
                    if (this.scrollerThread == null) {
                        this.scrollerThread = new Thread(this);
                        this.scrollerThread.start();
                    }
                } else if (this.insideRightButton) {
                    double d = (double)(this.chartDataBounds.width / n9) / (double)this.chartDataBounds.width;
                    if (this.gridAlignment == 0) {
                        d = (double)(this.chartDataBounds.height / n9) / (double)this.chartDataBounds.height;
                    }
                    d = Math.min(d, this.rightScrollerFactor);
                    this.leftScrollerFactor += d;
                    this.rightScrollerFactor -= d;
                    if (this.scrollerThread == null) {
                        this.scrollerThread = new Thread(this);
                        this.scrollerThread.start();
                    }
                } else if (bl4 && !this.insideLeftButton && !this.insideRightButton) {
                    if (l - this.lastClickTime < 350L) {
                        this.leftScrollerFactor = 0.0;
                        this.rightScrollerFactor = 0.0;
                    }
                } else if (bl && !bl2 && !bl3 && l - this.lastClickTime < 350L) {
                    int n10 = 0;
                    do {
                        int n11 = this.rangeAdjusted[this.adjusterIndex] > 1 ? n10 : this.rangeAdjusted[this.adjusterIndex];
                        this.currentUpperRange[n11] = this.upperRange[n11];
                        this.currentLowerRange[n11] = this.lowerRange[n11];
                        int n12 = 0;
                        while (n12 < this.overlayCharts.size()) {
                            Chart chart = (Chart)this.overlayCharts.elementAt(n12);
                            if (chart != null) {
                                chart.currentUpperRange[n11] = chart.upperRange[n11];
                                chart.currentLowerRange[n11] = chart.lowerRange[n11];
                            }
                            ++n12;
                        }
                    } while (++n10 < 2);
                }
                this.lastClickTime = l;
                this.hasChanged = true;
                this.repaint();
                break;
            }
            case 506: {
                int n13 = ((MouseEvent)aWTEvent).getY();
                if (this.gridAlignment == 0) {
                    n13 = ((MouseEvent)aWTEvent).getX();
                }
                Rectangle rectangle = this.currentBounds;
                double d = 0.0;
                if (this.adjustingUpper) {
                    if (this.gridAlignment == 1) {
                        this.setCursor(RESIZE_CURSOR);
                        n13 -= rectangle.y;
                        if (this.display3dOn && this.rangeAdjusterPosition[this.adjusterIndex] == 0) {
                            n13 += this.depth3dPoint.y;
                        }
                        d = 1.0 - (double)n13 / (double)rectangle.height;
                    } else {
                        this.setCursor(RESIZE_HOR_CURSOR);
                        n13 -= rectangle.x;
                        if (this.display3dOn && this.rangeAdjusterPosition[this.adjusterIndex] == 0) {
                            n13 += this.depth3dPoint.x;
                        }
                        d = (double)n13 / (double)rectangle.width;
                    }
                    if (this.rangeAdjusted[this.adjusterIndex] == 2) {
                        int n14 = 0;
                        do {
                            this.adjustRange(this, n14, d, 0.0);
                            int n15 = 0;
                            while (n15 < this.overlayCharts.size()) {
                                this.adjustRange((Chart)this.overlayCharts.elementAt(n15), n14, d, 0.0);
                                ++n15;
                            }
                        } while (++n14 < 2);
                    } else {
                        this.adjustRange(this, this.rangeAdjusted[this.adjusterIndex], d, 0.0);
                        int n16 = 0;
                        while (n16 < this.overlayCharts.size()) {
                            this.adjustRange((Chart)this.overlayCharts.elementAt(n16), this.rangeAdjusted[this.adjusterIndex], d, 0.0);
                            ++n16;
                        }
                    }
                } else if (this.adjustingLower) {
                    if (this.gridAlignment == 1) {
                        this.setCursor(RESIZE_CURSOR);
                        n13 -= rectangle.y;
                        if (this.display3dOn && this.rangeAdjusterPosition[this.adjusterIndex] == 0) {
                            n13 += this.depth3dPoint.y;
                        }
                        d = 1.0 - (double)n13 / (double)rectangle.height;
                    } else {
                        this.setCursor(RESIZE_HOR_CURSOR);
                        n13 -= rectangle.x;
                        if (this.display3dOn && this.rangeAdjusterPosition[this.adjusterIndex] == 0) {
                            n13 += this.depth3dPoint.x;
                        }
                        d = (double)n13 / (double)rectangle.width;
                    }
                    if (this.rangeAdjusted[this.adjusterIndex] == 2) {
                        int n17 = 0;
                        do {
                            this.adjustRange(this, n17, 0.0, d);
                            int n18 = 0;
                            while (n18 < this.overlayCharts.size()) {
                                this.adjustRange((Chart)this.overlayCharts.elementAt(n18), n17, 0.0, d);
                                ++n18;
                            }
                        } while (++n17 < 2);
                    } else {
                        this.adjustRange(this, this.rangeAdjusted[this.adjusterIndex], 0.0, d);
                        int n19 = 0;
                        while (n19 < this.overlayCharts.size()) {
                            this.adjustRange((Chart)this.overlayCharts.elementAt(n19), this.rangeAdjusted[this.adjusterIndex], 0.0, d);
                            ++n19;
                        }
                    }
                } else if (this.slidingAdjuster) {
                    this.setCursor(MOVE_CURSOR);
                    int n20 = this.lastAdjusterClick - n13;
                    d = this.gridAlignment == 1 ? (double)n20 / (double)rectangle.height : (double)n20 / (double)rectangle.width;
                    if (this.rangeAdjusted[this.adjusterIndex] == 2) {
                        int n21 = 0;
                        do {
                            this.adjustRangeSlide(this, n21, d);
                            int n22 = 0;
                            while (n22 < this.overlayCharts.size()) {
                                this.adjustRangeSlide((Chart)this.overlayCharts.elementAt(n22), n21, d);
                                ++n22;
                            }
                        } while (++n21 < 2);
                    } else {
                        this.adjustRangeSlide(this, this.rangeAdjusted[this.adjusterIndex], d);
                        int n23 = 0;
                        while (n23 < this.overlayCharts.size()) {
                            this.adjustRangeSlide((Chart)this.overlayCharts.elementAt(n23), this.rangeAdjusted[this.adjusterIndex], d);
                            ++n23;
                        }
                    }
                    this.lastAdjusterClick = n13;
                } else if (this.adjustingLeft) {
                    if (this.gridAlignment == 1) {
                        int n24 = this.sampleScrollerBounds.x + 8;
                        n13 = Math.max(((MouseEvent)aWTEvent).getX(), n24);
                        n13 = Math.min(n13, this.rightAdjusterPos - 8);
                        this.leftScrollerFactor = (double)(n13 - n24) / (double)this.sampleScrollerSpace;
                    } else {
                        int n25 = this.sampleScrollerBounds.y + 8;
                        n13 = Math.max(((MouseEvent)aWTEvent).getY(), n25);
                        n13 = Math.min(n13, this.rightAdjusterPos - 8);
                        this.leftScrollerFactor = (double)(n13 - n25) / (double)this.sampleScrollerSpace;
                    }
                } else if (this.adjustingRight) {
                    if (this.gridAlignment == 1) {
                        int n26 = this.sampleScrollerBounds.x + 8 + this.sampleScrollerSpace;
                        n13 = Math.min(((MouseEvent)aWTEvent).getX(), n26);
                        n13 = Math.max(n13, this.leftAdjusterPos + 6);
                        this.rightScrollerFactor = (double)(n26 - n13) / (double)this.sampleScrollerSpace;
                    } else {
                        int n27 = this.sampleScrollerBounds.y + 8 + this.sampleScrollerSpace;
                        n13 = Math.min(((MouseEvent)aWTEvent).getY(), n27);
                        n13 = Math.max(n13, this.leftAdjusterPos + 6);
                        this.rightScrollerFactor = (double)(n27 - n13) / (double)this.sampleScrollerSpace;
                    }
                } else if (this.slidingScroller) {
                    int n28 = this.gridAlignment == 1 ? n2 - this.lastScrollerClick : n3 - this.lastScrollerClick;
                    d = (double)n28 / (double)this.sampleScrollerSpace;
                    d = n28 > 0 ? Math.min(d, this.rightScrollerFactor) : -Math.min(-d, this.leftScrollerFactor);
                    this.leftScrollerFactor += d;
                    this.rightScrollerFactor -= d;
                    this.lastScrollerClick = this.gridAlignment == 1 ? n2 : n3;
                }
                this.hasChanged = true;
                this.repaint();
                break;
            }
            case 502: {
                this.slidingAdjuster = false;
                this.adjustingLower = false;
                this.adjustingUpper = false;
                this.adjusterIndex = -1;
                this.rightPushed = false;
                this.leftPushed = false;
                this.slidingScroller = false;
                this.adjustingRight = false;
                this.adjustingLeft = false;
                if (this.scrollerThread != null) {
                    this.scrollerThread.stop();
                    this.scrollerThread = null;
                }
                this.hasChanged = true;
                this.repaint();
                break;
            }
        }
    }

    void notifyListeners(Chart chart, int n, Object object) {
        if (this.listeners != null) {
            ItemEvent itemEvent = new ItemEvent(chart, 701, object, n);
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
            }
        }
    }
}

