/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;

public class BarChartApplet
extends ChartApplet {
    public BarChart chart;

    protected Chart createChart(String string) {
        if (string == null || string.equals("")) {
            string = "com.objectplanet.chart.BarChart";
        }
        try {
            Class<?> clazz = Class.forName(string);
            BarChart barChart = (BarChart)clazz.newInstance();
            return barChart;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: " + string);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Could not create an instance of teh class: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Illegal access, could not create an instance of class: " + string);
        }
        catch (ClassCastException classCastException) {
            System.out.println("The class " + string + ", does not extend from com.objectplanet.chart.LineChart");
        }
        return new BarChart();
    }

    private void initParameter(String string, String string2) {
        if (string2 != null) {
            this.setParameter(string, string2);
        }
    }

    public void setParameter(String string, String string2) {
        block43: {
            if (string == null || this.chart == null) {
                return;
            }
            if ((string = string.toLowerCase()).equals("barlabels")) {
                if (string2 != null && string2.length() > 0) {
                    String[] stringArray = this.getStringValues(ChartApplet.convertLineBreaks(string2));
                    this.chart.setBarLabels(stringArray);
                } else {
                    this.chart.setBarLabels(null);
                }
            } else if (string.equals("barlabelson")) {
                this.chart.setBarLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("barlabelstyle")) {
                if (string2 != null && string2.trim().toLowerCase().equals("floating")) {
                    this.chart.setBarLabelStyle(1);
                } else if (string2 != null && string2.trim().toLowerCase().equals("below_and_floating")) {
                    this.chart.setBarLabelStyle(2);
                } else {
                    this.chart.setBarLabelStyle(0);
                }
            } else if (string.equals("valuelabelstyle")) {
                if (string2 != null && string2.trim().toLowerCase().equals("inside")) {
                    this.chart.setValueLabelStyle(1);
                } else if (string2 != null && string2.trim().toLowerCase().equals("floating")) {
                    this.chart.setValueLabelStyle(2);
                } else {
                    this.chart.setValueLabelStyle(0);
                }
            } else if (string.equals("autolabelspacingon")) {
                this.chart.setAutoLabelSpacingOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("multicoloron")) {
                this.chart.setMultiColorOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("multiserieson")) {
                this.chart.setMultiSeriesOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("baroutlineoff")) {
                this.chart.setBarOutlineOn(string2 == null || !string2.trim().toLowerCase().equals("true"));
            } else if (string.startsWith("baroutlinecolor")) {
                this.chart.setBarOutlineColor(null);
                if (string2 != null) {
                    this.chart.setBarOutlineColor(ChartApplet.createColor(string2));
                }
            } else if (string.equals("baralignment")) {
                if (string2 != null && string2.trim().toLowerCase().equals("horizontal")) {
                    this.chart.setBarAlignment(0);
                } else {
                    this.chart.setBarAlignment(1);
                }
            } else if (string.equals("bartype")) {
                if (string2 != null && string2.trim().toLowerCase().equals("stacked")) {
                    this.chart.setBarType(1);
                } else {
                    this.chart.setBarType(0);
                }
            } else if (string.equals("barwidth")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.chart.setBarWidth(new Double(string2.trim()));
                        break block43;
                    }
                    this.chart.setBarWidth(0.4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid barWidth: " + string2);
                    this.chart.setBarWidth(0.4);
                }
            } else {
                super.setParameter(string, string2);
            }
        }
    }

    protected void refresh() {
        this.chart.repaint();
    }

    public void init() {
        this.chart = (BarChart)this.theChart;
        super.init();
        String string = this.getParameterPrefix();
        this.chart.setAutomaticRepaintOn(false);
        this.initParameter("sampleValues", this.getParameter(string + "sampleValues"));
        this.initParameter("barLabelsOn", this.getParameter(string + "barLabelsOn"));
        this.initParameter("barLabelStyle", this.getParameter(string + "barLabelStyle"));
        this.initParameter("valueLabelStyle", this.getParameter(string + "valueLabelStyle"));
        this.initParameter("autoLabelSpacingOn", this.getParameter(string + "autoLabelSpacingOn"));
        this.initParameter("multiColorOn", this.getParameter(string + "multiColorOn"));
        this.initParameter("multiSeriesOn", this.getParameter(string + "multiSeriesOn"));
        this.initParameter("barOutlineOff", this.getParameter(string + "barOutlineOff"));
        this.initParameter("barOutlineColor", this.getParameter(string + "barOutlineColor"));
        this.initParameter("barAlignment", this.getParameter(string + "barAlignment"));
        this.initParameter("barType", this.getParameter(string + "barType"));
        this.initParameter("barWidth", this.getParameter(string + "barWidth"));
        this.initParameter("barLabelFont", this.getParameter(string + "barLabelFont"));
        this.initParameter("valueLabelFont", this.getParameter(string + "valueLabelFont"));
        this.initParameter("barLabels", this.getParameter(string + "barLabels"));
        this.initParameter("sampleScrollerOn", this.getParameter(string + "sampleScrollerOn"));
        String string2 = this.getParameter(string + "overlay");
        this.initParameter(string + "overlay", this.getParameter(string + "overlay"));
        int n = string2 != null ? 1 : 0;
        string2 = this.getParameter(string + "overlay" + n);
        while (string2 != null) {
            this.initParameter(string + "overlay" + n, this.getParameter(string + "overlay" + n));
            string2 = this.getParameter(string + "overlay" + ++n);
        }
        this.setRangeParameters(true);
        int n2 = 0;
        while (n2 < this.overlayChartApplets.size()) {
            ChartApplet chartApplet = (ChartApplet)this.overlayChartApplets.elementAt(n2);
            if (chartApplet != null) {
                chartApplet.setRangeParameters(false);
            }
            ++n2;
        }
        this.chart.setAutomaticRepaintOn(true);
    }
}

